/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import org.slf4j.Logger;

public class PathfinderGoalSelector {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final PathfinderGoalWrapped NO_GOAL = new PathfinderGoalWrapped(Integer.MAX_VALUE, new PathfinderGoal(){

        @Override
        public boolean canUse() {
            return false;
        }
    }){

        @Override
        public boolean isRunning() {
            return false;
        }
    };
    private final Map<PathfinderGoal.Type, PathfinderGoalWrapped> lockedFlags = new EnumMap<PathfinderGoal.Type, PathfinderGoalWrapped>(PathfinderGoal.Type.class);
    private final Set<PathfinderGoalWrapped> availableGoals = Sets.newLinkedHashSet();
    private final Supplier<GameProfilerFiller> profiler;
    private final EnumSet<PathfinderGoal.Type> disabledFlags = EnumSet.noneOf(PathfinderGoal.Type.class);
    private int tickCount;
    private int newGoalRate = 3;

    public PathfinderGoalSelector(Supplier<GameProfilerFiller> var0) {
        this.profiler = var0;
    }

    public void addGoal(int var0, PathfinderGoal var1) {
        this.availableGoals.add(new PathfinderGoalWrapped(var0, var1));
    }

    @VisibleForTesting
    public void removeAllGoals(Predicate<PathfinderGoal> var0) {
        this.availableGoals.removeIf(var1 -> var0.test(var1.getGoal()));
    }

    public void removeGoal(PathfinderGoal var0) {
        this.availableGoals.stream().filter(var1 -> var1.getGoal() == var0).filter(PathfinderGoalWrapped::isRunning).forEach(PathfinderGoalWrapped::stop);
        this.availableGoals.removeIf(var1 -> var1.getGoal() == var0);
    }

    private static boolean goalContainsAnyFlags(PathfinderGoalWrapped var0, EnumSet<PathfinderGoal.Type> var1) {
        for (PathfinderGoal.Type var3 : var0.getFlags()) {
            if (!var1.contains((Object)var3)) continue;
            return true;
        }
        return false;
    }

    private static boolean goalCanBeReplacedForAllFlags(PathfinderGoalWrapped var0, Map<PathfinderGoal.Type, PathfinderGoalWrapped> var1) {
        for (PathfinderGoal.Type var3 : var0.getFlags()) {
            if (var1.getOrDefault((Object)var3, NO_GOAL).canBeReplacedBy(var0)) continue;
            return false;
        }
        return true;
    }

    public void tick() {
        GameProfilerFiller var0 = this.profiler.get();
        var0.push("goalCleanup");
        for (PathfinderGoalWrapped pathfinderGoalWrapped : this.availableGoals) {
            if (!pathfinderGoalWrapped.isRunning() || !PathfinderGoalSelector.goalContainsAnyFlags(pathfinderGoalWrapped, this.disabledFlags) && pathfinderGoalWrapped.canContinueToUse()) continue;
            pathfinderGoalWrapped.stop();
        }
        Iterator<Map.Entry<PathfinderGoal.Type, PathfinderGoalWrapped>> var1 = this.lockedFlags.entrySet().iterator();
        while (var1.hasNext()) {
            Map.Entry<PathfinderGoal.Type, PathfinderGoalWrapped> entry = var1.next();
            if (entry.getValue().isRunning()) continue;
            var1.remove();
        }
        var0.pop();
        var0.push("goalUpdate");
        for (PathfinderGoalWrapped pathfinderGoalWrapped : this.availableGoals) {
            if (pathfinderGoalWrapped.isRunning() || PathfinderGoalSelector.goalContainsAnyFlags(pathfinderGoalWrapped, this.disabledFlags) || !PathfinderGoalSelector.goalCanBeReplacedForAllFlags(pathfinderGoalWrapped, this.lockedFlags) || !pathfinderGoalWrapped.canUse()) continue;
            for (PathfinderGoal.Type var4 : pathfinderGoalWrapped.getFlags()) {
                PathfinderGoalWrapped var5 = this.lockedFlags.getOrDefault((Object)var4, NO_GOAL);
                var5.stop();
                this.lockedFlags.put(var4, pathfinderGoalWrapped);
            }
            pathfinderGoalWrapped.start();
        }
        var0.pop();
        this.tickRunningGoals(true);
    }

    public void tickRunningGoals(boolean var0) {
        GameProfilerFiller var1 = this.profiler.get();
        var1.push("goalTick");
        for (PathfinderGoalWrapped var3 : this.availableGoals) {
            if (!var3.isRunning() || !var0 && !var3.requiresUpdateEveryTick()) continue;
            var3.tick();
        }
        var1.pop();
    }

    public Set<PathfinderGoalWrapped> getAvailableGoals() {
        return this.availableGoals;
    }

    public Stream<PathfinderGoalWrapped> getRunningGoals() {
        return this.availableGoals.stream().filter(PathfinderGoalWrapped::isRunning);
    }

    public void setNewGoalRate(int var0) {
        this.newGoalRate = var0;
    }

    public void disableControlFlag(PathfinderGoal.Type var0) {
        this.disabledFlags.add(var0);
    }

    public void enableControlFlag(PathfinderGoal.Type var0) {
        this.disabledFlags.remove((Object)var0);
    }

    public void setControlFlag(PathfinderGoal.Type var0, boolean var1) {
        if (var1) {
            this.enableControlFlag(var0);
        } else {
            this.disableControlFlag(var0);
        }
    }
}

