/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.phys.Vec3D;

public class RamTarget
extends Behavior<Goat> {
    public static final int TIME_OUT_DURATION = 200;
    public static final float RAM_SPEED_FORCE_FACTOR = 1.65f;
    private final Function<Goat, UniformInt> getTimeBetweenRams;
    private final PathfinderTargetCondition ramTargeting;
    private final float speed;
    private final ToDoubleFunction<Goat> getKnockbackForce;
    private Vec3D ramDirection;
    private final Function<Goat, SoundEffect> getImpactSound;
    private final Function<Goat, SoundEffect> getHornBreakSound;

    public RamTarget(Function<Goat, UniformInt> var0, PathfinderTargetCondition var1, float var2, ToDoubleFunction<Goat> var3, Function<Goat, SoundEffect> var4, Function<Goat, SoundEffect> var5) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.RAM_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.RAM_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 200);
        this.getTimeBetweenRams = var0;
        this.ramTargeting = var1;
        this.speed = var2;
        this.getKnockbackForce = var3;
        this.getImpactSound = var4;
        this.getHornBreakSound = var5;
        this.ramDirection = Vec3D.ZERO;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, Goat var1) {
        return var1.getBrain().hasMemoryValue(MemoryModuleType.RAM_TARGET);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, Goat var1, long var2) {
        return var1.getBrain().hasMemoryValue(MemoryModuleType.RAM_TARGET);
    }

    @Override
    protected void start(WorldServer var0, Goat var1, long var2) {
        BlockPosition var4 = var1.blockPosition();
        BehaviorController<Goat> var5 = var1.getBrain();
        Vec3D var6 = var5.getMemory(MemoryModuleType.RAM_TARGET).get();
        this.ramDirection = new Vec3D((double)var4.getX() - var6.x(), 0.0, (double)var4.getZ() - var6.z()).normalize();
        var5.setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var6, this.speed, 0));
    }

    @Override
    protected void tick(WorldServer var0, Goat var1, long var2) {
        List<EntityLiving> var4 = var0.getNearbyEntities(EntityLiving.class, this.ramTargeting, var1, var1.getBoundingBox());
        BehaviorController<Goat> var5 = var1.getBrain();
        if (!var4.isEmpty()) {
            EntityLiving var6 = var4.get(0);
            var6.hurt(var0.damageSources().noAggroMobAttack(var1), (float)var1.getAttributeValue(GenericAttributes.ATTACK_DAMAGE));
            int var7 = var1.hasEffect(MobEffects.MOVEMENT_SPEED) ? var1.getEffect(MobEffects.MOVEMENT_SPEED).getAmplifier() + 1 : 0;
            int var8 = var1.hasEffect(MobEffects.MOVEMENT_SLOWDOWN) ? var1.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() + 1 : 0;
            float var9 = 0.25f * (float)(var7 - var8);
            float var10 = MathHelper.clamp(var1.getSpeed() * 1.65f, 0.2f, 3.0f) + var9;
            float var11 = var6.isDamageSourceBlocked(var0.damageSources().mobAttack(var1)) ? 0.5f : 1.0f;
            var6.knockback((double)(var11 * var10) * this.getKnockbackForce.applyAsDouble(var1), this.ramDirection.x(), this.ramDirection.z());
            this.finishRam(var0, var1);
            var0.playSound(null, var1, this.getImpactSound.apply(var1), SoundCategory.NEUTRAL, 1.0f, 1.0f);
        } else if (this.hasRammedHornBreakingBlock(var0, var1)) {
            var0.playSound(null, var1, this.getImpactSound.apply(var1), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            boolean var6 = var1.dropHorn();
            if (var6) {
                var0.playSound(null, var1, this.getHornBreakSound.apply(var1), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
            this.finishRam(var0, var1);
        } else {
            boolean var8;
            Optional<MemoryTarget> var6 = var5.getMemory(MemoryModuleType.WALK_TARGET);
            Optional<Vec3D> var7 = var5.getMemory(MemoryModuleType.RAM_TARGET);
            boolean bl = var8 = var6.isEmpty() || var7.isEmpty() || var6.get().getTarget().currentPosition().closerThan(var7.get(), 0.25);
            if (var8) {
                this.finishRam(var0, var1);
            }
        }
    }

    private boolean hasRammedHornBreakingBlock(WorldServer var0, Goat var1) {
        Vec3D var2 = var1.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
        BlockPosition var3 = BlockPosition.containing(var1.position().add(var2));
        return var0.getBlockState(var3).is(TagsBlock.SNAPS_GOAT_HORN) || var0.getBlockState(var3.above()).is(TagsBlock.SNAPS_GOAT_HORN);
    }

    protected void finishRam(WorldServer var0, Goat var1) {
        var0.broadcastEntityEvent(var1, (byte)59);
        var1.getBrain().setMemory(MemoryModuleType.RAM_COOLDOWN_TICKS, this.getTimeBetweenRams.apply(var1).sample(var0.random));
        var1.getBrain().eraseMemory(MemoryModuleType.RAM_TARGET);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (Goat)entityLiving, l2);
    }
}

