/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom2;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.behavior.LongJumpUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;

public class LongJumpToRandomPos<E extends EntityInsentient>
extends Behavior<E> {
    protected static final int FIND_JUMP_TRIES = 20;
    private static final int PREPARE_JUMP_DURATION = 40;
    protected static final int MIN_PATHFIND_DISTANCE_TO_VALID_JUMP = 8;
    private static final int TIME_OUT_DURATION = 200;
    private static final List<Integer> ALLOWED_ANGLES = Lists.newArrayList((Object[])new Integer[]{65, 70, 75, 80});
    private final UniformInt timeBetweenLongJumps;
    protected final int maxLongJumpHeight;
    protected final int maxLongJumpWidth;
    protected final float maxJumpVelocity;
    protected List<a> jumpCandidates = Lists.newArrayList();
    protected Optional<Vec3D> initialPosition = Optional.empty();
    @Nullable
    protected Vec3D chosenJump;
    protected int findJumpTries;
    protected long prepareJumpStart;
    private final Function<E, SoundEffect> getJumpSound;
    private final BiPredicate<E, BlockPosition> acceptableLandingSpot;

    public LongJumpToRandomPos(UniformInt var0, int var1, int var2, float var3, Function<E, SoundEffect> var4) {
        this(var0, var1, var2, var3, var4, LongJumpToRandomPos::defaultAcceptableLandingSpot);
    }

    public static <E extends EntityInsentient> boolean defaultAcceptableLandingSpot(E var0, BlockPosition var1) {
        BlockPosition var3;
        World var2 = var0.level();
        return var2.getBlockState(var3 = var1.below()).isSolidRender(var2, var3) && var0.getPathfindingMalus(PathfinderNormal.getBlockPathTypeStatic(var2, var1.mutable())) == 0.0f;
    }

    public LongJumpToRandomPos(UniformInt var0, int var1, int var2, float var3, Function<E, SoundEffect> var4, BiPredicate<E, BlockPosition> var5) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LONG_JUMP_MID_JUMP, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 200);
        this.timeBetweenLongJumps = var0;
        this.maxLongJumpHeight = var1;
        this.maxLongJumpWidth = var2;
        this.maxJumpVelocity = var3;
        this.getJumpSound = var4;
        this.acceptableLandingSpot = var5;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityInsentient var1) {
        boolean var2;
        boolean bl = var2 = var1.onGround() && !var1.isInWater() && !var1.isInLava() && !var0.getBlockState(var1.blockPosition()).is(Blocks.HONEY_BLOCK);
        if (!var2) {
            var1.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, this.timeBetweenLongJumps.sample(var0.random) / 2);
        }
        return var2;
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityInsentient var1, long var2) {
        boolean var4;
        boolean bl = var4 = this.initialPosition.isPresent() && this.initialPosition.get().equals(var1.position()) && this.findJumpTries > 0 && !var1.isInWaterOrBubble() && (this.chosenJump != null || !this.jumpCandidates.isEmpty());
        if (!var4 && var1.getBrain().getMemory(MemoryModuleType.LONG_JUMP_MID_JUMP).isEmpty()) {
            var1.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, this.timeBetweenLongJumps.sample(var0.random) / 2);
            var1.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        }
        return var4;
    }

    @Override
    protected void start(WorldServer var0, E var12, long var2) {
        this.chosenJump = null;
        this.findJumpTries = 20;
        this.initialPosition = Optional.of(((Entity)var12).position());
        BlockPosition var4 = ((Entity)var12).blockPosition();
        int var5 = var4.getX();
        int var6 = var4.getY();
        int var7 = var4.getZ();
        this.jumpCandidates = BlockPosition.betweenClosedStream(var5 - this.maxLongJumpWidth, var6 - this.maxLongJumpHeight, var7 - this.maxLongJumpWidth, var5 + this.maxLongJumpWidth, var6 + this.maxLongJumpHeight, var7 + this.maxLongJumpWidth).filter(var1 -> !var1.equals(var4)).map(var1 -> new a(var1.immutable(), MathHelper.ceil(var4.distSqr((BaseBlockPosition)var1)))).collect(Collectors.toCollection(Lists::newArrayList));
    }

    @Override
    protected void tick(WorldServer var0, E var1, long var2) {
        if (this.chosenJump != null) {
            if (var2 - this.prepareJumpStart >= 40L) {
                ((Entity)var1).setYRot(((EntityInsentient)var1).yBodyRot);
                ((EntityLiving)var1).setDiscardFriction(true);
                double var4 = this.chosenJump.length();
                double var6 = var4 + (double)((EntityLiving)var1).getJumpBoostPower();
                ((Entity)var1).setDeltaMovement(this.chosenJump.scale(var6 / var4));
                ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.LONG_JUMP_MID_JUMP, true);
                var0.playSound(null, (Entity)var1, this.getJumpSound.apply(var1), SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }
        } else {
            --this.findJumpTries;
            this.pickCandidate(var0, var1, var2);
        }
    }

    protected void pickCandidate(WorldServer var0, E var1, long var2) {
        while (!this.jumpCandidates.isEmpty()) {
            Vec3D var7;
            Vec3D var8;
            a var5;
            BlockPosition var6;
            Optional<a> var4 = this.getJumpCandidate(var0);
            if (var4.isEmpty() || !this.isAcceptableLandingPosition(var0, var1, var6 = (var5 = var4.get()).getJumpTarget()) || (var8 = this.calculateOptimalJumpVector((EntityInsentient)var1, var7 = Vec3D.atCenterOf(var6))) == null) continue;
            ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorTarget(var6));
            NavigationAbstract var9 = ((EntityInsentient)var1).getNavigation();
            PathEntity var10 = var9.createPath(var6, 0, 8);
            if (var10 != null && var10.canReach()) continue;
            this.chosenJump = var8;
            this.prepareJumpStart = var2;
            return;
        }
    }

    protected Optional<a> getJumpCandidate(WorldServer var0) {
        Optional<a> var1 = WeightedRandom2.getRandomItem(var0.random, this.jumpCandidates);
        var1.ifPresent(this.jumpCandidates::remove);
        return var1;
    }

    private boolean isAcceptableLandingPosition(WorldServer var0, E var1, BlockPosition var2) {
        BlockPosition var3 = ((Entity)var1).blockPosition();
        int var4 = var3.getX();
        int var5 = var3.getZ();
        if (var4 == var2.getX() && var5 == var2.getZ()) {
            return false;
        }
        return this.acceptableLandingSpot.test(var1, var2);
    }

    @Nullable
    protected Vec3D calculateOptimalJumpVector(EntityInsentient var0, Vec3D var1) {
        ArrayList var2 = Lists.newArrayList(ALLOWED_ANGLES);
        Collections.shuffle(var2);
        Iterator iterator = var2.iterator();
        while (iterator.hasNext()) {
            int var4 = (Integer)iterator.next();
            Optional<Vec3D> var5 = LongJumpUtil.calculateJumpVectorForAngle(var0, var1, this.maxJumpVelocity, var4, true);
            if (!var5.isPresent()) continue;
            return var5.get();
        }
        return null;
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityInsentient)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (E)((EntityInsentient)entityLiving), l2);
    }

    public static class a
    extends WeightedEntry.a {
        private final BlockPosition jumpTarget;

        public a(BlockPosition var0, int var1) {
            super(var1);
            this.jumpTarget = var0;
        }

        public BlockPosition getJumpTarget() {
            return this.jumpTarget;
        }
    }
}

