/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.effect.AttributeModifierTemplate;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class MobEffectList {
    private final Map<AttributeBase, AttributeModifierTemplate> attributeModifiers = Maps.newHashMap();
    private final MobEffectInfo category;
    private final int color;
    @Nullable
    private String descriptionId;
    private Supplier<MobEffect.a> factorDataFactory = () -> null;
    private final Holder.c<MobEffectList> builtInRegistryHolder = BuiltInRegistries.MOB_EFFECT.createIntrusiveHolder(this);

    protected MobEffectList(MobEffectInfo var0, int var1) {
        this.category = var0;
        this.color = var1;
    }

    public Optional<MobEffect.a> createFactorData() {
        return Optional.ofNullable(this.factorDataFactory.get());
    }

    public void applyEffectTick(EntityLiving var0, int var1) {
    }

    public void applyInstantenousEffect(@Nullable Entity var0, @Nullable Entity var1, EntityLiving var2, int var3, double var4) {
        this.applyEffectTick(var2, var3);
    }

    public boolean shouldApplyEffectTickThisTick(int var0, int var1) {
        return false;
    }

    public void onEffectStarted(EntityLiving var0, int var1) {
    }

    public boolean isInstantenous() {
        return false;
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = SystemUtils.makeDescriptionId("effect", BuiltInRegistries.MOB_EFFECT.getKey(this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public IChatBaseComponent getDisplayName() {
        return IChatBaseComponent.translatable(this.getDescriptionId());
    }

    public MobEffectInfo getCategory() {
        return this.category;
    }

    public int getColor() {
        return this.color;
    }

    public MobEffectList addAttributeModifier(AttributeBase var0, String var1, double var2, AttributeModifier.Operation var4) {
        this.attributeModifiers.put(var0, new a(UUID.fromString(var1), var2, var4));
        return this;
    }

    public MobEffectList setFactorDataFactory(Supplier<MobEffect.a> var0) {
        this.factorDataFactory = var0;
        return this;
    }

    public Map<AttributeBase, AttributeModifierTemplate> getAttributeModifiers() {
        return this.attributeModifiers;
    }

    public void removeAttributeModifiers(AttributeMapBase var0) {
        for (Map.Entry<AttributeBase, AttributeModifierTemplate> var2 : this.attributeModifiers.entrySet()) {
            AttributeModifiable var3 = var0.getInstance(var2.getKey());
            if (var3 == null) continue;
            var3.removeModifier(var2.getValue().getAttributeModifierId());
        }
    }

    public void addAttributeModifiers(AttributeMapBase var0, int var1) {
        for (Map.Entry<AttributeBase, AttributeModifierTemplate> var3 : this.attributeModifiers.entrySet()) {
            AttributeModifiable var4 = var0.getInstance(var3.getKey());
            if (var4 == null) continue;
            var4.removeModifier(var3.getValue().getAttributeModifierId());
            var4.addPermanentModifier(var3.getValue().create(var1));
        }
    }

    public boolean isBeneficial() {
        return this.category == MobEffectInfo.BENEFICIAL;
    }

    @Deprecated
    public Holder.c<MobEffectList> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    class a
    implements AttributeModifierTemplate {
        private final UUID id;
        private final double amount;
        private final AttributeModifier.Operation operation;

        public a(UUID var1, double var2, AttributeModifier.Operation var4) {
            this.id = var1;
            this.amount = var2;
            this.operation = var4;
        }

        @Override
        public UUID getAttributeModifierId() {
            return this.id;
        }

        @Override
        public AttributeModifier create(int var0) {
            return new AttributeModifier(this.id, MobEffectList.this.getDescriptionId() + " " + var0, this.amount * (double)(var0 + 1), this.operation);
        }
    }
}

