/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import javax.annotation.Nullable;
import net.minecraft.world.effect.InstantMobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;

class HealOrHarmMobEffect
extends InstantMobEffect {
    private final boolean isHarm;

    public HealOrHarmMobEffect(MobEffectInfo var0, int var1, boolean var2) {
        super(var0, var1);
        this.isHarm = var2;
    }

    @Override
    public void applyEffectTick(EntityLiving var0, int var1) {
        super.applyEffectTick(var0, var1);
        if (this.isHarm == var0.isInvertedHealAndHarm()) {
            var0.heal(Math.max(4 << var1, 0));
        } else {
            var0.hurt(var0.damageSources().magic(), 6 << var1);
        }
    }

    @Override
    public void applyInstantenousEffect(@Nullable Entity var0, @Nullable Entity var1, EntityLiving var2, int var3, double var4) {
        if (this.isHarm == var2.isInvertedHealAndHarm()) {
            int var6 = (int)(var4 * (double)(4 << var3) + 0.5);
            var2.heal(var6);
        } else {
            int var6 = (int)(var4 * (double)(6 << var3) + 0.5);
            if (var0 == null) {
                var2.hurt(var2.damageSources().magic(), var6);
            } else {
                var2.hurt(var2.damageSources().indirectMagic(var0, var1), var6);
            }
        }
    }
}

