/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.RandomSequence;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.saveddata.PersistentBase;
import org.slf4j.Logger;

public class RandomSequences
extends PersistentBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final long worldSeed;
    private int salt;
    private boolean includeWorldSeed = true;
    private boolean includeSequenceId = true;
    private final Map<MinecraftKey, RandomSequence> sequences = new Object2ObjectOpenHashMap();

    public static PersistentBase.a<RandomSequences> factory(long var0) {
        return new PersistentBase.a<RandomSequences>(() -> new RandomSequences(var0), var2 -> RandomSequences.load(var0, var2), DataFixTypes.SAVED_DATA_RANDOM_SEQUENCES);
    }

    public RandomSequences(long var0) {
        this.worldSeed = var0;
    }

    public RandomSource get(MinecraftKey var0) {
        RandomSource var1 = this.sequences.computeIfAbsent(var0, this::createSequence).random();
        return new a(var1);
    }

    private RandomSequence createSequence(MinecraftKey var0) {
        return this.createSequence(var0, this.salt, this.includeWorldSeed, this.includeSequenceId);
    }

    private RandomSequence createSequence(MinecraftKey var0, int var1, boolean var2, boolean var3) {
        long var4 = (var2 ? this.worldSeed : 0L) ^ (long)var1;
        return new RandomSequence(var4, var3 ? Optional.of(var0) : Optional.empty());
    }

    public void forAllSequences(BiConsumer<MinecraftKey, RandomSequence> var0) {
        this.sequences.forEach(var0);
    }

    public void setSeedDefaults(int var0, boolean var1, boolean var2) {
        this.salt = var0;
        this.includeWorldSeed = var1;
        this.includeSequenceId = var2;
    }

    @Override
    public NBTTagCompound save(NBTTagCompound var0) {
        var0.putInt("salt", this.salt);
        var0.putBoolean("include_world_seed", this.includeWorldSeed);
        var0.putBoolean("include_sequence_id", this.includeSequenceId);
        NBTTagCompound var12 = new NBTTagCompound();
        this.sequences.forEach((var1, var2) -> var12.put(var1.toString(), (NBTBase)RandomSequence.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var2).result().orElseThrow()));
        var0.put("sequences", var12);
        return var0;
    }

    private static boolean getBooleanWithDefault(NBTTagCompound var0, String var1, boolean var2) {
        if (var0.contains(var1, 1)) {
            return var0.getBoolean(var1);
        }
        return var2;
    }

    public static RandomSequences load(long var0, NBTTagCompound var2) {
        RandomSequences var3 = new RandomSequences(var0);
        var3.setSeedDefaults(var2.getInt("salt"), RandomSequences.getBooleanWithDefault(var2, "include_world_seed", true), RandomSequences.getBooleanWithDefault(var2, "include_sequence_id", true));
        NBTTagCompound var4 = var2.getCompound("sequences");
        Set<String> var5 = var4.getAllKeys();
        for (String var7 : var5) {
            try {
                RandomSequence var8 = (RandomSequence)((Pair)RandomSequence.CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var4.get(var7)).result().get()).getFirst();
                var3.sequences.put(new MinecraftKey(var7), var8);
            }
            catch (Exception var8) {
                LOGGER.error("Failed to load random sequence {}", (Object)var7, (Object)var8);
            }
        }
        return var3;
    }

    public int clear() {
        int var0 = this.sequences.size();
        this.sequences.clear();
        return var0;
    }

    public void reset(MinecraftKey var0) {
        this.sequences.put(var0, this.createSequence(var0));
    }

    public void reset(MinecraftKey var0, int var1, boolean var2, boolean var3) {
        this.sequences.put(var0, this.createSequence(var0, var1, var2, var3));
    }

    class a
    implements RandomSource {
        private final RandomSource random;

        a(RandomSource var1) {
            this.random = var1;
        }

        @Override
        public RandomSource fork() {
            RandomSequences.this.setDirty();
            return this.random.fork();
        }

        @Override
        public PositionalRandomFactory forkPositional() {
            RandomSequences.this.setDirty();
            return this.random.forkPositional();
        }

        @Override
        public void setSeed(long var0) {
            RandomSequences.this.setDirty();
            this.random.setSeed(var0);
        }

        @Override
        public int nextInt() {
            RandomSequences.this.setDirty();
            return this.random.nextInt();
        }

        @Override
        public int nextInt(int var0) {
            RandomSequences.this.setDirty();
            return this.random.nextInt(var0);
        }

        @Override
        public long nextLong() {
            RandomSequences.this.setDirty();
            return this.random.nextLong();
        }

        @Override
        public boolean nextBoolean() {
            RandomSequences.this.setDirty();
            return this.random.nextBoolean();
        }

        @Override
        public float nextFloat() {
            RandomSequences.this.setDirty();
            return this.random.nextFloat();
        }

        @Override
        public double nextDouble() {
            RandomSequences.this.setDirty();
            return this.random.nextDouble();
        }

        @Override
        public double nextGaussian() {
            RandomSequences.this.setDirty();
            return this.random.nextGaussian();
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 instanceof a) {
                a var1 = (a)var0;
                return this.random.equals(var1.random);
            }
            return false;
        }
    }
}

