/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import net.minecraft.SystemUtils;

public abstract class NamedEntityWriteReadFix
extends DataFix {
    private final String name;
    private final String entityName;
    private final DSL.TypeReference type;

    public NamedEntityWriteReadFix(Schema var0, boolean var1, String var2, DSL.TypeReference var3, String var4) {
        super(var0, var1);
        this.name = var2;
        this.type = var3;
        this.entityName = var4;
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(this.type);
        Type var1 = this.getInputSchema().getChoiceType(this.type, this.entityName);
        Type var22 = this.getOutputSchema().getType(this.type);
        Type var3 = this.getOutputSchema().getChoiceType(this.type, this.entityName);
        OpticFinder var4 = DSL.namedChoice((String)this.entityName, (Type)var1);
        return this.fixTypeEverywhereTyped(this.name, var0, var22, var2 -> var2.updateTyped(var4, var3, var1 -> SystemUtils.writeAndReadTypedOrThrow(var1, var3, this::fix)));
    }

    protected abstract <T> Dynamic<T> fix(Dynamic<T> var1);
}

