/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

public class SampleLogger {
    public static final int CAPACITY = 240;
    private final long[] samples = new long[240];
    private int start;
    private int size;

    public void logSample(long var0) {
        int var2 = this.wrapIndex(this.start + this.size);
        this.samples[var2] = var0;
        if (this.size < 240) {
            ++this.size;
        } else {
            this.start = this.wrapIndex(this.start + 1);
        }
    }

    public int capacity() {
        return this.samples.length;
    }

    public int size() {
        return this.size;
    }

    public long get(int var0) {
        if (var0 < 0 || var0 >= this.size) {
            throw new IndexOutOfBoundsException(var0 + " out of bounds for length " + this.size);
        }
        return this.samples[this.wrapIndex(this.start + var0)];
    }

    private int wrapIndex(int var0) {
        return var0 % 240;
    }

    public void reset() {
        this.start = 0;
        this.size = 0;
    }
}

