/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.sounds;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;

public class SoundEffect {
    public static final Codec<SoundEffect> DIRECT_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MinecraftKey.CODEC.fieldOf("sound_id").forGetter(SoundEffect::getLocation), (App)Codec.FLOAT.optionalFieldOf("range").forGetter(SoundEffect::fixedRange)).apply((Applicative)var0, SoundEffect::create));
    public static final Codec<Holder<SoundEffect>> CODEC = RegistryFileCodec.create(Registries.SOUND_EVENT, DIRECT_CODEC);
    private static final float DEFAULT_RANGE = 16.0f;
    private final MinecraftKey location;
    private final float range;
    private final boolean newSystem;

    private static SoundEffect create(MinecraftKey var0, Optional<Float> var12) {
        return var12.map(var1 -> SoundEffect.createFixedRangeEvent(var0, var1.floatValue())).orElseGet(() -> SoundEffect.createVariableRangeEvent(var0));
    }

    public static SoundEffect createVariableRangeEvent(MinecraftKey var0) {
        return new SoundEffect(var0, 16.0f, false);
    }

    public static SoundEffect createFixedRangeEvent(MinecraftKey var0, float var1) {
        return new SoundEffect(var0, var1, true);
    }

    private SoundEffect(MinecraftKey var0, float var1, boolean var2) {
        this.location = var0;
        this.range = var1;
        this.newSystem = var2;
    }

    public MinecraftKey getLocation() {
        return this.location;
    }

    public float getRange(float var0) {
        if (this.newSystem) {
            return this.range;
        }
        return var0 > 1.0f ? 16.0f * var0 : 16.0f;
    }

    private Optional<Float> fixedRange() {
        return this.newSystem ? Optional.of(Float.valueOf(this.range)) : Optional.empty();
    }

    public void writeToNetwork(PacketDataSerializer var0) {
        var0.writeResourceLocation(this.location);
        var0.writeOptional(this.fixedRange(), PacketDataSerializer::writeFloat);
    }

    public static SoundEffect readFromNetwork(PacketDataSerializer var0) {
        MinecraftKey var1 = var0.readResourceLocation();
        Optional<Float> var2 = var0.readOptional(PacketDataSerializer::readFloat);
        return SoundEffect.create(var1, var2);
    }
}

