/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.slf4j.Logger;

public class ResourceManagerFallback
implements IResourceManager {
    static final Logger LOGGER = LogUtils.getLogger();
    protected final List<d> fallbacks = Lists.newArrayList();
    private final EnumResourcePackType type;
    private final String namespace;

    public ResourceManagerFallback(EnumResourcePackType var0, String var1) {
        this.type = var0;
        this.namespace = var1;
    }

    public void push(IResourcePack var0) {
        this.pushInternal(var0.packId(), var0, null);
    }

    public void push(IResourcePack var0, Predicate<MinecraftKey> var1) {
        this.pushInternal(var0.packId(), var0, var1);
    }

    public void pushFilterOnly(String var0, Predicate<MinecraftKey> var1) {
        this.pushInternal(var0, null, var1);
    }

    private void pushInternal(String var0, @Nullable IResourcePack var1, @Nullable Predicate<MinecraftKey> var2) {
        this.fallbacks.add(new d(var0, var1, var2));
    }

    @Override
    public Set<String> getNamespaces() {
        return ImmutableSet.of((Object)this.namespace);
    }

    @Override
    public Optional<IResource> getResource(MinecraftKey var0) {
        for (int var1 = this.fallbacks.size() - 1; var1 >= 0; --var1) {
            IoSupplier<InputStream> var4;
            d var2 = this.fallbacks.get(var1);
            IResourcePack var3 = var2.resources;
            if (var3 != null && (var4 = var3.getResource(this.type, var0)) != null) {
                IoSupplier<ResourceMetadata> var5 = this.createStackMetadataFinder(var0, var1);
                return Optional.of(ResourceManagerFallback.createResource(var3, var0, var4, var5));
            }
            if (!var2.isFiltered(var0)) continue;
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)var0, (Object)var2.name);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static IResource createResource(IResourcePack var0, MinecraftKey var1, IoSupplier<InputStream> var2, IoSupplier<ResourceMetadata> var3) {
        return new IResource(var0, ResourceManagerFallback.wrapForDebug(var1, var0, var2), var3);
    }

    private static IoSupplier<InputStream> wrapForDebug(MinecraftKey var0, IResourcePack var1, IoSupplier<InputStream> var2) {
        if (LOGGER.isDebugEnabled()) {
            return () -> new c((InputStream)var2.get(), var0, var1.packId());
        }
        return var2;
    }

    @Override
    public List<IResource> getResourceStack(MinecraftKey var0) {
        MinecraftKey var1 = ResourceManagerFallback.getMetadataLocation(var0);
        ArrayList<IResource> var2 = new ArrayList<IResource>();
        boolean var3 = false;
        String var4 = null;
        for (int var5 = this.fallbacks.size() - 1; var5 >= 0; --var5) {
            IoSupplier<InputStream> var8;
            d var6 = this.fallbacks.get(var5);
            IResourcePack var7 = var6.resources;
            if (var7 != null && (var8 = var7.getResource(this.type, var0)) != null) {
                IoSupplier<ResourceMetadata> var9 = var3 ? ResourceMetadata.EMPTY_SUPPLIER : () -> {
                    IoSupplier<InputStream> var2 = var7.getResource(this.type, var1);
                    return var2 != null ? ResourceManagerFallback.parseMetadata(var2) : ResourceMetadata.EMPTY;
                };
                var2.add(new IResource(var7, var8, var9));
            }
            if (var6.isFiltered(var0)) {
                var4 = var6.name;
                break;
            }
            if (!var6.isFiltered(var1)) continue;
            var3 = true;
        }
        if (var2.isEmpty() && var4 != null) {
            LOGGER.warn("Resource {} not found, but was filtered by pack {}", (Object)var0, var4);
        }
        return Lists.reverse(var2);
    }

    private static boolean isMetadata(MinecraftKey var0) {
        return var0.getPath().endsWith(".mcmeta");
    }

    private static MinecraftKey getResourceLocationFromMetadata(MinecraftKey var0) {
        String var1 = var0.getPath().substring(0, var0.getPath().length() - ".mcmeta".length());
        return var0.withPath(var1);
    }

    static MinecraftKey getMetadataLocation(MinecraftKey var0) {
        return var0.withPath(var0.getPath() + ".mcmeta");
    }

    @Override
    public Map<MinecraftKey, IResource> listResources(String var0, Predicate<MinecraftKey> var1) {
        final class A
        extends Record {
            final IResourcePack packResources;
            final IoSupplier<InputStream> resource;
            final int packIndex;

            A(IResourcePack var0, IoSupplier<InputStream> var1, int var2) {
                this.packResources = var0;
                this.resource = var1;
                this.packIndex = var2;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "packResources;resource;packIndex", "packResources", "resource", "packIndex"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "packResources;resource;packIndex", "packResources", "resource", "packIndex"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "packResources;resource;packIndex", "packResources", "resource", "packIndex"}, this, var0);
            }

            public IResourcePack packResources() {
                return this.packResources;
            }

            public IoSupplier<InputStream> resource() {
                return this.resource;
            }

            public int packIndex() {
                return this.packIndex;
            }
        }
        HashMap<MinecraftKey, A> var22 = new HashMap<MinecraftKey, A>();
        HashMap var32 = new HashMap();
        int var4 = this.fallbacks.size();
        for (int var52 = 0; var52 < var4; ++var52) {
            d var62 = this.fallbacks.get(var52);
            var62.filterAll(var22.keySet());
            var62.filterAll(var32.keySet());
            IResourcePack var7 = var62.resources;
            if (var7 == null) continue;
            int var8 = var52;
            var7.listResources(this.type, this.namespace, var0, (var5, var6) -> {
                if (ResourceManagerFallback.isMetadata(var5)) {
                    if (var1.test(ResourceManagerFallback.getResourceLocationFromMetadata(var5))) {
                        var32.put(var5, new A(var7, (IoSupplier<InputStream>)var6, var8));
                    }
                } else if (var1.test((MinecraftKey)var5)) {
                    var22.put((MinecraftKey)var5, new A(var7, (IoSupplier<InputStream>)var6, var8));
                }
            });
        }
        TreeMap var53 = Maps.newTreeMap();
        var22.forEach((var2, var3) -> {
            MinecraftKey var5 = ResourceManagerFallback.getMetadataLocation(var2);
            A var6 = (A)var32.get(var5);
            IoSupplier<ResourceMetadata> var4 = var6 != null && var6.packIndex >= var3.packIndex ? ResourceManagerFallback.convertToMetadata(var6.resource) : ResourceMetadata.EMPTY_SUPPLIER;
            var53.put(var2, ResourceManagerFallback.createResource(var3.packResources, var2, var3.resource, var4));
        });
        return var53;
    }

    private IoSupplier<ResourceMetadata> createStackMetadataFinder(MinecraftKey var0, int var1) {
        return () -> {
            MinecraftKey var2 = ResourceManagerFallback.getMetadataLocation(var0);
            for (int var3 = this.fallbacks.size() - 1; var3 >= var1; --var3) {
                IoSupplier<InputStream> var6;
                d var4 = this.fallbacks.get(var3);
                IResourcePack var5 = var4.resources;
                if (var5 != null && (var6 = var5.getResource(this.type, var2)) != null) {
                    return ResourceManagerFallback.parseMetadata(var6);
                }
                if (var4.isFiltered(var2)) break;
            }
            return ResourceMetadata.EMPTY;
        };
    }

    private static IoSupplier<ResourceMetadata> convertToMetadata(IoSupplier<InputStream> var0) {
        return () -> ResourceManagerFallback.parseMetadata(var0);
    }

    private static ResourceMetadata parseMetadata(IoSupplier<InputStream> var0) throws IOException {
        try (InputStream var1 = var0.get();){
            ResourceMetadata resourceMetadata = ResourceMetadata.fromJsonStream(var1);
            return resourceMetadata;
        }
    }

    private static void applyPackFiltersToExistingResources(d var0, Map<MinecraftKey, b> var1) {
        for (b var3 : var1.values()) {
            if (var0.isFiltered(var3.fileLocation)) {
                var3.fileSources.clear();
                continue;
            }
            if (!var0.isFiltered(var3.metadataLocation())) continue;
            var3.metaSources.clear();
        }
    }

    private void listPackResources(d var0, String var1, Predicate<MinecraftKey> var2, Map<MinecraftKey, b> var32) {
        IResourcePack var42 = var0.resources;
        if (var42 == null) {
            return;
        }
        var42.listResources(this.type, this.namespace, var1, (var3, var4) -> {
            if (ResourceManagerFallback.isMetadata(var3)) {
                MinecraftKey var5 = ResourceManagerFallback.getResourceLocationFromMetadata(var3);
                if (!var2.test(var5)) {
                    return;
                }
                var1.computeIfAbsent(var5, (Function<MinecraftKey, b>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.MinecraftKey ), (Lnet/minecraft/resources/MinecraftKey;)Lnet/minecraft/server/packs/resources/ResourceManagerFallback$b;)()).metaSources.put(var42, (IoSupplier<InputStream>)var4);
            } else {
                if (!var2.test((MinecraftKey)var3)) {
                    return;
                }
                var1.computeIfAbsent(var3, (Function<MinecraftKey, b>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(net.minecraft.resources.MinecraftKey ), (Lnet/minecraft/resources/MinecraftKey;)Lnet/minecraft/server/packs/resources/ResourceManagerFallback$b;)()).fileSources.add(new e(var42, (IoSupplier<InputStream>)var4));
            }
        });
    }

    @Override
    public Map<MinecraftKey, List<IResource>> listResourceStacks(String var0, Predicate<MinecraftKey> var1) {
        HashMap var2 = Maps.newHashMap();
        for (d var4 : this.fallbacks) {
            ResourceManagerFallback.applyPackFiltersToExistingResources(var4, var2);
            this.listPackResources(var4, var0, var1, var2);
        }
        TreeMap var3 = Maps.newTreeMap();
        for (b var5 : var2.values()) {
            if (var5.fileSources.isEmpty()) continue;
            ArrayList<IResource> var6 = new ArrayList<IResource>();
            for (e var8 : var5.fileSources) {
                IResourcePack var9 = var8.source;
                IoSupplier<InputStream> var10 = var5.metaSources.get(var9);
                IoSupplier<ResourceMetadata> var11 = var10 != null ? ResourceManagerFallback.convertToMetadata(var10) : ResourceMetadata.EMPTY_SUPPLIER;
                var6.add(ResourceManagerFallback.createResource(var9, var5.fileLocation, var8.resource, var11));
            }
            var3.put(var5.fileLocation, var6);
        }
        return var3;
    }

    @Override
    public Stream<IResourcePack> listPacks() {
        return this.fallbacks.stream().map(var0 -> var0.resources).filter(Objects::nonNull);
    }

    static final class d
    extends Record {
        final String name;
        @Nullable
        final IResourcePack resources;
        @Nullable
        private final Predicate<MinecraftKey> filter;

        d(String var0, @Nullable IResourcePack var1, @Nullable Predicate<MinecraftKey> var2) {
            this.name = var0;
            this.resources = var1;
            this.filter = var2;
        }

        public void filterAll(Collection<MinecraftKey> var0) {
            if (this.filter != null) {
                var0.removeIf(this.filter);
            }
        }

        public boolean isFiltered(MinecraftKey var0) {
            return this.filter != null && this.filter.test(var0);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "name;resources;filter", "name", "resources", "filter"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "name;resources;filter", "name", "resources", "filter"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "name;resources;filter", "name", "resources", "filter"}, this, var0);
        }

        public String name() {
            return this.name;
        }

        @Nullable
        public IResourcePack resources() {
            return this.resources;
        }

        @Nullable
        public Predicate<MinecraftKey> filter() {
            return this.filter;
        }
    }

    static final class b
    extends Record {
        final MinecraftKey fileLocation;
        private final MinecraftKey metadataLocation;
        final List<e> fileSources;
        final Map<IResourcePack, IoSupplier<InputStream>> metaSources;

        b(MinecraftKey var0) {
            this(var0, ResourceManagerFallback.getMetadataLocation(var0), new ArrayList<e>(), (Map<IResourcePack, IoSupplier<InputStream>>)new Object2ObjectArrayMap());
        }

        private b(MinecraftKey var0, MinecraftKey var1, List<e> var2, Map<IResourcePack, IoSupplier<InputStream>> var3) {
            this.fileLocation = var0;
            this.metadataLocation = var1;
            this.fileSources = var2;
            this.metaSources = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "fileLocation;metadataLocation;fileSources;metaSources", "fileLocation", "metadataLocation", "fileSources", "metaSources"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "fileLocation;metadataLocation;fileSources;metaSources", "fileLocation", "metadataLocation", "fileSources", "metaSources"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "fileLocation;metadataLocation;fileSources;metaSources", "fileLocation", "metadataLocation", "fileSources", "metaSources"}, this, var0);
        }

        public MinecraftKey fileLocation() {
            return this.fileLocation;
        }

        public MinecraftKey metadataLocation() {
            return this.metadataLocation;
        }

        public List<e> fileSources() {
            return this.fileSources;
        }

        public Map<IResourcePack, IoSupplier<InputStream>> metaSources() {
            return this.metaSources;
        }
    }

    static final class e
    extends Record {
        final IResourcePack source;
        final IoSupplier<InputStream> resource;

        e(IResourcePack var0, IoSupplier<InputStream> var1) {
            this.source = var0;
            this.resource = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "source;resource", "source", "resource"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "source;resource", "source", "resource"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "source;resource", "source", "resource"}, this, var0);
        }

        public IResourcePack source() {
            return this.source;
        }

        public IoSupplier<InputStream> resource() {
            return this.resource;
        }
    }

    static class c
    extends FilterInputStream {
        private final Supplier<String> message;
        private boolean closed;

        public c(InputStream var0, MinecraftKey var1, String var2) {
            super(var0);
            Exception var3 = new Exception("Stacktrace");
            this.message = () -> {
                StringWriter var3 = new StringWriter();
                var3.printStackTrace(new PrintWriter(var3));
                return "Leaked resource: '" + var1 + "' loaded from pack: '" + var2 + "'\n" + var3;
            };
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            if (!this.closed) {
                LOGGER.warn("{}", (Object)this.message.get());
            }
            super.finalize();
        }
    }
}

