/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class ResourcePackLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String id;
    public final c resources;
    private final IChatBaseComponent title;
    private final a info;
    private final Position defaultPosition;
    private final boolean required;
    private final boolean fixedPosition;
    private final PackSource packSource;

    @Nullable
    public static ResourcePackLoader readMetaAndCreate(String var0, IChatBaseComponent var1, boolean var2, c var3, EnumResourcePackType var4, Position var5, PackSource var6) {
        int var7 = SharedConstants.getCurrentVersion().getPackVersion(var4);
        a var8 = ResourcePackLoader.readPackInfo(var0, var3, var7);
        return var8 != null ? ResourcePackLoader.create(var0, var1, var2, var3, var8, var5, false, var6) : null;
    }

    public static ResourcePackLoader create(String var0, IChatBaseComponent var1, boolean var2, c var3, a var4, Position var5, boolean var6, PackSource var7) {
        return new ResourcePackLoader(var0, var2, var3, var1, var4, var5, var6, var7);
    }

    private ResourcePackLoader(String var0, boolean var1, c var2, IChatBaseComponent var3, a var4, Position var5, boolean var6, PackSource var7) {
        this.id = var0;
        this.resources = var2;
        this.title = var3;
        this.info = var4;
        this.required = var1;
        this.defaultPosition = var5;
        this.fixedPosition = var6;
        this.packSource = var7;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static a readPackInfo(String var0, c var1, int var2) {
        try (IResourcePack var3 = var1.openPrimary(var0);){
            ResourcePackInfo var4 = var3.getMetadataSection(ResourcePackInfo.TYPE);
            if (var4 == null) {
                LOGGER.warn("Missing metadata in pack {}", (Object)var0);
                a a2 = null;
                return a2;
            }
            FeatureFlagsMetadataSection var5 = var3.getMetadataSection(FeatureFlagsMetadataSection.TYPE);
            FeatureFlagSet var6 = var5 != null ? var5.flags() : FeatureFlagSet.of();
            InclusiveRange<Integer> var7 = ResourcePackLoader.getDeclaredPackVersions(var0, var4);
            EnumResourcePackVersion var8 = EnumResourcePackVersion.forVersion(var7, var2);
            OverlayMetadataSection var9 = var3.getMetadataSection(OverlayMetadataSection.TYPE);
            List<String> var10 = var9 != null ? var9.overlaysForVersion(var2) : List.of();
            a a3 = new a(var4.description(), var8, var6, var10);
            return a3;
        }
        catch (Exception var32) {
            LOGGER.warn("Failed to read pack {} metadata", (Object)var0, (Object)var32);
            return null;
        }
    }

    private static InclusiveRange<Integer> getDeclaredPackVersions(String var0, ResourcePackInfo var1) {
        int var2 = var1.packFormat();
        if (var1.supportedFormats().isEmpty()) {
            return new InclusiveRange<Integer>(var2);
        }
        InclusiveRange<Integer> var3 = var1.supportedFormats().get();
        if (!var3.isValueInRange(var2)) {
            LOGGER.warn("Pack {} declared support for versions {} but declared main format is {}, defaulting to {}", new Object[]{var0, var3, var2, var2});
            return new InclusiveRange<Integer>(var2);
        }
        return var3;
    }

    public IChatBaseComponent getTitle() {
        return this.title;
    }

    public IChatBaseComponent getDescription() {
        return this.info.description();
    }

    public IChatBaseComponent getChatLink(boolean var0) {
        return ChatComponentUtils.wrapInSquareBrackets(this.packSource.decorate(IChatBaseComponent.literal(this.id))).withStyle(var1 -> var1.withColor(var0 ? EnumChatFormat.GREEN : EnumChatFormat.RED).withInsertion(StringArgumentType.escapeIfRequired((String)this.id)).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.empty().append(this.title).append("\n").append(this.info.description))));
    }

    public EnumResourcePackVersion getCompatibility() {
        return this.info.compatibility();
    }

    public FeatureFlagSet getRequestedFeatures() {
        return this.info.requestedFeatures();
    }

    public IResourcePack open() {
        return this.resources.openFull(this.id, this.info);
    }

    public String getId() {
        return this.id;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isFixedPosition() {
        return this.fixedPosition;
    }

    public Position getDefaultPosition() {
        return this.defaultPosition;
    }

    public PackSource getPackSource() {
        return this.packSource;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof ResourcePackLoader)) {
            return false;
        }
        ResourcePackLoader var1 = (ResourcePackLoader)var0;
        return this.id.equals(var1.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static interface c {
        public IResourcePack openPrimary(String var1);

        public IResourcePack openFull(String var1, a var2);
    }

    public static final class a
    extends Record {
        final IChatBaseComponent description;
        private final EnumResourcePackVersion compatibility;
        private final FeatureFlagSet requestedFeatures;
        private final List<String> overlays;

        public a(IChatBaseComponent var0, EnumResourcePackVersion var1, FeatureFlagSet var2, List<String> var3) {
            this.description = var0;
            this.compatibility = var1;
            this.requestedFeatures = var2;
            this.overlays = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "description", "compatibility", "requestedFeatures", "overlays"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "description", "compatibility", "requestedFeatures", "overlays"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "description", "compatibility", "requestedFeatures", "overlays"}, this, var0);
        }

        public IChatBaseComponent description() {
            return this.description;
        }

        public EnumResourcePackVersion compatibility() {
            return this.compatibility;
        }

        public FeatureFlagSet requestedFeatures() {
            return this.requestedFeatures;
        }

        public List<String> overlays() {
            return this.overlays;
        }
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position TOP = new Position();
        public static final /* enum */ Position BOTTOM = new Position();
        private static final /* synthetic */ Position[] c;

        public static Position[] values() {
            return (Position[])c.clone();
        }

        public static Position valueOf(String var0) {
            return Enum.valueOf(Position.class, var0);
        }

        public <T> int insert(List<T> var0, T var1, Function<T, ResourcePackLoader> var2, boolean var3) {
            ResourcePackLoader var6;
            int var5;
            Position var4;
            Position position = var4 = var3 ? this.opposite() : this;
            if (var4 == BOTTOM) {
                ResourcePackLoader var62;
                int var52;
                for (var52 = 0; var52 < var0.size() && (var62 = var2.apply(var0.get(var52))).isFixedPosition() && var62.getDefaultPosition() == this; ++var52) {
                }
                var0.add(var52, var1);
                return var52;
            }
            for (var5 = var0.size() - 1; var5 >= 0 && (var6 = var2.apply(var0.get(var5))).isFixedPosition() && var6.getDefaultPosition() == this; --var5) {
            }
            var0.add(var5 + 1, var1);
            return var5 + 1;
        }

        public Position opposite() {
            return this == TOP ? BOTTOM : TOP;
        }

        private static /* synthetic */ Position[] b() {
            return new Position[]{TOP, BOTTOM};
        }

        static {
            c = Position.b();
        }
    }
}

