/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.ChatDeserializer;
import org.slf4j.Logger;

public abstract class ResourcePackAbstract
implements IResourcePack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String name;
    private final boolean isBuiltin;

    protected ResourcePackAbstract(String var0, boolean var1) {
        this.name = var0;
        this.isBuiltin = var1;
    }

    @Override
    @Nullable
    public <T> T getMetadataSection(ResourcePackMetaParser<T> var0) throws IOException {
        IoSupplier<InputStream> var1 = this.getRootResource("pack.mcmeta");
        if (var1 == null) {
            return null;
        }
        try (InputStream var2 = var1.get();){
            T t2 = ResourcePackAbstract.getMetadataFromStream(var0, var2);
            return t2;
        }
    }

    @Nullable
    public static <T> T getMetadataFromStream(ResourcePackMetaParser<T> var0, InputStream var1) {
        JsonObject var2;
        try (BufferedReader var3 = new BufferedReader(new InputStreamReader(var1, StandardCharsets.UTF_8));){
            var2 = ChatDeserializer.parse(var3);
        }
        catch (Exception var32) {
            LOGGER.error("Couldn't load {} metadata", (Object)var0.getMetadataSectionName(), (Object)var32);
            return null;
        }
        if (!var2.has(var0.getMetadataSectionName())) {
            return null;
        }
        try {
            return var0.fromJson(ChatDeserializer.getAsJsonObject(var2, var0.getMetadataSectionName()));
        }
        catch (Exception var3) {
            LOGGER.error("Couldn't load {} metadata", (Object)var0.getMetadataSectionName(), (Object)var3);
            return null;
        }
    }

    @Override
    public String packId() {
        return this.name;
    }

    @Override
    public boolean isBuiltin() {
        return this.isBuiltin;
    }
}

