/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.ResourcePackAbstract;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.resources.IoSupplier;
import org.slf4j.Logger;

public class PathPackResources
extends ResourcePackAbstract {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private final Path root;

    public PathPackResources(String var0, Path var1, boolean var2) {
        super(var0, var2);
        this.root = var1;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... var0) {
        FileUtils.validatePath(var0);
        Path var1 = FileUtils.resolvePath(this.root, List.of(var0));
        if (Files.exists(var1, new LinkOption[0])) {
            return IoSupplier.create(var1);
        }
        return null;
    }

    public static boolean validatePath(Path var0) {
        return true;
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> getResource(EnumResourcePackType var0, MinecraftKey var1) {
        Path var2 = this.root.resolve(var0.getDirectory()).resolve(var1.getNamespace());
        return PathPackResources.getResource(var1, var2);
    }

    public static IoSupplier<InputStream> getResource(MinecraftKey var0, Path var12) {
        return (IoSupplier)FileUtils.decomposePath(var0.getPath()).get().map(var1 -> {
            Path var2 = FileUtils.resolvePath(var12, var1);
            return PathPackResources.returnFileIfExists(var2);
        }, var1 -> {
            LOGGER.error("Invalid path {}: {}", (Object)var0, (Object)var1.message());
            return null;
        });
    }

    @Nullable
    private static IoSupplier<InputStream> returnFileIfExists(Path var0) {
        if (Files.exists(var0, new LinkOption[0]) && PathPackResources.validatePath(var0)) {
            return IoSupplier.create(var0);
        }
        return null;
    }

    @Override
    public void listResources(EnumResourcePackType var0, String var12, String var2, IResourcePack.a var32) {
        FileUtils.decomposePath(var2).get().ifLeft(var3 -> {
            Path var4 = this.root.resolve(var0.getDirectory()).resolve(var12);
            PathPackResources.listPath(var12, var4, var3, var32);
        }).ifRight(var1 -> LOGGER.error("Invalid path {}: {}", (Object)var2, (Object)var1.message()));
    }

    public static void listPath(String var02, Path var12, List<String> var2, IResourcePack.a var32) {
        Path var4 = FileUtils.resolvePath(var12, var2);
        try (Stream<Path> var52 = Files.find(var4, Integer.MAX_VALUE, (var0, var1) -> var1.isRegularFile(), new FileVisitOption[0]);){
            var52.forEach(var3 -> {
                String var4 = PATH_JOINER.join((Iterable)var12.relativize((Path)var3));
                MinecraftKey var5 = MinecraftKey.tryBuild(var02, var4);
                if (var5 == null) {
                    SystemUtils.logAndPauseIfInIde(String.format(Locale.ROOT, "Invalid path in pack: %s:%s, ignoring", var02, var4));
                } else {
                    var32.accept(var5, IoSupplier.create(var3));
                }
            });
        }
        catch (NoSuchFileException | NotDirectoryException var52) {
        }
        catch (IOException var53) {
            LOGGER.error("Failed to list path {}", (Object)var4, (Object)var53);
        }
    }

    @Override
    public Set<String> getNamespaces(EnumResourcePackType var0) {
        HashSet var1 = Sets.newHashSet();
        Path var2 = this.root.resolve(var0.getDirectory());
        try (DirectoryStream<Path> var32 = Files.newDirectoryStream(var2);){
            for (Path var5 : var32) {
                String var6 = var5.getFileName().toString();
                if (MinecraftKey.isValidNamespace(var6)) {
                    var1.add(var6);
                    continue;
                }
                LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)var6, (Object)this.root);
            }
        }
        catch (NoSuchFileException | NotDirectoryException var32) {
        }
        catch (IOException var33) {
            LOGGER.error("Failed to list path {}", (Object)var2, (Object)var33);
        }
        return var1;
    }

    @Override
    public void close() {
    }

    public static class a
    implements ResourcePackLoader.c {
        private final Path content;
        private final boolean isBuiltin;

        public a(Path var0, boolean var1) {
            this.content = var0;
            this.isBuiltin = var1;
        }

        @Override
        public IResourcePack openPrimary(String var0) {
            return new PathPackResources(var0, this.content, this.isBuiltin);
        }

        @Override
        public IResourcePack openFull(String var0, ResourcePackLoader.a var1) {
            IResourcePack var2 = this.openPrimary(var0);
            List<String> var3 = var1.overlays();
            if (var3.isEmpty()) {
                return var2;
            }
            ArrayList<IResourcePack> var4 = new ArrayList<IResourcePack>(var3.size());
            for (String var6 : var3) {
                Path var7 = this.content.resolve(var6);
                var4.add(new PathPackResources(var0, var7, this.isBuiltin));
            }
            return new CompositePackResources(var2, var4);
        }
    }
}

