/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumHand;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.EntityPig;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityStrider;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerHorse;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.ICrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemCooldownPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMapBase;
import net.minecraft.world.item.ItemWrittenBook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.slf4j.Logger;

public class EntityPlayer
extends EntityHuman {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_XZ = 32;
    private static final int NEUTRAL_MOB_DEATH_NOTIFICATION_RADII_Y = 10;
    private static final int FLY_STAT_RECORDING_SPEED = 25;
    public PlayerConnection connection;
    public final MinecraftServer server;
    public final PlayerInteractManager gameMode;
    private final AdvancementDataPlayer advancements;
    private final ServerStatisticManager stats;
    private float lastRecordedHealthAndAbsorption = Float.MIN_VALUE;
    private int lastRecordedFoodLevel = Integer.MIN_VALUE;
    private int lastRecordedAirLevel = Integer.MIN_VALUE;
    private int lastRecordedArmor = Integer.MIN_VALUE;
    private int lastRecordedLevel = Integer.MIN_VALUE;
    private int lastRecordedExperience = Integer.MIN_VALUE;
    private float lastSentHealth = -1.0E8f;
    private int lastSentFood = -99999999;
    private boolean lastFoodSaturationZero = true;
    public int lastSentExp = -99999999;
    public int spawnInvulnerableTime = 60;
    private EnumChatVisibility chatVisibility = EnumChatVisibility.FULL;
    private boolean canChatColor = true;
    private long lastActionTime = SystemUtils.getMillis();
    @Nullable
    private Entity camera;
    public boolean isChangingDimension;
    private boolean seenCredits;
    private final RecipeBookServer recipeBook = new RecipeBookServer();
    @Nullable
    private Vec3D levitationStartPos;
    private int levitationStartTime;
    private boolean disconnected;
    private int requestedViewDistance = 2;
    public String language = "en_us";
    @Nullable
    private Vec3D startingToFallPosition;
    @Nullable
    private Vec3D enteredNetherPosition;
    @Nullable
    private Vec3D enteredLavaOnVehiclePosition;
    private SectionPosition lastSectionPos = SectionPosition.of(0, 0, 0);
    private ChunkTrackingView chunkTrackingView = ChunkTrackingView.EMPTY;
    private ResourceKey<World> respawnDimension = World.OVERWORLD;
    @Nullable
    private BlockPosition respawnPosition;
    private boolean respawnForced;
    private float respawnAngle;
    private final ITextFilter textFilter;
    private boolean textFilteringEnabled;
    private boolean allowsListing;
    private WardenSpawnTracker wardenSpawnTracker = new WardenSpawnTracker(0, 0, 0);
    private final ContainerSynchronizer containerSynchronizer = new ContainerSynchronizer(){

        @Override
        public void sendInitialData(Container var0, NonNullList<ItemStack> var1, ItemStack var2, int[] var3) {
            EntityPlayer.this.connection.send(new PacketPlayOutWindowItems(var0.containerId, var0.incrementStateId(), var1, var2));
            for (int var4 = 0; var4 < var3.length; ++var4) {
                this.broadcastDataValue(var0, var4, var3[var4]);
            }
        }

        @Override
        public void sendSlotChange(Container var0, int var1, ItemStack var2) {
            EntityPlayer.this.connection.send(new PacketPlayOutSetSlot(var0.containerId, var0.incrementStateId(), var1, var2));
        }

        @Override
        public void sendCarriedChange(Container var0, ItemStack var1) {
            EntityPlayer.this.connection.send(new PacketPlayOutSetSlot(-1, var0.incrementStateId(), -1, var1));
        }

        @Override
        public void sendDataChange(Container var0, int var1, int var2) {
            this.broadcastDataValue(var0, var1, var2);
        }

        private void broadcastDataValue(Container var0, int var1, int var2) {
            EntityPlayer.this.connection.send(new PacketPlayOutWindowData(var0.containerId, var1, var2));
        }
    };
    private final ICrafting containerListener = new ICrafting(){

        @Override
        public void slotChanged(Container var0, int var1, ItemStack var2) {
            Slot var3 = var0.getSlot(var1);
            if (var3 instanceof SlotResult) {
                return;
            }
            if (var3.container == EntityPlayer.this.getInventory()) {
                CriterionTriggers.INVENTORY_CHANGED.trigger(EntityPlayer.this, EntityPlayer.this.getInventory(), var2);
            }
        }

        @Override
        public void dataChanged(Container var0, int var1, int var2) {
        }
    };
    @Nullable
    private RemoteChatSession chatSession;
    private int containerCounter;
    public boolean wonGame;

    public EntityPlayer(MinecraftServer var0, WorldServer var1, GameProfile var2, ClientInformation var3) {
        super(var1, var1.getSharedSpawnPos(), var1.getSharedSpawnAngle(), var2);
        this.textFilter = var0.createTextFilterForPlayer(this);
        this.gameMode = var0.createGameModeForPlayer(this);
        this.server = var0;
        this.stats = var0.getPlayerList().getPlayerStats(this);
        this.advancements = var0.getPlayerList().getPlayerAdvancements(this);
        this.setMaxUpStep(1.0f);
        this.fudgeSpawnLocation(var1);
        this.updateOptions(var3);
    }

    private void fudgeSpawnLocation(WorldServer var0) {
        BlockPosition var1 = var0.getSharedSpawnPos();
        if (var0.dimensionType().hasSkyLight() && var0.getServer().getWorldData().getGameType() != EnumGamemode.ADVENTURE) {
            long var4;
            long var6;
            int var2 = Math.max(0, this.server.getSpawnRadius(var0));
            int var3 = MathHelper.floor(var0.getWorldBorder().getDistanceToBorder(var1.getX(), var1.getZ()));
            if (var3 < var2) {
                var2 = var3;
            }
            if (var3 <= 1) {
                var2 = 1;
            }
            int var8 = (var6 = (var4 = (long)(var2 * 2 + 1)) * var4) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)var6;
            int var9 = this.getCoprime(var8);
            int var10 = RandomSource.create().nextInt(var8);
            for (int var11 = 0; var11 < var8; ++var11) {
                int var12 = (var10 + var9 * var11) % var8;
                int var13 = var12 % (var2 * 2 + 1);
                int var14 = var12 / (var2 * 2 + 1);
                BlockPosition var15 = WorldProviderNormal.getOverworldRespawnPos(var0, var1.getX() + var13 - var2, var1.getZ() + var14 - var2);
                if (var15 == null) continue;
                this.moveTo(var15, 0.0f, 0.0f);
                if (!var0.noCollision(this)) {
                    continue;
                }
                break;
            }
        } else {
            this.moveTo(var1, 0.0f, 0.0f);
            while (!var0.noCollision(this) && this.getY() < (double)(var0.getMaxBuildHeight() - 1)) {
                this.setPos(this.getX(), this.getY() + 1.0, this.getZ());
            }
        }
    }

    private int getCoprime(int var0) {
        return var0 <= 16 ? var0 - 1 : 17;
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var02) {
        super.readAdditionalSaveData(var02);
        if (var02.contains("warden_spawn_tracker", 10)) {
            WardenSpawnTracker.CODEC.parse(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get("warden_spawn_tracker"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var0 -> {
                this.wardenSpawnTracker = var0;
            });
        }
        if (var02.contains("enteredNetherPosition", 10)) {
            NBTTagCompound var1 = var02.getCompound("enteredNetherPosition");
            this.enteredNetherPosition = new Vec3D(var1.getDouble("x"), var1.getDouble("y"), var1.getDouble("z"));
        }
        this.seenCredits = var02.getBoolean("seenCredits");
        if (var02.contains("recipeBook", 10)) {
            this.recipeBook.fromNbt(var02.getCompound("recipeBook"), this.server.getRecipeManager());
        }
        if (this.isSleeping()) {
            this.stopSleeping();
        }
        if (var02.contains("SpawnX", 99) && var02.contains("SpawnY", 99) && var02.contains("SpawnZ", 99)) {
            this.respawnPosition = new BlockPosition(var02.getInt("SpawnX"), var02.getInt("SpawnY"), var02.getInt("SpawnZ"));
            this.respawnForced = var02.getBoolean("SpawnForced");
            this.respawnAngle = var02.getFloat("SpawnAngle");
            if (var02.contains("SpawnDimension")) {
                this.respawnDimension = World.RESOURCE_KEY_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get("SpawnDimension")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(World.OVERWORLD);
            }
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        Object var12;
        super.addAdditionalSaveData(var0);
        WardenSpawnTracker.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.wardenSpawnTracker).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("warden_spawn_tracker", (NBTBase)var1));
        this.storeGameTypes(var0);
        var0.putBoolean("seenCredits", this.seenCredits);
        if (this.enteredNetherPosition != null) {
            var12 = new NBTTagCompound();
            ((NBTTagCompound)var12).putDouble("x", this.enteredNetherPosition.x);
            ((NBTTagCompound)var12).putDouble("y", this.enteredNetherPosition.y);
            ((NBTTagCompound)var12).putDouble("z", this.enteredNetherPosition.z);
            var0.put("enteredNetherPosition", (NBTBase)var12);
        }
        var12 = this.getRootVehicle();
        Entity var2 = this.getVehicle();
        if (var2 != null && var12 != this && ((Entity)var12).hasExactlyOnePlayerPassenger()) {
            NBTTagCompound var3 = new NBTTagCompound();
            NBTTagCompound var4 = new NBTTagCompound();
            ((Entity)var12).save(var4);
            var3.putUUID("Attach", var2.getUUID());
            var3.put("Entity", var4);
            var0.put("RootVehicle", var3);
        }
        var0.put("recipeBook", this.recipeBook.toNbt());
        var0.putString("Dimension", this.level().dimension().location().toString());
        if (this.respawnPosition != null) {
            var0.putInt("SpawnX", this.respawnPosition.getX());
            var0.putInt("SpawnY", this.respawnPosition.getY());
            var0.putInt("SpawnZ", this.respawnPosition.getZ());
            var0.putBoolean("SpawnForced", this.respawnForced);
            var0.putFloat("SpawnAngle", this.respawnAngle);
            MinecraftKey.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.respawnDimension.location()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("SpawnDimension", (NBTBase)var1));
        }
    }

    public void setExperiencePoints(int var0) {
        float var1 = this.getXpNeededForNextLevel();
        float var2 = (var1 - 1.0f) / var1;
        this.experienceProgress = MathHelper.clamp((float)var0 / var1, 0.0f, var2);
        this.lastSentExp = -1;
    }

    public void setExperienceLevels(int var0) {
        this.experienceLevel = var0;
        this.lastSentExp = -1;
    }

    @Override
    public void giveExperienceLevels(int var0) {
        super.giveExperienceLevels(var0);
        this.lastSentExp = -1;
    }

    @Override
    public void onEnchantmentPerformed(ItemStack var0, int var1) {
        super.onEnchantmentPerformed(var0, var1);
        this.lastSentExp = -1;
    }

    public void initMenu(Container var0) {
        var0.addSlotListener(this.containerListener);
        var0.setSynchronizer(this.containerSynchronizer);
    }

    public void initInventoryMenu() {
        this.initMenu(this.inventoryMenu);
    }

    @Override
    public void onEnterCombat() {
        super.onEnterCombat();
        this.connection.send(new ClientboundPlayerCombatEnterPacket());
    }

    @Override
    public void onLeaveCombat() {
        super.onLeaveCombat();
        this.connection.send(new ClientboundPlayerCombatEndPacket(this.getCombatTracker()));
    }

    @Override
    protected void onInsideBlock(IBlockData var0) {
        CriterionTriggers.ENTER_BLOCK.trigger(this, var0);
    }

    @Override
    protected ItemCooldown createItemCooldowns() {
        return new ItemCooldownPlayer(this);
    }

    @Override
    public void tick() {
        Entity var0;
        this.gameMode.tick();
        this.wardenSpawnTracker.tick();
        --this.spawnInvulnerableTime;
        if (this.invulnerableTime > 0) {
            --this.invulnerableTime;
        }
        this.containerMenu.broadcastChanges();
        if (!this.level().isClientSide && !this.containerMenu.stillValid(this)) {
            this.closeContainer();
            this.containerMenu = this.inventoryMenu;
        }
        if ((var0 = this.getCamera()) != this) {
            if (var0.isAlive()) {
                this.absMoveTo(var0.getX(), var0.getY(), var0.getZ(), var0.getYRot(), var0.getXRot());
                this.serverLevel().getChunkSource().move(this);
                if (this.wantsToStopRiding()) {
                    this.setCamera(this);
                }
            } else {
                this.setCamera(this);
            }
        }
        CriterionTriggers.TICK.trigger(this);
        if (this.levitationStartPos != null) {
            CriterionTriggers.LEVITATION.trigger(this, this.levitationStartPos, this.tickCount - this.levitationStartTime);
        }
        this.trackStartFallingPosition();
        this.trackEnteredOrExitedLavaOnVehicle();
        this.advancements.flushDirty(this);
    }

    public void doTick() {
        try {
            if (!this.isSpectator() || !this.touchingUnloadedChunk()) {
                super.tick();
            }
            for (int var0 = 0; var0 < this.getInventory().getContainerSize(); ++var0) {
                Packet<?> var2;
                ItemStack var1 = this.getInventory().getItem(var0);
                if (!var1.getItem().isComplex() || (var2 = ((ItemWorldMapBase)var1.getItem()).getUpdatePacket(var1, this.level(), this)) == null) continue;
                this.connection.send(var2);
            }
            if (this.getHealth() != this.lastSentHealth || this.lastSentFood != this.foodData.getFoodLevel() || this.foodData.getSaturationLevel() == 0.0f != this.lastFoodSaturationZero) {
                this.connection.send(new PacketPlayOutUpdateHealth(this.getHealth(), this.foodData.getFoodLevel(), this.foodData.getSaturationLevel()));
                this.lastSentHealth = this.getHealth();
                this.lastSentFood = this.foodData.getFoodLevel();
                boolean bl = this.lastFoodSaturationZero = this.foodData.getSaturationLevel() == 0.0f;
            }
            if (this.getHealth() + this.getAbsorptionAmount() != this.lastRecordedHealthAndAbsorption) {
                this.lastRecordedHealthAndAbsorption = this.getHealth() + this.getAbsorptionAmount();
                this.updateScoreForCriteria(IScoreboardCriteria.HEALTH, MathHelper.ceil(this.lastRecordedHealthAndAbsorption));
            }
            if (this.foodData.getFoodLevel() != this.lastRecordedFoodLevel) {
                this.lastRecordedFoodLevel = this.foodData.getFoodLevel();
                this.updateScoreForCriteria(IScoreboardCriteria.FOOD, MathHelper.ceil(this.lastRecordedFoodLevel));
            }
            if (this.getAirSupply() != this.lastRecordedAirLevel) {
                this.lastRecordedAirLevel = this.getAirSupply();
                this.updateScoreForCriteria(IScoreboardCriteria.AIR, MathHelper.ceil(this.lastRecordedAirLevel));
            }
            if (this.getArmorValue() != this.lastRecordedArmor) {
                this.lastRecordedArmor = this.getArmorValue();
                this.updateScoreForCriteria(IScoreboardCriteria.ARMOR, MathHelper.ceil(this.lastRecordedArmor));
            }
            if (this.totalExperience != this.lastRecordedExperience) {
                this.lastRecordedExperience = this.totalExperience;
                this.updateScoreForCriteria(IScoreboardCriteria.EXPERIENCE, MathHelper.ceil(this.lastRecordedExperience));
            }
            if (this.experienceLevel != this.lastRecordedLevel) {
                this.lastRecordedLevel = this.experienceLevel;
                this.updateScoreForCriteria(IScoreboardCriteria.LEVEL, MathHelper.ceil(this.lastRecordedLevel));
            }
            if (this.totalExperience != this.lastSentExp) {
                this.lastSentExp = this.totalExperience;
                this.connection.send(new PacketPlayOutExperience(this.experienceProgress, this.totalExperience, this.experienceLevel));
            }
            if (this.tickCount % 20 == 0) {
                CriterionTriggers.LOCATION.trigger(this);
            }
        }
        catch (Throwable var0) {
            CrashReport var1 = CrashReport.forThrowable(var0, "Ticking player");
            CrashReportSystemDetails var2 = var1.addCategory("Player being ticked");
            this.fillCrashReportCategory(var2);
            throw new ReportedException(var1);
        }
    }

    @Override
    public void resetFallDistance() {
        if (this.getHealth() > 0.0f && this.startingToFallPosition != null) {
            CriterionTriggers.FALL_FROM_HEIGHT.trigger(this, this.startingToFallPosition);
        }
        this.startingToFallPosition = null;
        super.resetFallDistance();
    }

    public void trackStartFallingPosition() {
        if (this.fallDistance > 0.0f && this.startingToFallPosition == null) {
            this.startingToFallPosition = this.position();
        }
    }

    public void trackEnteredOrExitedLavaOnVehicle() {
        if (this.getVehicle() != null && this.getVehicle().isInLava()) {
            if (this.enteredLavaOnVehiclePosition == null) {
                this.enteredLavaOnVehiclePosition = this.position();
            } else {
                CriterionTriggers.RIDE_ENTITY_IN_LAVA_TRIGGER.trigger(this, this.enteredLavaOnVehiclePosition);
            }
        }
        if (!(this.enteredLavaOnVehiclePosition == null || this.getVehicle() != null && this.getVehicle().isInLava())) {
            this.enteredLavaOnVehiclePosition = null;
        }
    }

    private void updateScoreForCriteria(IScoreboardCriteria var0, int var12) {
        this.getScoreboard().forAllObjectives(var0, this, var1 -> var1.set(var12));
    }

    @Override
    public void die(DamageSource var0) {
        Object var2;
        this.gameEvent(GameEvent.ENTITY_DIE);
        boolean var1 = this.level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES);
        if (var1) {
            var2 = this.getCombatTracker().getDeathMessage();
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), (IChatBaseComponent)var2), PacketSendListener.exceptionallySend(() -> this.d((IChatBaseComponent)var2)));
            ScoreboardTeam var3 = this.getTeam();
            if (var3 == null || ((ScoreboardTeamBase)var3).getDeathMessageVisibility() == ScoreboardTeamBase.EnumNameTagVisibility.ALWAYS) {
                this.server.getPlayerList().broadcastSystemMessage((IChatBaseComponent)var2, false);
            } else if (((ScoreboardTeamBase)var3).getDeathMessageVisibility() == ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OTHER_TEAMS) {
                this.server.getPlayerList().broadcastSystemToTeam(this, (IChatBaseComponent)var2);
            } else if (((ScoreboardTeamBase)var3).getDeathMessageVisibility() == ScoreboardTeamBase.EnumNameTagVisibility.HIDE_FOR_OWN_TEAM) {
                this.server.getPlayerList().broadcastSystemToAllExceptTeam(this, (IChatBaseComponent)var2);
            }
        } else {
            this.connection.send(new ClientboundPlayerCombatKillPacket(this.getId(), CommonComponents.EMPTY));
        }
        this.removeEntitiesOnShoulder();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_FORGIVE_DEAD_PLAYERS)) {
            this.tellNeutralMobsThatIDied();
        }
        if (!this.isSpectator()) {
            this.dropAllDeathLoot(var0);
        }
        this.getScoreboard().forAllObjectives(IScoreboardCriteria.DEATH_COUNT, this, ScoreAccess::increment);
        var2 = this.getKillCredit();
        if (var2 != null) {
            this.awardStat(StatisticList.ENTITY_KILLED_BY.get(((Entity)var2).getType()));
            ((Entity)var2).awardKillScore(this, this.deathScore, var0);
            this.createWitherRose((EntityLiving)var2);
        }
        this.level().broadcastEntityEvent(this, (byte)3);
        this.awardStat(StatisticList.DEATHS);
        this.resetStat(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_DEATH));
        this.resetStat(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_REST));
        this.clearFire();
        this.setTicksFrozen(0);
        this.setSharedFlagOnFire(false);
        this.getCombatTracker().recheckStatus();
        this.setLastDeathLocation(Optional.of(GlobalPos.of(this.level().dimension(), this.blockPosition())));
    }

    private void tellNeutralMobsThatIDied() {
        AxisAlignedBB var02 = new AxisAlignedBB(this.blockPosition()).inflate(32.0, 10.0, 32.0);
        this.level().getEntitiesOfClass(EntityInsentient.class, var02, IEntitySelector.NO_SPECTATORS).stream().filter(var0 -> var0 instanceof IEntityAngerable).forEach(var0 -> ((IEntityAngerable)((Object)var0)).playerDied(this));
    }

    @Override
    public void awardKillScore(Entity var0, int var1, DamageSource var2) {
        if (var0 == this) {
            return;
        }
        super.awardKillScore(var0, var1, var2);
        this.increaseScore(var1);
        this.getScoreboard().forAllObjectives(IScoreboardCriteria.KILL_COUNT_ALL, this, ScoreAccess::increment);
        if (var0 instanceof EntityHuman) {
            this.awardStat(StatisticList.PLAYER_KILLS);
            this.getScoreboard().forAllObjectives(IScoreboardCriteria.KILL_COUNT_PLAYERS, this, ScoreAccess::increment);
        } else {
            this.awardStat(StatisticList.MOB_KILLS);
        }
        this.handleTeamKill(this, var0, IScoreboardCriteria.TEAM_KILL);
        this.handleTeamKill(var0, this, IScoreboardCriteria.KILLED_BY_TEAM);
        CriterionTriggers.PLAYER_KILLED_ENTITY.trigger(this, var0, var2);
    }

    private void handleTeamKill(ScoreHolder var0, ScoreHolder var1, IScoreboardCriteria[] var2) {
        int var4;
        ScoreboardTeam var3 = this.getScoreboard().getPlayersTeam(var1.getScoreboardName());
        if (var3 != null && (var4 = var3.getColor().getId()) >= 0 && var4 < var2.length) {
            this.getScoreboard().forAllObjectives(var2[var4], var0, ScoreAccess::increment);
        }
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        EntityHuman var6;
        Entity var5;
        Entity var4;
        boolean var2;
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        boolean bl = var2 = this.server.isDedicatedServer() && this.isPvpAllowed() && var0.is(DamageTypeTags.IS_FALL);
        if (!var2 && this.spawnInvulnerableTime > 0 && !var0.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return false;
        }
        Entity var3 = var0.getEntity();
        if (var3 instanceof EntityHuman && !this.canHarmPlayer((EntityHuman)(var4 = (EntityHuman)var3))) {
            return false;
        }
        if (var3 instanceof EntityArrow && (var5 = ((IProjectile)(var4 = (EntityArrow)var3)).getOwner()) instanceof EntityHuman && !this.canHarmPlayer(var6 = (EntityHuman)var5)) {
            return false;
        }
        return super.hurt(var0, var1);
    }

    @Override
    public boolean canHarmPlayer(EntityHuman var0) {
        if (!this.isPvpAllowed()) {
            return false;
        }
        return super.canHarmPlayer(var0);
    }

    private boolean isPvpAllowed() {
        return this.server.isPvpAllowed();
    }

    @Override
    @Nullable
    protected ShapeDetectorShape findDimensionEntryPoint(WorldServer var0) {
        ShapeDetectorShape var1 = super.findDimensionEntryPoint(var0);
        if (var1 != null && this.level().dimension() == World.OVERWORLD && var0.dimension() == World.END) {
            Vec3D var2 = var1.pos.add(0.0, -1.0, 0.0);
            return new ShapeDetectorShape(var2, Vec3D.ZERO, 90.0f, 0.0f);
        }
        return var1;
    }

    @Override
    @Nullable
    public Entity changeDimension(WorldServer var0) {
        this.isChangingDimension = true;
        WorldServer var1 = this.serverLevel();
        ResourceKey<World> var2 = var1.dimension();
        if (var2 == World.END && var0.dimension() == World.OVERWORLD) {
            this.unRide();
            this.serverLevel().removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
            if (!this.wonGame) {
                this.wonGame = true;
                this.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.WIN_GAME, this.seenCredits ? 0.0f : 1.0f));
                this.seenCredits = true;
            }
            return this;
        }
        WorldData var3 = var0.getLevelData();
        this.connection.send(new PacketPlayOutRespawn(this.createCommonSpawnInfo(var0), 3));
        this.connection.send(new PacketPlayOutServerDifficulty(var3.getDifficulty(), var3.isDifficultyLocked()));
        PlayerList var4 = this.server.getPlayerList();
        var4.sendPlayerPermissionLevel(this);
        var1.removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
        this.unsetRemoved();
        ShapeDetectorShape var5 = this.findDimensionEntryPoint(var0);
        if (var5 != null) {
            var1.getProfiler().push("moving");
            if (var2 == World.OVERWORLD && var0.dimension() == World.NETHER) {
                this.enteredNetherPosition = this.position();
            } else if (var0.dimension() == World.END) {
                this.createEndPlatform(var0, BlockPosition.containing(var5.pos));
            }
            var1.getProfiler().pop();
            var1.getProfiler().push("placing");
            this.setServerLevel(var0);
            this.connection.teleport(var5.pos.x, var5.pos.y, var5.pos.z, var5.yRot, var5.xRot);
            this.connection.resetPosition();
            var0.addDuringPortalTeleport(this);
            var1.getProfiler().pop();
            this.triggerDimensionChangeTriggers(var1);
            this.connection.send(new PacketPlayOutAbilities(this.getAbilities()));
            var4.sendLevelInfo(this, var0);
            var4.sendAllPlayerInfo(this);
            for (MobEffect var7 : this.getActiveEffects()) {
                this.connection.send(new PacketPlayOutEntityEffect(this.getId(), var7));
            }
            this.connection.send(new PacketPlayOutWorldEvent(1032, BlockPosition.ZERO, 0, false));
            this.lastSentExp = -1;
            this.lastSentHealth = -1.0f;
            this.lastSentFood = -1;
        }
        return this;
    }

    private void createEndPlatform(WorldServer var0, BlockPosition var1) {
        BlockPosition.MutableBlockPosition var2 = var1.mutable();
        for (int var3 = -2; var3 <= 2; ++var3) {
            for (int var4 = -2; var4 <= 2; ++var4) {
                for (int var5 = -1; var5 < 3; ++var5) {
                    IBlockData var6 = var5 == -1 ? Blocks.OBSIDIAN.defaultBlockState() : Blocks.AIR.defaultBlockState();
                    var0.setBlockAndUpdate(var2.set(var1).move(var4, var5, var3), var6);
                }
            }
        }
    }

    @Override
    protected Optional<BlockUtil.Rectangle> getExitPortal(WorldServer var0, BlockPosition var1, boolean var2, WorldBorder var3) {
        Optional<BlockUtil.Rectangle> var4 = super.getExitPortal(var0, var1, var2, var3);
        if (var4.isPresent()) {
            return var4;
        }
        EnumDirection.EnumAxis var5 = this.level().getBlockState(this.portalEntrancePos).getOptionalValue(BlockPortal.AXIS).orElse(EnumDirection.EnumAxis.X);
        Optional<BlockUtil.Rectangle> var6 = var0.getPortalForcer().createPortal(var1, var5);
        if (var6.isEmpty()) {
            LOGGER.error("Unable to create a portal, likely target out of worldborder");
        }
        return var6;
    }

    public void triggerDimensionChangeTriggers(WorldServer var0) {
        ResourceKey<World> var1 = var0.dimension();
        ResourceKey<World> var2 = this.level().dimension();
        CriterionTriggers.CHANGED_DIMENSION.trigger(this, var1, var2);
        if (var1 == World.NETHER && var2 == World.OVERWORLD && this.enteredNetherPosition != null) {
            CriterionTriggers.NETHER_TRAVEL.trigger(this, this.enteredNetherPosition);
        }
        if (var2 != World.NETHER) {
            this.enteredNetherPosition = null;
        }
    }

    @Override
    public boolean broadcastToPlayer(EntityPlayer var0) {
        if (var0.isSpectator()) {
            return this.getCamera() == this;
        }
        if (this.isSpectator()) {
            return false;
        }
        return super.broadcastToPlayer(var0);
    }

    @Override
    public void take(Entity var0, int var1) {
        super.take(var0, var1);
        this.containerMenu.broadcastChanges();
    }

    @Override
    public Either<EntityHuman.EnumBedResult, Unit> startSleepInBed(BlockPosition var02) {
        EnumDirection var1 = this.level().getBlockState(var02).getValue(BlockFacingHorizontal.FACING);
        if (this.isSleeping() || !this.isAlive()) {
            return Either.left((Object)((Object)EntityHuman.EnumBedResult.OTHER_PROBLEM));
        }
        if (!this.level().dimensionType().natural()) {
            return Either.left((Object)((Object)EntityHuman.EnumBedResult.NOT_POSSIBLE_HERE));
        }
        if (!this.bedInRange(var02, var1)) {
            return Either.left((Object)((Object)EntityHuman.EnumBedResult.TOO_FAR_AWAY));
        }
        if (this.bedBlocked(var02, var1)) {
            return Either.left((Object)((Object)EntityHuman.EnumBedResult.OBSTRUCTED));
        }
        this.setRespawnPosition(this.level().dimension(), var02, this.getYRot(), false, true);
        if (this.level().isDay()) {
            return Either.left((Object)((Object)EntityHuman.EnumBedResult.NOT_POSSIBLE_NOW));
        }
        if (!this.isCreative()) {
            double var2 = 8.0;
            double var4 = 5.0;
            Vec3D var6 = Vec3D.atBottomCenterOf(var02);
            List<EntityMonster> var7 = this.level().getEntitiesOfClass(EntityMonster.class, new AxisAlignedBB(var6.x() - 8.0, var6.y() - 5.0, var6.z() - 8.0, var6.x() + 8.0, var6.y() + 5.0, var6.z() + 8.0), var0 -> var0.isPreventingPlayerRest(this));
            if (!var7.isEmpty()) {
                return Either.left((Object)((Object)EntityHuman.EnumBedResult.NOT_SAFE));
            }
        }
        Either var2 = super.startSleepInBed(var02).ifRight(var0 -> {
            this.awardStat(StatisticList.SLEEP_IN_BED);
            CriterionTriggers.SLEPT_IN_BED.trigger(this);
        });
        if (!this.serverLevel().canSleepThroughNights()) {
            this.displayClientMessage(IChatBaseComponent.translatable("sleep.not_possible"), true);
        }
        ((WorldServer)this.level()).updateSleepingPlayerList();
        return var2;
    }

    @Override
    public void startSleeping(BlockPosition var0) {
        this.resetStat(StatisticList.CUSTOM.get(StatisticList.TIME_SINCE_REST));
        super.startSleeping(var0);
    }

    private boolean bedInRange(BlockPosition var0, EnumDirection var1) {
        return this.isReachableBedBlock(var0) || this.isReachableBedBlock(var0.relative(var1.getOpposite()));
    }

    private boolean isReachableBedBlock(BlockPosition var0) {
        Vec3D var1 = Vec3D.atBottomCenterOf(var0);
        return Math.abs(this.getX() - var1.x()) <= 3.0 && Math.abs(this.getY() - var1.y()) <= 2.0 && Math.abs(this.getZ() - var1.z()) <= 3.0;
    }

    private boolean bedBlocked(BlockPosition var0, EnumDirection var1) {
        BlockPosition var2 = var0.above();
        return !this.freeAt(var2) || !this.freeAt(var2.relative(var1.getOpposite()));
    }

    @Override
    public void stopSleepInBed(boolean var0, boolean var1) {
        if (this.isSleeping()) {
            this.serverLevel().getChunkSource().broadcastAndSend(this, new PacketPlayOutAnimation(this, 2));
        }
        super.stopSleepInBed(var0, var1);
        if (this.connection != null) {
            this.connection.teleport(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
        }
    }

    @Override
    public void dismountTo(double var0, double var2, double var4) {
        this.removeVehicle();
        this.setPos(var0, var2, var4);
    }

    @Override
    public boolean isInvulnerableTo(DamageSource var0) {
        return super.isInvulnerableTo(var0) || this.isChangingDimension();
    }

    @Override
    protected void checkFallDamage(double var0, boolean var2, IBlockData var3, BlockPosition var4) {
    }

    @Override
    protected void onChangedBlock(BlockPosition var0) {
        if (!this.isSpectator()) {
            super.onChangedBlock(var0);
        }
    }

    public void doCheckFallDamage(double var0, double var2, double var4, boolean var6) {
        if (this.touchingUnloadedChunk()) {
            return;
        }
        this.checkSupportingBlock(var6, new Vec3D(var0, var2, var4));
        BlockPosition var7 = this.getOnPosLegacy();
        super.checkFallDamage(var2, var6, this.level().getBlockState(var7), var7);
    }

    @Override
    protected void pushEntities() {
        if (this.level().tickRateManager().runsNormally()) {
            super.pushEntities();
        }
    }

    @Override
    public void openTextEdit(TileEntitySign var0, boolean var1) {
        this.connection.send(new PacketPlayOutBlockChange(this.level(), var0.getBlockPos()));
        this.connection.send(new PacketPlayOutOpenSignEditor(var0.getBlockPos(), var1));
    }

    public void nextContainerCounter() {
        this.containerCounter = this.containerCounter % 100 + 1;
    }

    @Override
    public OptionalInt openMenu(@Nullable ITileInventory var0) {
        if (var0 == null) {
            return OptionalInt.empty();
        }
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer();
        }
        this.nextContainerCounter();
        Container var1 = var0.createMenu(this.containerCounter, this.getInventory(), this);
        if (var1 == null) {
            if (this.isSpectator()) {
                this.displayClientMessage(IChatBaseComponent.translatable("container.spectatorCantOpen").withStyle(EnumChatFormat.RED), true);
            }
            return OptionalInt.empty();
        }
        this.connection.send(new PacketPlayOutOpenWindow(var1.containerId, var1.getType(), var0.getDisplayName()));
        this.initMenu(var1);
        this.containerMenu = var1;
        return OptionalInt.of(this.containerCounter);
    }

    @Override
    public void sendMerchantOffers(int var0, MerchantRecipeList var1, int var2, int var3, boolean var4, boolean var5) {
        this.connection.send(new PacketPlayOutOpenWindowMerchant(var0, var1, var2, var3, var4, var5));
    }

    @Override
    public void openHorseInventory(EntityHorseAbstract var0, IInventory var1) {
        if (this.containerMenu != this.inventoryMenu) {
            this.closeContainer();
        }
        this.nextContainerCounter();
        this.connection.send(new PacketPlayOutOpenWindowHorse(this.containerCounter, var1.getContainerSize(), var0.getId()));
        this.containerMenu = new ContainerHorse(this.containerCounter, this.getInventory(), var1, var0);
        this.initMenu(this.containerMenu);
    }

    @Override
    public void openItemGui(ItemStack var0, EnumHand var1) {
        if (var0.is(Items.WRITTEN_BOOK)) {
            if (ItemWrittenBook.resolveBookComponents(var0, this.createCommandSourceStack(), this)) {
                this.containerMenu.broadcastChanges();
            }
            this.connection.send(new PacketPlayOutOpenBook(var1));
        }
    }

    @Override
    public void openCommandBlock(TileEntityCommand var0) {
        this.connection.send(PacketPlayOutTileEntityData.create(var0, TileEntity::saveWithoutMetadata));
    }

    @Override
    public void closeContainer() {
        this.connection.send(new PacketPlayOutCloseWindow(this.containerMenu.containerId));
        this.doCloseContainer();
    }

    @Override
    public void doCloseContainer() {
        this.containerMenu.removed(this);
        this.inventoryMenu.transferState(this.containerMenu);
        this.containerMenu = this.inventoryMenu;
    }

    public void setPlayerInput(float var0, float var1, boolean var2, boolean var3) {
        if (this.isPassenger()) {
            if (var0 >= -1.0f && var0 <= 1.0f) {
                this.xxa = var0;
            }
            if (var1 >= -1.0f && var1 <= 1.0f) {
                this.zza = var1;
            }
            this.jumping = var2;
            this.setShiftKeyDown(var3);
        }
    }

    @Override
    public void travel(Vec3D var0) {
        double var1 = this.getX();
        double var3 = this.getY();
        double var5 = this.getZ();
        super.travel(var0);
        this.checkMovementStatistics(this.getX() - var1, this.getY() - var3, this.getZ() - var5);
    }

    @Override
    public void rideTick() {
        double var0 = this.getX();
        double var2 = this.getY();
        double var4 = this.getZ();
        super.rideTick();
        this.checkRidingStatistics(this.getX() - var0, this.getY() - var2, this.getZ() - var4);
    }

    public void checkMovementStatistics(double var0, double var2, double var4) {
        if (this.isPassenger() || EntityPlayer.didNotMove(var0, var2, var4)) {
            return;
        }
        if (this.isSwimming()) {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var2 * var2 + var4 * var4) * 100.0f);
            if (var6 > 0) {
                this.awardStat(StatisticList.SWIM_ONE_CM, var6);
                this.causeFoodExhaustion(0.01f * (float)var6 * 0.01f);
            }
        } else if (this.isEyeInFluid(TagsFluid.WATER)) {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var2 * var2 + var4 * var4) * 100.0f);
            if (var6 > 0) {
                this.awardStat(StatisticList.WALK_UNDER_WATER_ONE_CM, var6);
                this.causeFoodExhaustion(0.01f * (float)var6 * 0.01f);
            }
        } else if (this.isInWater()) {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var4 * var4) * 100.0f);
            if (var6 > 0) {
                this.awardStat(StatisticList.WALK_ON_WATER_ONE_CM, var6);
                this.causeFoodExhaustion(0.01f * (float)var6 * 0.01f);
            }
        } else if (this.onClimbable()) {
            if (var2 > 0.0) {
                this.awardStat(StatisticList.CLIMB_ONE_CM, (int)Math.round(var2 * 100.0));
            }
        } else if (this.onGround()) {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var4 * var4) * 100.0f);
            if (var6 > 0) {
                if (this.isSprinting()) {
                    this.awardStat(StatisticList.SPRINT_ONE_CM, var6);
                    this.causeFoodExhaustion(0.1f * (float)var6 * 0.01f);
                } else if (this.isCrouching()) {
                    this.awardStat(StatisticList.CROUCH_ONE_CM, var6);
                    this.causeFoodExhaustion(0.0f * (float)var6 * 0.01f);
                } else {
                    this.awardStat(StatisticList.WALK_ONE_CM, var6);
                    this.causeFoodExhaustion(0.0f * (float)var6 * 0.01f);
                }
            }
        } else if (this.isFallFlying()) {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var2 * var2 + var4 * var4) * 100.0f);
            this.awardStat(StatisticList.AVIATE_ONE_CM, var6);
        } else {
            int var6 = Math.round((float)Math.sqrt(var0 * var0 + var4 * var4) * 100.0f);
            if (var6 > 25) {
                this.awardStat(StatisticList.FLY_ONE_CM, var6);
            }
        }
    }

    private void checkRidingStatistics(double var0, double var2, double var4) {
        if (!this.isPassenger() || EntityPlayer.didNotMove(var0, var2, var4)) {
            return;
        }
        int var6 = Math.round((float)Math.sqrt(var0 * var0 + var2 * var2 + var4 * var4) * 100.0f);
        Entity var7 = this.getVehicle();
        if (var7 instanceof EntityMinecartAbstract) {
            this.awardStat(StatisticList.MINECART_ONE_CM, var6);
        } else if (var7 instanceof EntityBoat) {
            this.awardStat(StatisticList.BOAT_ONE_CM, var6);
        } else if (var7 instanceof EntityPig) {
            this.awardStat(StatisticList.PIG_ONE_CM, var6);
        } else if (var7 instanceof EntityHorseAbstract) {
            this.awardStat(StatisticList.HORSE_ONE_CM, var6);
        } else if (var7 instanceof EntityStrider) {
            this.awardStat(StatisticList.STRIDER_ONE_CM, var6);
        }
    }

    private static boolean didNotMove(double var0, double var2, double var4) {
        return var0 == 0.0 && var2 == 0.0 && var4 == 0.0;
    }

    @Override
    public void awardStat(Statistic<?> var0, int var12) {
        this.stats.increment(this, var0, var12);
        this.getScoreboard().forAllObjectives(var0, this, var1 -> var1.add(var12));
    }

    @Override
    public void resetStat(Statistic<?> var0) {
        this.stats.setValue(this, var0, 0);
        this.getScoreboard().forAllObjectives(var0, this, ScoreAccess::reset);
    }

    @Override
    public int awardRecipes(Collection<RecipeHolder<?>> var0) {
        return this.recipeBook.addRecipes(var0, this);
    }

    @Override
    public void triggerRecipeCrafted(RecipeHolder<?> var0, List<ItemStack> var1) {
        CriterionTriggers.RECIPE_CRAFTED.trigger(this, var0.id(), var1);
    }

    @Override
    public void awardRecipesByKey(List<MinecraftKey> var02) {
        List<RecipeHolder<?>> var1 = var02.stream().flatMap(var0 -> this.server.getRecipeManager().byKey((MinecraftKey)var0).stream()).collect(Collectors.toList());
        this.awardRecipes(var1);
    }

    @Override
    public int resetRecipes(Collection<RecipeHolder<?>> var0) {
        return this.recipeBook.removeRecipes(var0, this);
    }

    @Override
    public void giveExperiencePoints(int var0) {
        super.giveExperiencePoints(var0);
        this.lastSentExp = -1;
    }

    public void disconnect() {
        this.disconnected = true;
        this.ejectPassengers();
        if (this.isSleeping()) {
            this.stopSleepInBed(true, false);
        }
    }

    public boolean hasDisconnected() {
        return this.disconnected;
    }

    public void resetSentInfo() {
        this.lastSentHealth = -1.0E8f;
    }

    @Override
    public void displayClientMessage(IChatBaseComponent var0, boolean var1) {
        this.sendSystemMessage(var0, var1);
    }

    @Override
    protected void completeUsingItem() {
        if (!this.useItem.isEmpty() && this.isUsingItem()) {
            this.connection.send(new PacketPlayOutEntityStatus(this, 9));
            super.completeUsingItem();
        }
    }

    @Override
    public void lookAt(ArgumentAnchor.Anchor var0, Vec3D var1) {
        super.lookAt(var0, var1);
        this.connection.send(new PacketPlayOutLookAt(var0, var1.x, var1.y, var1.z));
    }

    public void lookAt(ArgumentAnchor.Anchor var0, Entity var1, ArgumentAnchor.Anchor var2) {
        Vec3D var3 = var2.apply(var1);
        super.lookAt(var0, var3);
        this.connection.send(new PacketPlayOutLookAt(var0, var1, var2));
    }

    public void restoreFrom(EntityPlayer var0, boolean var1) {
        this.wardenSpawnTracker = var0.wardenSpawnTracker;
        this.chatSession = var0.chatSession;
        this.gameMode.setGameModeForPlayer(var0.gameMode.getGameModeForPlayer(), var0.gameMode.getPreviousGameModeForPlayer());
        this.onUpdateAbilities();
        if (var1) {
            this.getInventory().replaceWith(var0.getInventory());
            this.setHealth(var0.getHealth());
            this.foodData = var0.foodData;
            this.experienceLevel = var0.experienceLevel;
            this.totalExperience = var0.totalExperience;
            this.experienceProgress = var0.experienceProgress;
            this.setScore(var0.getScore());
            this.portalEntrancePos = var0.portalEntrancePos;
        } else if (this.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) || var0.isSpectator()) {
            this.getInventory().replaceWith(var0.getInventory());
            this.experienceLevel = var0.experienceLevel;
            this.totalExperience = var0.totalExperience;
            this.experienceProgress = var0.experienceProgress;
            this.setScore(var0.getScore());
        }
        this.enchantmentSeed = var0.enchantmentSeed;
        this.enderChestInventory = var0.enderChestInventory;
        this.getEntityData().set(DATA_PLAYER_MODE_CUSTOMISATION, (Byte)var0.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION));
        this.lastSentExp = -1;
        this.lastSentHealth = -1.0f;
        this.lastSentFood = -1;
        this.recipeBook.copyOverData(var0.recipeBook);
        this.seenCredits = var0.seenCredits;
        this.enteredNetherPosition = var0.enteredNetherPosition;
        this.chunkTrackingView = var0.chunkTrackingView;
        this.setShoulderEntityLeft(var0.getShoulderEntityLeft());
        this.setShoulderEntityRight(var0.getShoulderEntityRight());
        this.setLastDeathLocation(var0.getLastDeathLocation());
    }

    @Override
    protected void onEffectAdded(MobEffect var0, @Nullable Entity var1) {
        super.onEffectAdded(var0, var1);
        this.connection.send(new PacketPlayOutEntityEffect(this.getId(), var0));
        if (var0.getEffect() == MobEffects.LEVITATION) {
            this.levitationStartTime = this.tickCount;
            this.levitationStartPos = this.position();
        }
        CriterionTriggers.EFFECTS_CHANGED.trigger(this, var1);
    }

    @Override
    protected void onEffectUpdated(MobEffect var0, boolean var1, @Nullable Entity var2) {
        super.onEffectUpdated(var0, var1, var2);
        this.connection.send(new PacketPlayOutEntityEffect(this.getId(), var0));
        CriterionTriggers.EFFECTS_CHANGED.trigger(this, var2);
    }

    @Override
    protected void onEffectRemoved(MobEffect var0) {
        super.onEffectRemoved(var0);
        this.connection.send(new PacketPlayOutRemoveEntityEffect(this.getId(), var0.getEffect()));
        if (var0.getEffect() == MobEffects.LEVITATION) {
            this.levitationStartPos = null;
        }
        CriterionTriggers.EFFECTS_CHANGED.trigger(this, (Entity)null);
    }

    @Override
    public void teleportTo(double var0, double var2, double var4) {
        this.connection.teleport(var0, var2, var4, this.getYRot(), this.getXRot(), RelativeMovement.ROTATION);
    }

    @Override
    public void teleportRelative(double var0, double var2, double var4) {
        this.connection.teleport(this.getX() + var0, this.getY() + var2, this.getZ() + var4, this.getYRot(), this.getXRot(), RelativeMovement.ALL);
    }

    @Override
    public boolean teleportTo(WorldServer var0, double var1, double var3, double var5, Set<RelativeMovement> var7, float var8, float var9) {
        ChunkCoordIntPair var10 = new ChunkCoordIntPair(BlockPosition.containing(var1, var3, var5));
        var0.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, var10, 1, this.getId());
        this.stopRiding();
        if (this.isSleeping()) {
            this.stopSleepInBed(true, true);
        }
        if (var0 == this.level()) {
            this.connection.teleport(var1, var3, var5, var8, var9, var7);
        } else {
            this.teleportTo(var0, var1, var3, var5, var8, var9);
        }
        this.setYHeadRot(var8);
        return true;
    }

    @Override
    public void moveTo(double var0, double var2, double var4) {
        super.moveTo(var0, var2, var4);
        this.connection.resetPosition();
    }

    @Override
    public void crit(Entity var0) {
        this.serverLevel().getChunkSource().broadcastAndSend(this, new PacketPlayOutAnimation(var0, 4));
    }

    @Override
    public void magicCrit(Entity var0) {
        this.serverLevel().getChunkSource().broadcastAndSend(this, new PacketPlayOutAnimation(var0, 5));
    }

    @Override
    public void onUpdateAbilities() {
        if (this.connection == null) {
            return;
        }
        this.connection.send(new PacketPlayOutAbilities(this.getAbilities()));
        this.updateInvisibilityStatus();
    }

    public WorldServer serverLevel() {
        return (WorldServer)this.level();
    }

    public boolean setGameMode(EnumGamemode var0) {
        if (!this.gameMode.changeGameModeForPlayer(var0)) {
            return false;
        }
        this.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.CHANGE_GAME_MODE, var0.getId()));
        if (var0 == EnumGamemode.SPECTATOR) {
            this.removeEntitiesOnShoulder();
            this.stopRiding();
        } else {
            this.setCamera(this);
        }
        this.onUpdateAbilities();
        this.updateEffectVisibility();
        return true;
    }

    @Override
    public boolean isSpectator() {
        return this.gameMode.getGameModeForPlayer() == EnumGamemode.SPECTATOR;
    }

    @Override
    public boolean isCreative() {
        return this.gameMode.getGameModeForPlayer() == EnumGamemode.CREATIVE;
    }

    @Override
    public void sendSystemMessage(IChatBaseComponent var0) {
        this.sendSystemMessage(var0, false);
    }

    public void sendSystemMessage(IChatBaseComponent var0, boolean var1) {
        if (!this.acceptsSystemMessages(var1)) {
            return;
        }
        this.connection.send(new ClientboundSystemChatPacket(var0, var1), PacketSendListener.exceptionallySend(() -> {
            if (this.acceptsSystemMessages(false)) {
                int var1 = 256;
                String var2 = var0.getString(256);
                IChatMutableComponent var3 = IChatBaseComponent.literal(var2).withStyle(EnumChatFormat.YELLOW);
                return new ClientboundSystemChatPacket(IChatBaseComponent.translatable("multiplayer.message_not_delivered", var3).withStyle(EnumChatFormat.RED), false);
            }
            return null;
        }));
    }

    public void sendChatMessage(OutgoingChatMessage var0, boolean var1, ChatMessageType.a var2) {
        if (this.acceptsChatMessages()) {
            var0.sendToPlayer(this, var1, var2);
        }
    }

    public String getIpAddress() {
        SocketAddress var0 = this.connection.getRemoteAddress();
        if (var0 instanceof InetSocketAddress) {
            InetSocketAddress var1 = (InetSocketAddress)var0;
            return InetAddresses.toAddrString((InetAddress)var1.getAddress());
        }
        return "<unknown>";
    }

    public void updateOptions(ClientInformation var0) {
        this.language = var0.language();
        this.requestedViewDistance = var0.viewDistance();
        this.chatVisibility = var0.chatVisibility();
        this.canChatColor = var0.chatColors();
        this.textFilteringEnabled = var0.textFilteringEnabled();
        this.allowsListing = var0.allowsListing();
        this.getEntityData().set(DATA_PLAYER_MODE_CUSTOMISATION, (byte)var0.modelCustomisation());
        this.getEntityData().set(DATA_PLAYER_MAIN_HAND, (byte)var0.mainHand().getId());
    }

    public ClientInformation clientInformation() {
        byte var0 = (Byte)this.getEntityData().get(DATA_PLAYER_MODE_CUSTOMISATION);
        EnumMainHand var1 = EnumMainHand.BY_ID.apply(((Byte)this.getEntityData().get(DATA_PLAYER_MAIN_HAND)).byteValue());
        return new ClientInformation(this.language, this.requestedViewDistance, this.chatVisibility, this.canChatColor, var0, var1, this.textFilteringEnabled, this.allowsListing);
    }

    public boolean canChatInColor() {
        return this.canChatColor;
    }

    public EnumChatVisibility getChatVisibility() {
        return this.chatVisibility;
    }

    private boolean acceptsSystemMessages(boolean var0) {
        if (this.chatVisibility == EnumChatVisibility.HIDDEN) {
            return var0;
        }
        return true;
    }

    private boolean acceptsChatMessages() {
        return this.chatVisibility == EnumChatVisibility.FULL;
    }

    public int requestedViewDistance() {
        return this.requestedViewDistance;
    }

    public void sendServerStatus(ServerPing var0) {
        this.connection.send(new ClientboundServerDataPacket(var0.description(), var0.favicon().map(ServerPing.a::iconBytes), var0.enforcesSecureChat()));
    }

    @Override
    protected int getPermissionLevel() {
        return this.server.getProfilePermissions(this.getGameProfile());
    }

    public void resetLastActionTime() {
        this.lastActionTime = SystemUtils.getMillis();
    }

    public ServerStatisticManager getStats() {
        return this.stats;
    }

    public RecipeBookServer getRecipeBook() {
        return this.recipeBook;
    }

    @Override
    protected void updateInvisibilityStatus() {
        if (this.isSpectator()) {
            this.removeEffectParticles();
            this.setInvisible(true);
        } else {
            super.updateInvisibilityStatus();
        }
    }

    public Entity getCamera() {
        return this.camera == null ? this : this.camera;
    }

    public void setCamera(@Nullable Entity var0) {
        Entity var1 = this.getCamera();
        Entity entity = this.camera = var0 == null ? this : var0;
        if (var1 != this.camera) {
            World world = this.camera.level();
            if (world instanceof WorldServer) {
                WorldServer var2 = (WorldServer)world;
                this.teleportTo(var2, this.camera.getX(), this.camera.getY(), this.camera.getZ(), Set.of(), this.getYRot(), this.getXRot());
            }
            if (var0 != null) {
                this.serverLevel().getChunkSource().move(this);
            }
            this.connection.send(new PacketPlayOutCamera(this.camera));
            this.connection.resetPosition();
        }
    }

    @Override
    protected void processPortalCooldown() {
        if (!this.isChangingDimension) {
            super.processPortalCooldown();
        }
    }

    @Override
    public void attack(Entity var0) {
        if (this.gameMode.getGameModeForPlayer() == EnumGamemode.SPECTATOR) {
            this.setCamera(var0);
        } else {
            super.attack(var0);
        }
    }

    public long getLastActionTime() {
        return this.lastActionTime;
    }

    @Nullable
    public IChatBaseComponent getTabListDisplayName() {
        return null;
    }

    @Override
    public void swing(EnumHand var0) {
        super.swing(var0);
        this.resetAttackStrengthTicker();
    }

    public boolean isChangingDimension() {
        return this.isChangingDimension;
    }

    public void hasChangedDimension() {
        this.isChangingDimension = false;
    }

    public AdvancementDataPlayer getAdvancements() {
        return this.advancements;
    }

    public void teleportTo(WorldServer var0, double var1, double var3, double var5, float var7, float var8) {
        this.setCamera(this);
        this.stopRiding();
        if (var0 == this.level()) {
            this.connection.teleport(var1, var3, var5, var7, var8);
        } else {
            WorldServer var9 = this.serverLevel();
            WorldData var10 = var0.getLevelData();
            this.connection.send(new PacketPlayOutRespawn(this.createCommonSpawnInfo(var0), 3));
            this.connection.send(new PacketPlayOutServerDifficulty(var10.getDifficulty(), var10.isDifficultyLocked()));
            this.server.getPlayerList().sendPlayerPermissionLevel(this);
            var9.removePlayerImmediately(this, Entity.RemovalReason.CHANGED_DIMENSION);
            this.unsetRemoved();
            this.moveTo(var1, var3, var5, var7, var8);
            this.setServerLevel(var0);
            var0.addDuringCommandTeleport(this);
            this.triggerDimensionChangeTriggers(var9);
            this.connection.teleport(var1, var3, var5, var7, var8);
            this.server.getPlayerList().sendLevelInfo(this, var0);
            this.server.getPlayerList().sendAllPlayerInfo(this);
        }
    }

    @Nullable
    public BlockPosition getRespawnPosition() {
        return this.respawnPosition;
    }

    public float getRespawnAngle() {
        return this.respawnAngle;
    }

    public ResourceKey<World> getRespawnDimension() {
        return this.respawnDimension;
    }

    public boolean isRespawnForced() {
        return this.respawnForced;
    }

    public void setRespawnPosition(ResourceKey<World> var0, @Nullable BlockPosition var1, float var2, boolean var3, boolean var4) {
        if (var1 != null) {
            boolean var5;
            boolean bl = var5 = var1.equals(this.respawnPosition) && var0.equals(this.respawnDimension);
            if (var4 && !var5) {
                this.sendSystemMessage(IChatBaseComponent.translatable("block.minecraft.set_spawn"));
            }
            this.respawnPosition = var1;
            this.respawnDimension = var0;
            this.respawnAngle = var2;
            this.respawnForced = var3;
        } else {
            this.respawnPosition = null;
            this.respawnDimension = World.OVERWORLD;
            this.respawnAngle = 0.0f;
            this.respawnForced = false;
        }
    }

    public SectionPosition getLastSectionPos() {
        return this.lastSectionPos;
    }

    public void setLastSectionPos(SectionPosition var0) {
        this.lastSectionPos = var0;
    }

    public ChunkTrackingView getChunkTrackingView() {
        return this.chunkTrackingView;
    }

    public void setChunkTrackingView(ChunkTrackingView var0) {
        this.chunkTrackingView = var0;
    }

    @Override
    public void playNotifySound(SoundEffect var0, SoundCategory var1, float var2, float var3) {
        this.connection.send(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(var0), var1, this.getX(), this.getY(), this.getZ(), var2, var3, this.random.nextLong()));
    }

    @Override
    public EntityItem drop(ItemStack var0, boolean var1, boolean var2) {
        EntityItem var3 = super.drop(var0, var1, var2);
        if (var3 == null) {
            return null;
        }
        this.level().addFreshEntity(var3);
        ItemStack var4 = var3.getItem();
        if (var2) {
            if (!var4.isEmpty()) {
                this.awardStat(StatisticList.ITEM_DROPPED.get(var4.getItem()), var0.getCount());
            }
            this.awardStat(StatisticList.DROP);
        }
        return var3;
    }

    public ITextFilter getTextFilter() {
        return this.textFilter;
    }

    public void setServerLevel(WorldServer var0) {
        this.setLevel(var0);
        this.gameMode.setLevel(var0);
    }

    @Nullable
    private static EnumGamemode readPlayerMode(@Nullable NBTTagCompound var0, String var1) {
        return var0 != null && var0.contains(var1, 99) ? EnumGamemode.byId(var0.getInt(var1)) : null;
    }

    private EnumGamemode calculateGameModeForNewPlayer(@Nullable EnumGamemode var0) {
        EnumGamemode var1 = this.server.getForcedGameType();
        if (var1 != null) {
            return var1;
        }
        return var0 != null ? var0 : this.server.getDefaultGameType();
    }

    public void loadGameTypes(@Nullable NBTTagCompound var0) {
        this.gameMode.setGameModeForPlayer(this.calculateGameModeForNewPlayer(EntityPlayer.readPlayerMode(var0, "playerGameType")), EntityPlayer.readPlayerMode(var0, "previousPlayerGameType"));
    }

    private void storeGameTypes(NBTTagCompound var0) {
        var0.putInt("playerGameType", this.gameMode.getGameModeForPlayer().getId());
        EnumGamemode var1 = this.gameMode.getPreviousGameModeForPlayer();
        if (var1 != null) {
            var0.putInt("previousPlayerGameType", var1.getId());
        }
    }

    @Override
    public boolean isTextFilteringEnabled() {
        return this.textFilteringEnabled;
    }

    public boolean shouldFilterMessageTo(EntityPlayer var0) {
        if (var0 == this) {
            return false;
        }
        return this.textFilteringEnabled || var0.textFilteringEnabled;
    }

    @Override
    public boolean mayInteract(World var0, BlockPosition var1) {
        return super.mayInteract(var0, var1) && var0.mayInteract(this, var1);
    }

    @Override
    protected void updateUsingItem(ItemStack var0) {
        CriterionTriggers.USING_ITEM.trigger(this, var0);
        super.updateUsingItem(var0);
    }

    public boolean drop(boolean var0) {
        PlayerInventory var12 = this.getInventory();
        ItemStack var2 = var12.removeFromSelected(var0);
        this.containerMenu.findSlot(var12, var12.selected).ifPresent(var1 -> this.containerMenu.setRemoteSlot(var1, var12.getSelected()));
        return this.drop(var2, false, true) != null;
    }

    public boolean allowsListing() {
        return this.allowsListing;
    }

    @Override
    public Optional<WardenSpawnTracker> getWardenSpawnTracker() {
        return Optional.of(this.wardenSpawnTracker);
    }

    @Override
    public void onItemPickup(EntityItem var0) {
        super.onItemPickup(var0);
        Entity var1 = var0.getOwner();
        if (var1 != null) {
            CriterionTriggers.THROWN_ITEM_PICKED_UP_BY_PLAYER.trigger(this, var0.getItem(), var1);
        }
    }

    public void setChatSession(RemoteChatSession var0) {
        this.chatSession = var0;
    }

    @Nullable
    public RemoteChatSession getChatSession() {
        if (this.chatSession != null && this.chatSession.hasExpired()) {
            return null;
        }
        return this.chatSession;
    }

    @Override
    public void indicateDamage(double var0, double var2) {
        this.hurtDir = (float)(MathHelper.atan2(var2, var0) * 57.2957763671875 - (double)this.getYRot());
        this.connection.send(new ClientboundHurtAnimationPacket(this));
    }

    @Override
    public boolean startRiding(Entity var0, boolean var1) {
        if (super.startRiding(var0, var1)) {
            var0.positionRider(this);
            this.connection.teleport(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            if (var0 instanceof EntityLiving) {
                EntityLiving var2 = (EntityLiving)var0;
                for (MobEffect var4 : var2.getActiveEffects()) {
                    this.connection.send(new PacketPlayOutEntityEffect(var0.getId(), var4));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void stopRiding() {
        Entity var0 = this.getVehicle();
        super.stopRiding();
        if (var0 instanceof EntityLiving) {
            EntityLiving var1 = (EntityLiving)var0;
            for (MobEffect var3 : var1.getActiveEffects()) {
                this.connection.send(new PacketPlayOutRemoveEntityEffect(var0.getId(), var3.getEffect()));
            }
        }
    }

    public CommonPlayerSpawnInfo createCommonSpawnInfo(WorldServer var0) {
        return new CommonPlayerSpawnInfo(var0.dimensionTypeId(), var0.dimension(), BiomeManager.obfuscateSeed(var0.getSeed()), this.gameMode.getGameModeForPlayer(), this.gameMode.getPreviousGameModeForPlayer(), var0.isDebug(), var0.isFlat(), this.getLastDeathLocation(), this.getPortalCooldown());
    }

    private /* synthetic */ Packet d(IChatBaseComponent var0) {
        int var12 = 256;
        String var2 = var0.getString(256);
        IChatMutableComponent var3 = IChatBaseComponent.translatable("death.attack.message_too_long", IChatBaseComponent.literal(var2).withStyle(EnumChatFormat.YELLOW));
        IChatMutableComponent var4 = IChatBaseComponent.translatable("death.attack.even_more_magic", this.getDisplayName()).withStyle(var1 -> var1.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, var3)));
        return new ClientboundPlayerCombatKillPacket(this.getId(), var4);
    }
}

