/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.commands.data.CommandDataAccessor;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;

public class CommandDataAccessorTile
implements CommandDataAccessor {
    static final SimpleCommandExceptionType ERROR_NOT_A_BLOCK_ENTITY = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.data.block.invalid"));
    public static final Function<String, CommandData.c> PROVIDER = var0 -> new CommandData.c((String)var0){
        final /* synthetic */ String a;
        {
            this.a = string;
        }

        @Override
        public CommandDataAccessor access(CommandContext<CommandListenerWrapper> var0) throws CommandSyntaxException {
            BlockPosition var1 = ArgumentPosition.getLoadedBlockPos(var0, this.a + "Pos");
            TileEntity var2 = ((CommandListenerWrapper)var0.getSource()).getLevel().getBlockEntity(var1);
            if (var2 == null) {
                throw ERROR_NOT_A_BLOCK_ENTITY.create();
            }
            return new CommandDataAccessorTile(var2, var1);
        }

        @Override
        public ArgumentBuilder<CommandListenerWrapper, ?> wrap(ArgumentBuilder<CommandListenerWrapper, ?> var0, Function<ArgumentBuilder<CommandListenerWrapper, ?>, ArgumentBuilder<CommandListenerWrapper, ?>> var1) {
            return var0.then(CommandDispatcher.literal("block").then(var1.apply((ArgumentBuilder<CommandListenerWrapper, ?>)CommandDispatcher.argument(this.a + "Pos", ArgumentPosition.blockPos()))));
        }
    };
    private final TileEntity entity;
    private final BlockPosition pos;

    public CommandDataAccessorTile(TileEntity var0, BlockPosition var1) {
        this.entity = var0;
        this.pos = var1;
    }

    @Override
    public void setData(NBTTagCompound var0) {
        IBlockData var1 = this.entity.getLevel().getBlockState(this.pos);
        this.entity.load(var0);
        this.entity.setChanged();
        this.entity.getLevel().sendBlockUpdated(this.pos, var1, var1, 3);
    }

    @Override
    public NBTTagCompound getData() {
        return this.entity.saveWithFullMetadata();
    }

    @Override
    public IChatBaseComponent getModifiedSuccess() {
        return IChatBaseComponent.translatable("commands.data.block.modified", this.pos.getX(), this.pos.getY(), this.pos.getZ());
    }

    @Override
    public IChatBaseComponent getPrintSuccess(NBTBase var0) {
        return IChatBaseComponent.translatable("commands.data.block.query", this.pos.getX(), this.pos.getY(), this.pos.getZ(), GameProfileSerializer.toPrettyComponent(var0));
    }

    @Override
    public IChatBaseComponent getPrintSuccess(ArgumentNBTKey.g var0, double var1, int var3) {
        return IChatBaseComponent.translatable("commands.data.block.get", var0.asString(), this.pos.getX(), this.pos.getY(), this.pos.getZ(), String.format(Locale.ROOT, "%.2f", var1), var3);
    }
}

