/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentUUID;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;

public class DebugConfigCommand {
    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("debugconfig").requires(var0 -> var0.hasPermission(3))).then(net.minecraft.commands.CommandDispatcher.literal("config").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.player()).executes(var0 -> DebugConfigCommand.config((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayer((CommandContext<CommandListenerWrapper>)var0, "target")))))).then(net.minecraft.commands.CommandDispatcher.literal("unconfig").then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentUUID.uuid()).suggests((var0, var1) -> ICompletionProvider.suggest(DebugConfigCommand.getUuidsInConfig(((CommandListenerWrapper)var0.getSource()).getServer()), var1)).executes(var0 -> DebugConfigCommand.unconfig((CommandListenerWrapper)var0.getSource(), ArgumentUUID.getUuid((CommandContext<CommandListenerWrapper>)var0, "target"))))));
    }

    private static Iterable<String> getUuidsInConfig(MinecraftServer var0) {
        HashSet<String> var1 = new HashSet<String>();
        for (NetworkManager var3 : var0.getConnection().getConnections()) {
            PacketListener packetListener = var3.getPacketListener();
            if (!(packetListener instanceof ServerConfigurationPacketListenerImpl)) continue;
            ServerConfigurationPacketListenerImpl var4 = (ServerConfigurationPacketListenerImpl)packetListener;
            var1.add(var4.getOwner().getId().toString());
        }
        return var1;
    }

    private static int config(CommandListenerWrapper var0, EntityPlayer var1) {
        GameProfile var2 = var1.getGameProfile();
        var1.connection.switchToConfig();
        var0.sendSuccess(() -> IChatBaseComponent.literal("Switched player " + var2.getName() + "(" + var2.getId() + ") to config mode"), false);
        return 1;
    }

    private static int unconfig(CommandListenerWrapper var0, UUID var1) {
        for (NetworkManager var3 : var0.getServer().getConnection().getConnections()) {
            ServerConfigurationPacketListenerImpl var4;
            PacketListener packetListener = var3.getPacketListener();
            if (!(packetListener instanceof ServerConfigurationPacketListenerImpl) || !(var4 = (ServerConfigurationPacketListenerImpl)packetListener).getOwner().getId().equals(var1)) continue;
            var4.returnToWorld();
        }
        var0.sendFailure(IChatBaseComponent.literal("Can't find player to unconfig"));
        return 0;
    }
}

