/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.io.PrintStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.arguments.selector.options.PlayerSelector;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.LocaleLanguage;
import net.minecraft.server.DebugOutputStream;
import net.minecraft.server.RedirectStream;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeDefaults;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.BlockFire;
import org.slf4j.Logger;

public class DispenserRegistry {
    public static final PrintStream STDOUT = System.out;
    private static volatile boolean isBootstrapped;
    private static final Logger LOGGER;
    public static final AtomicLong bootstrapDuration;

    public static void bootStrap() {
        if (isBootstrapped) {
            return;
        }
        isBootstrapped = true;
        Instant var0 = Instant.now();
        if (BuiltInRegistries.REGISTRY.keySet().isEmpty()) {
            throw new IllegalStateException("Unable to load registries");
        }
        BlockFire.bootStrap();
        BlockComposter.bootStrap();
        if (EntityTypes.getKey(EntityTypes.PLAYER) == null) {
            throw new IllegalStateException("Failed loading EntityTypes");
        }
        PotionBrewer.bootStrap();
        PlayerSelector.bootStrap();
        IDispenseBehavior.bootStrap();
        CauldronInteraction.bootStrap();
        BuiltInRegistries.bootStrap();
        CreativeModeTabs.validate();
        DispenserRegistry.wrapStreams();
        bootstrapDuration.set(Duration.between(var0, Instant.now()).toMillis());
    }

    private static <T> void checkTranslations(Iterable<T> var0, Function<T, String> var1, Set<String> var2) {
        LocaleLanguage var32 = LocaleLanguage.getInstance();
        var0.forEach(var3 -> {
            String var4 = (String)var1.apply(var3);
            if (!var32.has(var4)) {
                var2.add(var4);
            }
        });
    }

    private static void checkGameruleTranslations(final Set<String> var0) {
        final LocaleLanguage var1 = LocaleLanguage.getInstance();
        GameRules.visitGameRuleTypes(new GameRules.GameRuleVisitor(){

            @Override
            public <T extends GameRules.GameRuleValue<T>> void visit(GameRules.GameRuleKey<T> var02, GameRules.GameRuleDefinition<T> var12) {
                if (!var1.has(var02.getDescriptionId())) {
                    var0.add(var02.getId());
                }
            }
        });
    }

    public static Set<String> getMissingTranslations() {
        TreeSet<String> var02 = new TreeSet<String>();
        DispenserRegistry.checkTranslations(BuiltInRegistries.ATTRIBUTE, AttributeBase::getDescriptionId, var02);
        DispenserRegistry.checkTranslations(BuiltInRegistries.ENTITY_TYPE, EntityTypes::getDescriptionId, var02);
        DispenserRegistry.checkTranslations(BuiltInRegistries.MOB_EFFECT, MobEffectList::getDescriptionId, var02);
        DispenserRegistry.checkTranslations(BuiltInRegistries.ITEM, Item::getDescriptionId, var02);
        DispenserRegistry.checkTranslations(BuiltInRegistries.ENCHANTMENT, Enchantment::getDescriptionId, var02);
        DispenserRegistry.checkTranslations(BuiltInRegistries.BLOCK, Block::getDescriptionId, var02);
        DispenserRegistry.checkTranslations(BuiltInRegistries.CUSTOM_STAT, var0 -> "stat." + var0.toString().replace(':', '.'), var02);
        DispenserRegistry.checkGameruleTranslations(var02);
        return var02;
    }

    public static void checkBootstrapCalled(Supplier<String> var0) {
        if (!isBootstrapped) {
            throw DispenserRegistry.createBootstrapException(var0);
        }
    }

    private static RuntimeException createBootstrapException(Supplier<String> var0) {
        try {
            String var1 = var0.get();
            return new IllegalArgumentException("Not bootstrapped (called from " + var1 + ")");
        }
        catch (Exception var1) {
            IllegalArgumentException var2 = new IllegalArgumentException("Not bootstrapped (failed to resolve location)");
            var2.addSuppressed(var1);
            return var2;
        }
    }

    public static void validate() {
        DispenserRegistry.checkBootstrapCalled(() -> "validate");
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            DispenserRegistry.getMissingTranslations().forEach(var0 -> LOGGER.error("Missing translations: {}", var0));
            CommandDispatcher.validate();
        }
        AttributeDefaults.validate();
    }

    private static void wrapStreams() {
        if (LOGGER.isDebugEnabled()) {
            System.setErr(new DebugOutputStream("STDERR", System.err));
            System.setOut(new DebugOutputStream("STDOUT", STDOUT));
        } else {
            System.setErr(new RedirectStream("STDERR", System.err));
            System.setOut(new RedirectStream("STDOUT", STDOUT));
        }
    }

    public static void realStdoutPrintln(String var0) {
        STDOUT.println(var0);
    }

    static {
        LOGGER = LogUtils.getLogger();
        bootstrapDuration = new AtomicLong(-1L);
    }
}

