/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.List;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class PacketPlayOutTabComplete
implements Packet<PacketListenerPlayOut> {
    private final int id;
    private final Suggestions suggestions;

    public PacketPlayOutTabComplete(int var0, Suggestions var1) {
        this.id = var0;
        this.suggestions = var1;
    }

    public PacketPlayOutTabComplete(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        int var12 = var0.readVarInt();
        int var2 = var0.readVarInt();
        StringRange var3 = StringRange.between((int)var12, (int)(var12 + var2));
        List var4 = var0.readList(var1 -> {
            String var2 = var1.readUtf();
            IChatBaseComponent var3 = (IChatBaseComponent)var1.readNullable(PacketDataSerializer::readComponentTrusted);
            return new Suggestion(var3, var2, (Message)var3);
        });
        this.suggestions = new Suggestions(var3, var4);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.id);
        var0.writeVarInt(this.suggestions.getRange().getStart());
        var0.writeVarInt(this.suggestions.getRange().getLength());
        var0.writeCollection(this.suggestions.getList(), (var02, var12) -> {
            var02.writeUtf(var12.getText());
            var02.writeNullable(var12.getTooltip(), (var0, var1) -> var0.writeComponent(ChatComponentUtils.fromMessage(var1)));
        });
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleCommandSuggestions(this);
    }

    public int getId() {
        return this.id;
    }

    public Suggestions getSuggestions() {
        return this.suggestions;
    }
}

