/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import java.util.function.Function;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.BossBattle;

public class PacketPlayOutBoss
implements Packet<PacketListenerPlayOut> {
    private static final int FLAG_DARKEN = 1;
    private static final int FLAG_MUSIC = 2;
    private static final int FLAG_FOG = 4;
    private final UUID id;
    private final Action operation;
    static final Action REMOVE_OPERATION = new Action(){

        @Override
        public d getType() {
            return d.REMOVE;
        }

        @Override
        public void dispatch(UUID var0, b var1) {
            var1.remove(var0);
        }

        @Override
        public void write(PacketDataSerializer var0) {
        }
    };

    private PacketPlayOutBoss(UUID var0, Action var1) {
        this.id = var0;
        this.operation = var1;
    }

    public PacketPlayOutBoss(PacketDataSerializer var0) {
        this.id = var0.readUUID();
        d var1 = var0.readEnum(d.class);
        this.operation = var1.reader.apply(var0);
    }

    public static PacketPlayOutBoss createAddPacket(BossBattle var0) {
        return new PacketPlayOutBoss(var0.getId(), new a(var0));
    }

    public static PacketPlayOutBoss createRemovePacket(UUID var0) {
        return new PacketPlayOutBoss(var0, REMOVE_OPERATION);
    }

    public static PacketPlayOutBoss createUpdateProgressPacket(BossBattle var0) {
        return new PacketPlayOutBoss(var0.getId(), new f(var0.getProgress()));
    }

    public static PacketPlayOutBoss createUpdateNamePacket(BossBattle var0) {
        return new PacketPlayOutBoss(var0.getId(), new e(var0.getName()));
    }

    public static PacketPlayOutBoss createUpdateStylePacket(BossBattle var0) {
        return new PacketPlayOutBoss(var0.getId(), new h(var0.getColor(), var0.getOverlay()));
    }

    public static PacketPlayOutBoss createUpdatePropertiesPacket(BossBattle var0) {
        return new PacketPlayOutBoss(var0.getId(), new g(var0.shouldDarkenScreen(), var0.shouldPlayBossMusic(), var0.shouldCreateWorldFog()));
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeUUID(this.id);
        var0.writeEnum(this.operation.getType());
        this.operation.write(var0);
    }

    static int encodeProperties(boolean var0, boolean var1, boolean var2) {
        int var3 = 0;
        if (var0) {
            var3 |= 1;
        }
        if (var1) {
            var3 |= 2;
        }
        if (var2) {
            var3 |= 4;
        }
        return var3;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleBossUpdate(this);
    }

    public void dispatch(b var0) {
        this.operation.dispatch(this.id, var0);
    }

    static interface Action {
        public d getType();

        public void dispatch(UUID var1, b var2);

        public void write(PacketDataSerializer var1);
    }

    static final class d
    extends Enum<d> {
        public static final /* enum */ d ADD = new d(a::new);
        public static final /* enum */ d REMOVE = new d(var0 -> REMOVE_OPERATION);
        public static final /* enum */ d UPDATE_PROGRESS = new d(f::new);
        public static final /* enum */ d UPDATE_NAME = new d(e::new);
        public static final /* enum */ d UPDATE_STYLE = new d(h::new);
        public static final /* enum */ d UPDATE_PROPERTIES = new d(g::new);
        final Function<PacketDataSerializer, Action> reader;
        private static final /* synthetic */ d[] h;

        public static d[] values() {
            return (d[])h.clone();
        }

        public static d valueOf(String var0) {
            return Enum.valueOf(d.class, var0);
        }

        private d(Function var2) {
            this.reader = var2;
        }

        private static /* synthetic */ d[] a() {
            return new d[]{ADD, REMOVE, UPDATE_PROGRESS, UPDATE_NAME, UPDATE_STYLE, UPDATE_PROPERTIES};
        }

        static {
            h = d.a();
        }
    }

    static class a
    implements Action {
        private final IChatBaseComponent name;
        private final float progress;
        private final BossBattle.BarColor color;
        private final BossBattle.BarStyle overlay;
        private final boolean darkenScreen;
        private final boolean playMusic;
        private final boolean createWorldFog;

        a(BossBattle var0) {
            this.name = var0.getName();
            this.progress = var0.getProgress();
            this.color = var0.getColor();
            this.overlay = var0.getOverlay();
            this.darkenScreen = var0.shouldDarkenScreen();
            this.playMusic = var0.shouldPlayBossMusic();
            this.createWorldFog = var0.shouldCreateWorldFog();
        }

        private a(PacketDataSerializer var0) {
            this.name = var0.readComponentTrusted();
            this.progress = var0.readFloat();
            this.color = var0.readEnum(BossBattle.BarColor.class);
            this.overlay = var0.readEnum(BossBattle.BarStyle.class);
            short var1 = var0.readUnsignedByte();
            this.darkenScreen = (var1 & 1) > 0;
            this.playMusic = (var1 & 2) > 0;
            this.createWorldFog = (var1 & 4) > 0;
        }

        @Override
        public d getType() {
            return d.ADD;
        }

        @Override
        public void dispatch(UUID var0, b var1) {
            var1.add(var0, this.name, this.progress, this.color, this.overlay, this.darkenScreen, this.playMusic, this.createWorldFog);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeComponent(this.name);
            var0.writeFloat(this.progress);
            var0.writeEnum(this.color);
            var0.writeEnum(this.overlay);
            var0.writeByte(PacketPlayOutBoss.encodeProperties(this.darkenScreen, this.playMusic, this.createWorldFog));
        }
    }

    static class f
    implements Action {
        private final float progress;

        f(float var0) {
            this.progress = var0;
        }

        private f(PacketDataSerializer var0) {
            this.progress = var0.readFloat();
        }

        @Override
        public d getType() {
            return d.UPDATE_PROGRESS;
        }

        @Override
        public void dispatch(UUID var0, b var1) {
            var1.updateProgress(var0, this.progress);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeFloat(this.progress);
        }
    }

    static class e
    implements Action {
        private final IChatBaseComponent name;

        e(IChatBaseComponent var0) {
            this.name = var0;
        }

        private e(PacketDataSerializer var0) {
            this.name = var0.readComponentTrusted();
        }

        @Override
        public d getType() {
            return d.UPDATE_NAME;
        }

        @Override
        public void dispatch(UUID var0, b var1) {
            var1.updateName(var0, this.name);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeComponent(this.name);
        }
    }

    static class h
    implements Action {
        private final BossBattle.BarColor color;
        private final BossBattle.BarStyle overlay;

        h(BossBattle.BarColor var0, BossBattle.BarStyle var1) {
            this.color = var0;
            this.overlay = var1;
        }

        private h(PacketDataSerializer var0) {
            this.color = var0.readEnum(BossBattle.BarColor.class);
            this.overlay = var0.readEnum(BossBattle.BarStyle.class);
        }

        @Override
        public d getType() {
            return d.UPDATE_STYLE;
        }

        @Override
        public void dispatch(UUID var0, b var1) {
            var1.updateStyle(var0, this.color, this.overlay);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeEnum(this.color);
            var0.writeEnum(this.overlay);
        }
    }

    static class g
    implements Action {
        private final boolean darkenScreen;
        private final boolean playMusic;
        private final boolean createWorldFog;

        g(boolean var0, boolean var1, boolean var2) {
            this.darkenScreen = var0;
            this.playMusic = var1;
            this.createWorldFog = var2;
        }

        private g(PacketDataSerializer var0) {
            short var1 = var0.readUnsignedByte();
            this.darkenScreen = (var1 & 1) > 0;
            this.playMusic = (var1 & 2) > 0;
            this.createWorldFog = (var1 & 4) > 0;
        }

        @Override
        public d getType() {
            return d.UPDATE_PROPERTIES;
        }

        @Override
        public void dispatch(UUID var0, b var1) {
            var1.updateProperties(var0, this.darkenScreen, this.playMusic, this.createWorldFog);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeByte(PacketPlayOutBoss.encodeProperties(this.darkenScreen, this.playMusic, this.createWorldFog));
        }
    }

    public static interface b {
        default public void add(UUID var0, IChatBaseComponent var1, float var2, BossBattle.BarColor var3, BossBattle.BarStyle var4, boolean var5, boolean var6, boolean var7) {
        }

        default public void remove(UUID var0) {
        }

        default public void updateProgress(UUID var0, float var1) {
        }

        default public void updateName(UUID var0, IChatBaseComponent var1) {
        }

        default public void updateStyle(UUID var0, BossBattle.BarColor var1, BossBattle.BarStyle var2) {
        }

        default public void updateProperties(UUID var0, boolean var1, boolean var2, boolean var3) {
        }
    }
}

