/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;

public class PacketPlayInSteerVehicle
implements Packet<PacketListenerPlayIn> {
    private static final int FLAG_JUMPING = 1;
    private static final int FLAG_SHIFT_KEY_DOWN = 2;
    private final float xxa;
    private final float zza;
    private final boolean isJumping;
    private final boolean isShiftKeyDown;

    public PacketPlayInSteerVehicle(float var0, float var1, boolean var2, boolean var3) {
        this.xxa = var0;
        this.zza = var1;
        this.isJumping = var2;
        this.isShiftKeyDown = var3;
    }

    public PacketPlayInSteerVehicle(PacketDataSerializer var0) {
        this.xxa = var0.readFloat();
        this.zza = var0.readFloat();
        byte var1 = var0.readByte();
        this.isJumping = (var1 & 1) > 0;
        this.isShiftKeyDown = (var1 & 2) > 0;
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeFloat(this.xxa);
        var0.writeFloat(this.zza);
        byte var1 = 0;
        if (this.isJumping) {
            var1 = (byte)(var1 | 1);
        }
        if (this.isShiftKeyDown) {
            var1 = (byte)(var1 | 2);
        }
        var0.writeByte(var1);
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handlePlayerInput(this);
    }

    public float getXxa() {
        return this.xxa;
    }

    public float getZza() {
        return this.zza;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public boolean isShiftKeyDown() {
        return this.isShiftKeyDown;
    }
}

