/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.GameTestAddMarkerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestClearMarkersDebugPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.UtilColor;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.memory.ExpirableMemory;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class PacketDebug {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void sendGameTestAddMarker(WorldServer var0, BlockPosition var1, String var2, int var3, int var4) {
        PacketDebug.sendPacketToAllPlayers(var0, new GameTestAddMarkerDebugPayload(var1, var3, var2, var4));
    }

    public static void sendGameTestClearPacket(WorldServer var0) {
        PacketDebug.sendPacketToAllPlayers(var0, new GameTestClearMarkersDebugPayload());
    }

    public static void sendPoiPacketsForChunk(WorldServer var0, ChunkCoordIntPair var1) {
    }

    public static void sendPoiAddedPacket(WorldServer var0, BlockPosition var1) {
        PacketDebug.sendVillageSectionsPacket(var0, var1);
    }

    public static void sendPoiRemovedPacket(WorldServer var0, BlockPosition var1) {
        PacketDebug.sendVillageSectionsPacket(var0, var1);
    }

    public static void sendPoiTicketCountPacket(WorldServer var0, BlockPosition var1) {
        PacketDebug.sendVillageSectionsPacket(var0, var1);
    }

    private static void sendVillageSectionsPacket(WorldServer var0, BlockPosition var1) {
    }

    public static void sendPathFindingPacket(World var0, EntityInsentient var1, @Nullable PathEntity var2, float var3) {
    }

    public static void sendNeighborsUpdatePacket(World var0, BlockPosition var1) {
    }

    public static void sendStructurePacket(GeneratorAccessSeed var0, StructureStart var1) {
    }

    public static void sendGoalSelector(World var0, EntityInsentient var1, PathfinderGoalSelector var2) {
    }

    public static void sendRaids(WorldServer var0, Collection<Raid> var1) {
    }

    public static void sendEntityBrain(EntityLiving var0) {
    }

    public static void sendBeeInfo(EntityBee var0) {
    }

    public static void sendBreezeInfo(Breeze var0) {
    }

    public static void sendGameEventInfo(World var0, GameEvent var1, Vec3D var2) {
    }

    public static void sendGameEventListenerInfo(World var0, GameEventListener var1) {
    }

    public static void sendHiveInfo(World var0, BlockPosition var1, IBlockData var2, TileEntityBeehive var3) {
    }

    private static List<String> getMemoryDescriptions(EntityLiving var0, long var1) {
        Map<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> var3 = var0.getBrain().getMemories();
        ArrayList var4 = Lists.newArrayList();
        for (Map.Entry<MemoryModuleType<?>, Optional<ExpirableMemory<?>>> var6 : var3.entrySet()) {
            Object var9;
            MemoryModuleType<?> var7 = var6.getKey();
            Optional<ExpirableMemory<?>> var8 = var6.getValue();
            if (var8.isPresent()) {
                ExpirableMemory<?> var10 = var8.get();
                Object var11 = var10.getValue();
                if (var7 == MemoryModuleType.HEARD_BELL_TIME) {
                    long var12 = var1 - (Long)var11;
                    var9 = var12 + " ticks ago";
                } else {
                    var9 = var10.canExpire() ? PacketDebug.getShortDescription((WorldServer)var0.level(), var11) + " (ttl: " + var10.getTimeToLive() + ")" : PacketDebug.getShortDescription((WorldServer)var0.level(), var11);
                }
            } else {
                var9 = "-";
            }
            var4.add(BuiltInRegistries.MEMORY_MODULE_TYPE.getKey(var7).getPath() + ": " + (String)var9);
        }
        var4.sort(String::compareTo);
        return var4;
    }

    private static String getShortDescription(WorldServer var0, @Nullable Object var1) {
        if (var1 == null) {
            return "-";
        }
        if (var1 instanceof UUID) {
            return PacketDebug.getShortDescription(var0, var0.getEntity((UUID)var1));
        }
        if (var1 instanceof EntityLiving) {
            Entity var2 = (Entity)var1;
            return DebugEntityNameGenerator.getEntityName(var2);
        }
        if (var1 instanceof INamableTileEntity) {
            return ((INamableTileEntity)var1).getName().getString();
        }
        if (var1 instanceof MemoryTarget) {
            return PacketDebug.getShortDescription(var0, ((MemoryTarget)var1).getTarget());
        }
        if (var1 instanceof BehaviorPositionEntity) {
            return PacketDebug.getShortDescription(var0, ((BehaviorPositionEntity)var1).getEntity());
        }
        if (var1 instanceof GlobalPos) {
            return PacketDebug.getShortDescription(var0, ((GlobalPos)var1).pos());
        }
        if (var1 instanceof BehaviorTarget) {
            return PacketDebug.getShortDescription(var0, ((BehaviorTarget)var1).currentBlockPosition());
        }
        if (var1 instanceof DamageSource) {
            Entity var2 = ((DamageSource)var1).getEntity();
            return var2 == null ? var1.toString() : PacketDebug.getShortDescription(var0, var2);
        }
        if (var1 instanceof Collection) {
            ArrayList var2 = Lists.newArrayList();
            for (Object var4 : (Iterable)var1) {
                var2.add(PacketDebug.getShortDescription(var0, var4));
            }
            return ((Object)var2).toString();
        }
        return var1.toString();
    }

    private static void sendPacketToAllPlayers(WorldServer var0, CustomPacketPayload var1) {
        ClientboundCustomPayloadPacket var2 = new ClientboundCustomPayloadPacket(var1);
        for (EntityPlayer var4 : var0.players()) {
            var4.connection.send(var2);
        }
    }

    private static /* synthetic */ void a(List var0, UUID var1, Object2IntMap var22) {
        String var32 = DebugEntityNameGenerator.getEntityName(var1);
        var22.forEach((var2, var3) -> var0.add(var32 + ": " + var2 + ": " + var3));
    }

    private static /* synthetic */ String a(String var0) {
        return UtilColor.truncateStringIfNecessary(var0, 255, true);
    }

    private static /* synthetic */ void a(List var0, PathfinderGoalWrapped var1) {
        var0.add(new GoalDebugPayload.a(var1.getPriority(), var1.isRunning(), var1.getGoal().getClass().getSimpleName()));
    }

    private static /* synthetic */ String a(ResourceKey var0) {
        return var0.location().toString();
    }

    private static /* synthetic */ void a(WorldServer var0, VillagePlaceRecord var1) {
        PacketDebug.sendPoiAddedPacket(var0, var1.getPos());
    }

    private static /* synthetic */ boolean a(Holder var0) {
        return true;
    }
}

