/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Lists;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ClientboundLightUpdatePacketData {
    private final BitSet skyYMask;
    private final BitSet blockYMask;
    private final BitSet emptySkyYMask;
    private final BitSet emptyBlockYMask;
    private final List<byte[]> skyUpdates;
    private final List<byte[]> blockUpdates;

    public ClientboundLightUpdatePacketData(ChunkCoordIntPair var0, LevelLightEngine var1, @Nullable BitSet var2, @Nullable BitSet var3) {
        this.skyYMask = new BitSet();
        this.blockYMask = new BitSet();
        this.emptySkyYMask = new BitSet();
        this.emptyBlockYMask = new BitSet();
        this.skyUpdates = Lists.newArrayList();
        this.blockUpdates = Lists.newArrayList();
        for (int var4 = 0; var4 < var1.getLightSectionCount(); ++var4) {
            if (var2 == null || var2.get(var4)) {
                this.prepareSectionData(var0, var1, EnumSkyBlock.SKY, var4, this.skyYMask, this.emptySkyYMask, this.skyUpdates);
            }
            if (var3 != null && !var3.get(var4)) continue;
            this.prepareSectionData(var0, var1, EnumSkyBlock.BLOCK, var4, this.blockYMask, this.emptyBlockYMask, this.blockUpdates);
        }
    }

    public ClientboundLightUpdatePacketData(PacketDataSerializer var02, int var1, int var2) {
        this.skyYMask = var02.readBitSet();
        this.blockYMask = var02.readBitSet();
        this.emptySkyYMask = var02.readBitSet();
        this.emptyBlockYMask = var02.readBitSet();
        this.skyUpdates = var02.readList(var0 -> var0.readByteArray(2048));
        this.blockUpdates = var02.readList(var0 -> var0.readByteArray(2048));
    }

    public void write(PacketDataSerializer var0) {
        var0.writeBitSet(this.skyYMask);
        var0.writeBitSet(this.blockYMask);
        var0.writeBitSet(this.emptySkyYMask);
        var0.writeBitSet(this.emptyBlockYMask);
        var0.writeCollection(this.skyUpdates, PacketDataSerializer::writeByteArray);
        var0.writeCollection(this.blockUpdates, PacketDataSerializer::writeByteArray);
    }

    private void prepareSectionData(ChunkCoordIntPair var0, LevelLightEngine var1, EnumSkyBlock var2, int var3, BitSet var4, BitSet var5, List<byte[]> var6) {
        NibbleArray var7 = var1.getLayerListener(var2).getDataLayerData(SectionPosition.of(var0, var1.getMinLightSection() + var3));
        if (var7 != null) {
            if (var7.isEmpty()) {
                var5.set(var3);
            } else {
                var4.set(var3);
                var6.add(var7.copy().getData());
            }
        }
    }

    public BitSet getSkyYMask() {
        return this.skyYMask;
    }

    public BitSet getEmptySkyYMask() {
        return this.emptySkyYMask;
    }

    public List<byte[]> getSkyUpdates() {
        return this.skyUpdates;
    }

    public BitSet getBlockYMask() {
        return this.blockYMask;
    }

    public BitSet getEmptyBlockYMask() {
        return this.emptyBlockYMask;
    }

    public List<byte[]> getBlockUpdates() {
        return this.blockUpdates;
    }
}

