/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerCommonPacketListener;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.resources.MinecraftKey;

public record ServerboundCustomPayloadPacket(CustomPacketPayload payload) implements Packet<ServerCommonPacketListener>
{
    private static final int MAX_PAYLOAD_SIZE = Short.MAX_VALUE;
    private static final Map<MinecraftKey, PacketDataSerializer.a<? extends CustomPacketPayload>> KNOWN_TYPES = ImmutableMap.builder().put((Object)BrandPayload.ID, BrandPayload::new).build();

    public ServerboundCustomPayloadPacket(PacketDataSerializer var0) {
        this(ServerboundCustomPayloadPacket.readPayload(var0.readResourceLocation(), var0));
    }

    private static CustomPacketPayload readPayload(MinecraftKey var0, PacketDataSerializer var1) {
        PacketDataSerializer.a<? extends CustomPacketPayload> var2 = KNOWN_TYPES.get(var0);
        if (var2 != null) {
            return (CustomPacketPayload)var2.apply((CustomPacketPayload)((Object)var1));
        }
        return ServerboundCustomPayloadPacket.readUnknownPayload(var0, var1);
    }

    private static DiscardedPayload readUnknownPayload(MinecraftKey var0, PacketDataSerializer var1) {
        int var2 = var1.readableBytes();
        if (var2 < 0 || var2 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Payload may not be larger than 32767 bytes");
        }
        var1.skipBytes(var2);
        return new DiscardedPayload(var0);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeResourceLocation(this.payload.id());
        this.payload.write(var0);
    }

    @Override
    public void handle(ServerCommonPacketListener var0) {
        var0.handleCustomPayload(this);
    }
}

