/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.custom.BeeDebugPayload;
import net.minecraft.network.protocol.common.custom.BrainDebugPayload;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.BreezeDebugPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.common.custom.GameEventDebugPayload;
import net.minecraft.network.protocol.common.custom.GameEventListenerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestAddMarkerDebugPayload;
import net.minecraft.network.protocol.common.custom.GameTestClearMarkersDebugPayload;
import net.minecraft.network.protocol.common.custom.GoalDebugPayload;
import net.minecraft.network.protocol.common.custom.HiveDebugPayload;
import net.minecraft.network.protocol.common.custom.NeighborUpdatesDebugPayload;
import net.minecraft.network.protocol.common.custom.PathfindingDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiAddedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiRemovedDebugPayload;
import net.minecraft.network.protocol.common.custom.PoiTicketCountDebugPayload;
import net.minecraft.network.protocol.common.custom.RaidsDebugPayload;
import net.minecraft.network.protocol.common.custom.StructuresDebugPayload;
import net.minecraft.network.protocol.common.custom.VillageSectionsDebugPayload;
import net.minecraft.network.protocol.common.custom.WorldGenAttemptDebugPayload;
import net.minecraft.resources.MinecraftKey;

public record ClientboundCustomPayloadPacket(CustomPacketPayload payload) implements Packet<ClientCommonPacketListener>
{
    private static final int MAX_PAYLOAD_SIZE = 0x100000;
    private static final Map<MinecraftKey, PacketDataSerializer.a<? extends CustomPacketPayload>> KNOWN_TYPES = ImmutableMap.builder().put((Object)BrandPayload.ID, BrandPayload::new).put((Object)BeeDebugPayload.ID, BeeDebugPayload::new).put((Object)BrainDebugPayload.ID, BrainDebugPayload::new).put((Object)BreezeDebugPayload.ID, BreezeDebugPayload::new).put((Object)GameEventDebugPayload.ID, GameEventDebugPayload::new).put((Object)GameEventListenerDebugPayload.ID, GameEventListenerDebugPayload::new).put((Object)GameTestAddMarkerDebugPayload.ID, GameTestAddMarkerDebugPayload::new).put((Object)GameTestClearMarkersDebugPayload.ID, GameTestClearMarkersDebugPayload::new).put((Object)GoalDebugPayload.ID, GoalDebugPayload::new).put((Object)HiveDebugPayload.ID, HiveDebugPayload::new).put((Object)NeighborUpdatesDebugPayload.ID, NeighborUpdatesDebugPayload::new).put((Object)PathfindingDebugPayload.ID, PathfindingDebugPayload::new).put((Object)PoiAddedDebugPayload.ID, PoiAddedDebugPayload::new).put((Object)PoiRemovedDebugPayload.ID, PoiRemovedDebugPayload::new).put((Object)PoiTicketCountDebugPayload.ID, PoiTicketCountDebugPayload::new).put((Object)RaidsDebugPayload.ID, RaidsDebugPayload::new).put((Object)StructuresDebugPayload.ID, StructuresDebugPayload::new).put((Object)VillageSectionsDebugPayload.ID, VillageSectionsDebugPayload::new).put((Object)WorldGenAttemptDebugPayload.ID, WorldGenAttemptDebugPayload::new).build();

    public ClientboundCustomPayloadPacket(PacketDataSerializer var0) {
        this(ClientboundCustomPayloadPacket.readPayload(var0.readResourceLocation(), var0));
    }

    private static CustomPacketPayload readPayload(MinecraftKey var0, PacketDataSerializer var1) {
        PacketDataSerializer.a<? extends CustomPacketPayload> var2 = KNOWN_TYPES.get(var0);
        if (var2 != null) {
            return (CustomPacketPayload)var2.apply((CustomPacketPayload)((Object)var1));
        }
        return ClientboundCustomPayloadPacket.readUnknownPayload(var0, var1);
    }

    private static DiscardedPayload readUnknownPayload(MinecraftKey var0, PacketDataSerializer var1) {
        int var2 = var1.readableBytes();
        if (var2 < 0 || var2 > 0x100000) {
            throw new IllegalArgumentException("Payload may not be larger than 1048576 bytes");
        }
        var1.skipBytes(var2);
        return new DiscardedPayload(var0);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeResourceLocation(this.payload.id());
        this.payload.write(var0);
    }

    @Override
    public void handle(ClientCommonPacketListener var0) {
        var0.handleCustomPayload(this);
    }
}

