/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.numbers;

import com.mojang.serialization.MapCodec;
import net.minecraft.EnumChatFormat;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatType;

public class StyledFormat
implements NumberFormat {
    public static final NumberFormatType<StyledFormat> TYPE = new NumberFormatType<StyledFormat>(){
        private static final MapCodec<StyledFormat> CODEC = ChatModifier.ChatModifierSerializer.MAP_CODEC.xmap(StyledFormat::new, var0 -> var0.style);

        @Override
        public MapCodec<StyledFormat> mapCodec() {
            return CODEC;
        }

        @Override
        public void writeToStream(PacketDataSerializer var0, StyledFormat var1) {
            var0.writeWithCodec(DynamicOpsNBT.INSTANCE, ChatModifier.ChatModifierSerializer.CODEC, var1.style);
        }

        @Override
        public StyledFormat readFromStream(PacketDataSerializer var0) {
            ChatModifier var1 = var0.readWithCodecTrusted(DynamicOpsNBT.INSTANCE, ChatModifier.ChatModifierSerializer.CODEC);
            return new StyledFormat(var1);
        }

        @Override
        public /* synthetic */ NumberFormat readFromStream(PacketDataSerializer packetDataSerializer) {
            return this.readFromStream(packetDataSerializer);
        }
    };
    public static final StyledFormat NO_STYLE = new StyledFormat(ChatModifier.EMPTY);
    public static final StyledFormat SIDEBAR_DEFAULT = new StyledFormat(ChatModifier.EMPTY.withColor(EnumChatFormat.RED));
    public static final StyledFormat PLAYER_LIST_DEFAULT = new StyledFormat(ChatModifier.EMPTY.withColor(EnumChatFormat.YELLOW));
    final ChatModifier style;

    public StyledFormat(ChatModifier var0) {
        this.style = var0;
    }

    @Override
    public IChatMutableComponent format(int var0) {
        return IChatBaseComponent.literal(Integer.toString(var0)).withStyle(this.style);
    }

    public NumberFormatType<StyledFormat> type() {
        return TYPE;
    }
}

