/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.numbers.StyledFormat;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.ScoreboardObjective;

public class ScoreContents
implements ComponentContents {
    public static final MapCodec<ScoreContents> INNER_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.STRING.fieldOf("name").forGetter(ScoreContents::getName), (App)Codec.STRING.fieldOf("objective").forGetter(ScoreContents::getObjective)).apply((Applicative)var0, ScoreContents::new));
    public static final MapCodec<ScoreContents> CODEC = INNER_CODEC.fieldOf("score");
    public static final ComponentContents.a<ScoreContents> TYPE = new ComponentContents.a<ScoreContents>(CODEC, "score");
    private final String name;
    @Nullable
    private final EntitySelector selector;
    private final String objective;

    @Nullable
    private static EntitySelector parseSelector(String var0) {
        try {
            return new ArgumentParserSelector(new StringReader(var0)).parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    public ScoreContents(String var0, String var1) {
        this.name = var0;
        this.selector = ScoreContents.parseSelector(var0);
        this.objective = var1;
    }

    @Override
    public ComponentContents.a<?> type() {
        return TYPE;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public EntitySelector getSelector() {
        return this.selector;
    }

    public String getObjective() {
        return this.objective;
    }

    private ScoreHolder findTargetName(CommandListenerWrapper var0) throws CommandSyntaxException {
        List<? extends Entity> var1;
        if (this.selector != null && !(var1 = this.selector.findEntities(var0)).isEmpty()) {
            if (var1.size() != 1) {
                throw ArgumentEntity.ERROR_NOT_SINGLE_ENTITY.create();
            }
            return var1.get(0);
        }
        return ScoreHolder.forNameOnly(this.name);
    }

    private IChatMutableComponent getScore(ScoreHolder var0, CommandListenerWrapper var1) {
        ReadOnlyScoreInfo var5;
        ScoreboardServer var3;
        ScoreboardObjective var4;
        MinecraftServer var2 = var1.getServer();
        if (var2 != null && (var4 = (var3 = var2.getScoreboard()).getObjective(this.objective)) != null && (var5 = var3.getPlayerScoreInfo(var0, var4)) != null) {
            return var5.formatValue(var4.numberFormatOrDefault(StyledFormat.NO_STYLE));
        }
        return IChatBaseComponent.empty();
    }

    @Override
    public IChatMutableComponent resolve(@Nullable CommandListenerWrapper var0, @Nullable Entity var1, int var2) throws CommandSyntaxException {
        if (var0 == null) {
            return IChatBaseComponent.empty();
        }
        ScoreHolder var3 = this.findTargetName(var0);
        ScoreHolder var4 = var1 != null && var3.equals(ScoreHolder.WILDCARD) ? var1 : var3;
        return this.getScore(var4, var0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof ScoreContents)) return false;
        ScoreContents var1 = (ScoreContents)var0;
        if (!this.name.equals(var1.name)) return false;
        if (!this.objective.equals(var1.objective)) return false;
        return true;
    }

    public int hashCode() {
        int var0 = this.name.hashCode();
        var0 = 31 * var0 + this.objective.hashCode();
        return var0;
    }

    public String toString() {
        return "score{name='" + this.name + "', objective='" + this.objective + "'}";
    }
}

