/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.logging.LogUtils;
import java.time.Instant;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageLink;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.Signer;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.slf4j.Logger;

public class SignedMessageChain {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private SignedMessageLink nextLink;
    private Instant lastTimeStamp = Instant.EPOCH;

    public SignedMessageChain(UUID var0, UUID var1) {
        this.nextLink = SignedMessageLink.root(var0, var1);
    }

    public c encoder(Signer var0) {
        return var1 -> {
            SignedMessageLink var22 = this.advanceLink();
            if (var22 == null) {
                return null;
            }
            return new MessageSignature(var0.sign(var2 -> PlayerChatMessage.updateSignature(var2, var22, var1)));
        };
    }

    public b decoder(ProfilePublicKey var0) {
        SignatureValidator var1 = var0.createSignatureValidator();
        return (var2, var3) -> {
            SignedMessageLink var4 = this.advanceLink();
            if (var4 == null) {
                throw new a((IChatBaseComponent)IChatBaseComponent.translatable("chat.disabled.chain_broken"), false);
            }
            if (var0.data().hasExpired()) {
                throw new a((IChatBaseComponent)IChatBaseComponent.translatable("chat.disabled.expiredProfileKey"), false);
            }
            if (var3.timeStamp().isBefore(this.lastTimeStamp)) {
                throw new a((IChatBaseComponent)IChatBaseComponent.translatable("multiplayer.disconnect.out_of_order_chat"), true);
            }
            this.lastTimeStamp = var3.timeStamp();
            PlayerChatMessage var5 = new PlayerChatMessage(var4, var2, var3, null, FilterMask.PASS_THROUGH);
            if (!var5.verify(var1)) {
                throw new a((IChatBaseComponent)IChatBaseComponent.translatable("multiplayer.disconnect.unsigned_chat"), true);
            }
            if (var5.hasExpiredServer(Instant.now())) {
                LOGGER.warn("Received expired chat: '{}'. Is the client/server system time unsynchronized?", (Object)var3.content());
            }
            return var5;
        };
    }

    @Nullable
    private SignedMessageLink advanceLink() {
        SignedMessageLink var0 = this.nextLink;
        if (var0 != null) {
            this.nextLink = var0.advance();
        }
        return var0;
    }

    @FunctionalInterface
    public static interface c {
        public static final c UNSIGNED = var0 -> null;

        @Nullable
        public MessageSignature pack(SignedMessageBody var1);
    }

    @FunctionalInterface
    public static interface b {
        public static b unsigned(UUID var0, BooleanSupplier var1) {
            return (var2, var3) -> {
                if (var1.getAsBoolean()) {
                    throw new a((IChatBaseComponent)IChatBaseComponent.translatable("chat.disabled.missingProfileKey"), false);
                }
                return PlayerChatMessage.unsigned(var0, var3.content());
            };
        }

        public PlayerChatMessage unpack(@Nullable MessageSignature var1, SignedMessageBody var2) throws a;
    }

    public static class a
    extends ThrowingComponent {
        private final boolean shouldDisconnect;

        public a(IChatBaseComponent var0, boolean var1) {
            super(var0);
            this.shouldDisconnect = var1;
        }

        public boolean shouldDisconnect() {
            return this.shouldDisconnect;
        }
    }
}

