/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;

public class ChatClickable {
    public static final Codec<ChatClickable> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)EnumClickAction.CODEC.forGetter(var0 -> var0.action), (App)Codec.STRING.fieldOf("value").forGetter(var0 -> var0.value)).apply((Applicative)var02, ChatClickable::new));
    private final EnumClickAction action;
    private final String value;

    public ChatClickable(EnumClickAction var0, String var1) {
        this.action = var0;
        this.value = var1;
    }

    public EnumClickAction getAction() {
        return this.action;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        ChatClickable var1 = (ChatClickable)var0;
        return this.action == var1.action && this.value.equals(var1.value);
    }

    public String toString() {
        return "ClickEvent{action=" + this.action + ", value='" + this.value + "'}";
    }

    public int hashCode() {
        int var0 = this.action.hashCode();
        var0 = 31 * var0 + this.value.hashCode();
        return var0;
    }

    public static final class EnumClickAction
    extends Enum<EnumClickAction>
    implements INamable {
        public static final /* enum */ EnumClickAction OPEN_URL = new EnumClickAction("open_url", true);
        public static final /* enum */ EnumClickAction OPEN_FILE = new EnumClickAction("open_file", false);
        public static final /* enum */ EnumClickAction RUN_COMMAND = new EnumClickAction("run_command", true);
        public static final /* enum */ EnumClickAction SUGGEST_COMMAND = new EnumClickAction("suggest_command", true);
        public static final /* enum */ EnumClickAction CHANGE_PAGE = new EnumClickAction("change_page", true);
        public static final /* enum */ EnumClickAction COPY_TO_CLIPBOARD = new EnumClickAction("copy_to_clipboard", true);
        public static final MapCodec<EnumClickAction> UNSAFE_CODEC;
        public static final MapCodec<EnumClickAction> CODEC;
        private final boolean allowFromServer;
        private final String name;
        private static final /* synthetic */ EnumClickAction[] k;

        public static EnumClickAction[] values() {
            return (EnumClickAction[])k.clone();
        }

        public static EnumClickAction valueOf(String var0) {
            return Enum.valueOf(EnumClickAction.class, var0);
        }

        private EnumClickAction(String var2, boolean var3) {
            this.name = var2;
            this.allowFromServer = var3;
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static DataResult<EnumClickAction> filterForSerialization(EnumClickAction var0) {
            if (!var0.isAllowedFromServer()) {
                return DataResult.error(() -> "Action not allowed: " + var0);
            }
            return DataResult.success((Object)var0, (Lifecycle)Lifecycle.stable());
        }

        private static /* synthetic */ EnumClickAction[] b() {
            return new EnumClickAction[]{OPEN_URL, OPEN_FILE, RUN_COMMAND, SUGGEST_COMMAND, CHANGE_PAGE, COPY_TO_CLIPBOARD};
        }

        static {
            k = EnumClickAction.b();
            UNSAFE_CODEC = INamable.fromEnum(EnumClickAction::values).fieldOf("action");
            CODEC = ExtraCodecs.validate(UNSAFE_CODEC, EnumClickAction::filterForSerialization);
        }
    }
}

