/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import java.util.List;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.protocol.Packet;
import org.slf4j.Logger;

public class PacketFlowValidator
extends MessageToMessageCodec<Packet<?>, Packet<?>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AttributeKey<EnumProtocol.a<?>> decoderKey;
    private final AttributeKey<EnumProtocol.a<?>> encoderKey;

    public PacketFlowValidator(AttributeKey<EnumProtocol.a<?>> var0, AttributeKey<EnumProtocol.a<?>> var1) {
        this.decoderKey = var0;
        this.encoderKey = var1;
    }

    private static void validatePacket(ChannelHandlerContext var0, Packet<?> var1, List<Object> var2, AttributeKey<EnumProtocol.a<?>> var3) {
        Attribute var4 = var0.channel().attr(var3);
        EnumProtocol.a var5 = (EnumProtocol.a)var4.get();
        if (!var5.isValidPacketType(var1)) {
            LOGGER.error("Unrecognized packet in pipeline {}:{} - {}", new Object[]{var5.protocol().id(), var5.flow(), var1});
        }
        ReferenceCountUtil.retain(var1);
        var2.add(var1);
        ProtocolSwapHandler.swapProtocolIfNeeded(var4, var1);
    }

    protected void decode(ChannelHandlerContext var0, Packet<?> var1, List<Object> var2) throws Exception {
        PacketFlowValidator.validatePacket(var0, var1, var2, this.decoderKey);
    }

    protected void encode(ChannelHandlerContext var0, Packet<?> var1, List<Object> var2) throws Exception {
        PacketFlowValidator.validatePacket(var0, var1, var2, this.encoderKey);
    }

    protected /* synthetic */ void decode(ChannelHandlerContext channelHandlerContext, Object object, List list) throws Exception {
        this.decode(channelHandlerContext, (Packet)object, (List<Object>)list);
    }

    protected /* synthetic */ void encode(ChannelHandlerContext channelHandlerContext, Object object, List list) throws Exception {
        this.encode(channelHandlerContext, (Packet)object, (List<Object>)list);
    }
}

