/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.ProtocolSwapHandler;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import org.slf4j.Logger;

public class PacketDecoder
extends ByteToMessageDecoder
implements ProtocolSwapHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AttributeKey<EnumProtocol.a<?>> codecKey;

    public PacketDecoder(AttributeKey<EnumProtocol.a<?>> var0) {
        this.codecKey = var0;
    }

    protected void decode(ChannelHandlerContext var0, ByteBuf var1, List<Object> var2) throws Exception {
        PacketDataSerializer var6;
        int var7;
        int var3 = var1.readableBytes();
        if (var3 == 0) {
            return;
        }
        Attribute var4 = var0.channel().attr(this.codecKey);
        EnumProtocol.a var5 = (EnumProtocol.a)var4.get();
        Packet<?> var8 = var5.createPacket(var7 = (var6 = new PacketDataSerializer(var1)).readVarInt(), var6);
        if (var8 == null) {
            throw new IOException("Bad packet id " + var7);
        }
        JvmProfiler.INSTANCE.onPacketReceived(var5.protocol(), var7, var0.channel().remoteAddress(), var3);
        if (var6.readableBytes() > 0) {
            throw new IOException("Packet " + var5.protocol().id() + "/" + var7 + " (" + var8.getClass().getSimpleName() + ") was larger than I expected, found " + var6.readableBytes() + " bytes extra whilst reading packet " + var7);
        }
        var2.add(var8);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(NetworkManager.PACKET_RECEIVED_MARKER, " IN: [{}:{}] {}", new Object[]{var5.protocol().id(), var7, var8.getClass().getName()});
        }
        ProtocolSwapHandler.swapProtocolIfNeeded(var4, var8);
    }
}

