/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.base.Suppliers;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketFlowValidator;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.status.PacketStatusOutListener;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SampleLogger;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float AVERAGE_PACKETS_SMOOTHING = 0.75f;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Marker ROOT_MARKER = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker PACKET_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), var0 -> var0.add(ROOT_MARKER));
    public static final Marker PACKET_RECEIVED_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), var0 -> var0.add(PACKET_MARKER));
    public static final Marker PACKET_SENT_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"PACKET_SENT"), var0 -> var0.add(PACKET_MARKER));
    public static final AttributeKey<EnumProtocol.a<?>> ATTRIBUTE_SERVERBOUND_PROTOCOL = AttributeKey.valueOf((String)"serverbound_protocol");
    public static final AttributeKey<EnumProtocol.a<?>> ATTRIBUTE_CLIENTBOUND_PROTOCOL = AttributeKey.valueOf((String)"clientbound_protocol");
    public static final Supplier<NioEventLoopGroup> NETWORK_WORKER_GROUP = Suppliers.memoize(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).build()));
    public static final Supplier<EpollEventLoopGroup> NETWORK_EPOLL_WORKER_GROUP = Suppliers.memoize(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).build()));
    public static final Supplier<DefaultEventLoopGroup> LOCAL_WORKER_GROUP = Suppliers.memoize(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).build()));
    private final EnumProtocolDirection receiving;
    private final Queue<Consumer<NetworkManager>> pendingActions = Queues.newConcurrentLinkedQueue();
    public Channel channel;
    public SocketAddress address;
    @Nullable
    private volatile PacketListener disconnectListener;
    @Nullable
    private volatile PacketListener packetListener;
    @Nullable
    private IChatBaseComponent disconnectedReason;
    private boolean encrypted;
    private boolean disconnectionHandled;
    private int receivedPackets;
    private int sentPackets;
    private float averageReceivedPackets;
    private float averageSentPackets;
    private int tickCount;
    private boolean handlingFault;
    @Nullable
    private volatile IChatBaseComponent delayedDisconnect;
    @Nullable
    BandwidthDebugMonitor bandwidthDebugMonitor;

    public NetworkManager(EnumProtocolDirection var0) {
        this.receiving = var0;
    }

    public void channelActive(ChannelHandlerContext var0) throws Exception {
        super.channelActive(var0);
        this.channel = var0.channel();
        this.address = this.channel.remoteAddress();
        if (this.delayedDisconnect != null) {
            this.disconnect(this.delayedDisconnect);
        }
    }

    public static void setInitialProtocolAttributes(Channel var0) {
        var0.attr(ATTRIBUTE_SERVERBOUND_PROTOCOL).set(EnumProtocol.HANDSHAKING.codec(EnumProtocolDirection.SERVERBOUND));
        var0.attr(ATTRIBUTE_CLIENTBOUND_PROTOCOL).set(EnumProtocol.HANDSHAKING.codec(EnumProtocolDirection.CLIENTBOUND));
    }

    public void channelInactive(ChannelHandlerContext var0) {
        this.disconnect(IChatBaseComponent.translatable("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext var0, Throwable var1) {
        if (var1 instanceof SkipEncodeException) {
            LOGGER.debug("Skipping packet due to errors", var1.getCause());
            return;
        }
        boolean var2 = !this.handlingFault;
        this.handlingFault = true;
        if (!this.channel.isOpen()) {
            return;
        }
        if (var1 instanceof TimeoutException) {
            LOGGER.debug("Timeout", var1);
            this.disconnect(IChatBaseComponent.translatable("disconnect.timeout"));
        } else {
            IChatMutableComponent var3 = IChatBaseComponent.translatable("disconnect.genericReason", "Internal Exception: " + var1);
            if (var2) {
                LOGGER.debug("Failed to sent packet", var1);
                if (this.getSending() == EnumProtocolDirection.CLIENTBOUND) {
                    EnumProtocol var4 = ((EnumProtocol.a)this.channel.attr(ATTRIBUTE_CLIENTBOUND_PROTOCOL).get()).protocol();
                    Packet<PacketLoginOutListener> var5 = var4 == EnumProtocol.LOGIN ? new PacketLoginOutDisconnect(var3) : new ClientboundDisconnectPacket(var3);
                    this.send(var5, PacketSendListener.thenRun(() -> this.disconnect(var3)));
                } else {
                    this.disconnect(var3);
                }
                this.setReadOnly();
            } else {
                LOGGER.debug("Double fault", var1);
                this.disconnect(var3);
            }
        }
    }

    protected void channelRead0(ChannelHandlerContext var0, Packet<?> var1) {
        if (!this.channel.isOpen()) {
            return;
        }
        PacketListener var2 = this.packetListener;
        if (var2 == null) {
            throw new IllegalStateException("Received a packet before the packet listener was initialized");
        }
        if (var2.shouldHandleMessage(var1)) {
            try {
                NetworkManager.genericsFtw(var1, var2);
            }
            catch (CancelledPacketHandleException cancelledPacketHandleException) {
            }
            catch (RejectedExecutionException var3) {
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.server_shutdown"));
            }
            catch (ClassCastException var3) {
                LOGGER.error("Received {} that couldn't be processed", var1.getClass(), (Object)var3);
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_packet"));
            }
            ++this.receivedPackets;
        }
    }

    private static <T extends PacketListener> void genericsFtw(Packet<T> var0, PacketListener var1) {
        var0.handle(var1);
    }

    public void suspendInboundAfterProtocolChange() {
        this.channel.config().setAutoRead(false);
    }

    public void resumeInboundAfterProtocolChange() {
        this.channel.config().setAutoRead(true);
    }

    public void setListener(PacketListener var0) {
        Validate.notNull((Object)var0, (String)"packetListener", (Object[])new Object[0]);
        EnumProtocolDirection var1 = var0.flow();
        if (var1 != this.receiving) {
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + this.receiving + ", but listener is " + var1);
        }
        EnumProtocol var2 = var0.protocol();
        EnumProtocol var3 = ((EnumProtocol.a)this.channel.attr(NetworkManager.getProtocolKey(var1)).get()).protocol();
        if (var3 != var2) {
            throw new IllegalStateException("Trying to set listener for protocol " + var2.id() + ", but current " + var1 + " protocol is " + var3.id());
        }
        this.packetListener = var0;
        this.disconnectListener = null;
    }

    public void setListenerForServerboundHandshake(PacketListener var0) {
        if (this.packetListener != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.receiving != EnumProtocolDirection.SERVERBOUND || var0.flow() != EnumProtocolDirection.SERVERBOUND || var0.protocol() != EnumProtocol.HANDSHAKING) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.packetListener = var0;
    }

    public void initiateServerboundStatusConnection(String var0, int var1, PacketStatusOutListener var2) {
        this.initiateServerboundConnection(var0, var1, var2, ClientIntent.STATUS);
    }

    public void initiateServerboundPlayConnection(String var0, int var1, PacketLoginOutListener var2) {
        this.initiateServerboundConnection(var0, var1, var2, ClientIntent.LOGIN);
    }

    private void initiateServerboundConnection(String var0, int var1, PacketListener var2, ClientIntent var3) {
        this.disconnectListener = var2;
        this.runOnceConnected(var4 -> {
            var4.setClientboundProtocolAfterHandshake(var3);
            this.setListener(var2);
            var4.sendPacket(new PacketHandshakingInSetProtocol(SharedConstants.getCurrentVersion().getProtocolVersion(), var0, var1, var3), null, true);
        });
    }

    public void setClientboundProtocolAfterHandshake(ClientIntent var0) {
        this.channel.attr(ATTRIBUTE_CLIENTBOUND_PROTOCOL).set(var0.protocol().codec(EnumProtocolDirection.CLIENTBOUND));
    }

    public void send(Packet<?> var0) {
        this.send(var0, null);
    }

    public void send(Packet<?> var0, @Nullable PacketSendListener var1) {
        this.send(var0, var1, true);
    }

    public void send(Packet<?> var0, @Nullable PacketSendListener var1, boolean var2) {
        if (this.isConnected()) {
            this.flushQueue();
            this.sendPacket(var0, var1, var2);
        } else {
            this.pendingActions.add(var3 -> var3.sendPacket(var0, var1, var2));
        }
    }

    public void runOnceConnected(Consumer<NetworkManager> var0) {
        if (this.isConnected()) {
            this.flushQueue();
            var0.accept(this);
        } else {
            this.pendingActions.add(var0);
        }
    }

    private void sendPacket(Packet<?> var0, @Nullable PacketSendListener var1, boolean var2) {
        ++this.sentPackets;
        if (this.channel.eventLoop().inEventLoop()) {
            this.doSendPacket(var0, var1, var2);
        } else {
            this.channel.eventLoop().execute(() -> this.doSendPacket(var0, var1, var2));
        }
    }

    private void doSendPacket(Packet<?> var0, @Nullable PacketSendListener var12, boolean var2) {
        ChannelFuture var3;
        ChannelFuture channelFuture = var3 = var2 ? this.channel.writeAndFlush(var0) : this.channel.write(var0);
        if (var12 != null) {
            var3.addListener(var1 -> {
                if (var1.isSuccess()) {
                    var12.onSuccess();
                } else {
                    Packet<?> var2 = var12.onFailure();
                    if (var2 != null) {
                        ChannelFuture var3 = this.channel.writeAndFlush(var2);
                        var3.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                    }
                }
            });
        }
        var3.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void flushChannel() {
        if (this.isConnected()) {
            this.flush();
        } else {
            this.pendingActions.add(NetworkManager::flush);
        }
    }

    private void flush() {
        if (this.channel.eventLoop().inEventLoop()) {
            this.channel.flush();
        } else {
            this.channel.eventLoop().execute(() -> this.channel.flush());
        }
    }

    private static AttributeKey<EnumProtocol.a<?>> getProtocolKey(EnumProtocolDirection var0) {
        return switch (var0) {
            default -> throw new IncompatibleClassChangeError();
            case EnumProtocolDirection.CLIENTBOUND -> ATTRIBUTE_CLIENTBOUND_PROTOCOL;
            case EnumProtocolDirection.SERVERBOUND -> ATTRIBUTE_SERVERBOUND_PROTOCOL;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushQueue() {
        if (this.channel == null || !this.channel.isOpen()) {
            return;
        }
        Queue<Consumer<NetworkManager>> queue = this.pendingActions;
        synchronized (queue) {
            Consumer<NetworkManager> var1;
            while ((var1 = this.pendingActions.poll()) != null) {
                var1.accept(this);
            }
        }
    }

    public void tick() {
        this.flushQueue();
        PacketListener packetListener = this.packetListener;
        if (packetListener instanceof TickablePacketListener) {
            TickablePacketListener var0 = (TickablePacketListener)packetListener;
            var0.tick();
        }
        if (!this.isConnected() && !this.disconnectionHandled) {
            this.handleDisconnection();
        }
        if (this.channel != null) {
            this.channel.flush();
        }
        if (this.tickCount++ % 20 == 0) {
            this.tickSecond();
        }
        if (this.bandwidthDebugMonitor != null) {
            this.bandwidthDebugMonitor.tick();
        }
    }

    protected void tickSecond() {
        this.averageSentPackets = MathHelper.lerp(0.75f, this.sentPackets, this.averageSentPackets);
        this.averageReceivedPackets = MathHelper.lerp(0.75f, this.receivedPackets, this.averageReceivedPackets);
        this.sentPackets = 0;
        this.receivedPackets = 0;
    }

    public SocketAddress getRemoteAddress() {
        return this.address;
    }

    public String getLoggableAddress(boolean var0) {
        if (this.address == null) {
            return "local";
        }
        if (var0) {
            return this.address.toString();
        }
        return "IP hidden";
    }

    public void disconnect(IChatBaseComponent var0) {
        if (this.channel == null) {
            this.delayedDisconnect = var0;
        }
        if (this.isConnected()) {
            this.channel.close().awaitUninterruptibly();
            this.disconnectedReason = var0;
        }
    }

    public boolean isMemoryConnection() {
        return this.channel instanceof LocalChannel || this.channel instanceof LocalServerChannel;
    }

    public EnumProtocolDirection getReceiving() {
        return this.receiving;
    }

    public EnumProtocolDirection getSending() {
        return this.receiving.getOpposite();
    }

    public static NetworkManager connectToServer(InetSocketAddress var0, boolean var1, @Nullable SampleLogger var2) {
        NetworkManager var3 = new NetworkManager(EnumProtocolDirection.CLIENTBOUND);
        if (var2 != null) {
            var3.setBandwidthLogger(var2);
        }
        ChannelFuture var4 = NetworkManager.connect(var0, var1, var3);
        var4.syncUninterruptibly();
        return var3;
    }

    public static ChannelFuture connect(InetSocketAddress var0, boolean var1, final NetworkManager var2) {
        EventLoopGroup var4;
        Class<NioSocketChannel> var3;
        if (Epoll.isAvailable() && var1) {
            var3 = EpollSocketChannel.class;
            var4 = (EventLoopGroup)NETWORK_EPOLL_WORKER_GROUP.get();
        } else {
            var3 = NioSocketChannel.class;
            var4 = (EventLoopGroup)NETWORK_WORKER_GROUP.get();
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(var4)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel var0) {
                NetworkManager.setInitialProtocolAttributes(var0);
                try {
                    var0.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline var1 = var0.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                NetworkManager.configureSerialization(var1, EnumProtocolDirection.CLIENTBOUND, var2.bandwidthDebugMonitor);
                var2.configurePacketHandler(var1);
            }
        })).channel(var3)).connect(var0.getAddress(), var0.getPort());
    }

    public static void configureSerialization(ChannelPipeline var0, EnumProtocolDirection var1, @Nullable BandwidthDebugMonitor var2) {
        EnumProtocolDirection var3 = var1.getOpposite();
        AttributeKey<EnumProtocol.a<?>> var4 = NetworkManager.getProtocolKey(var1);
        AttributeKey<EnumProtocol.a<?>> var5 = NetworkManager.getProtocolKey(var3);
        var0.addLast("splitter", (ChannelHandler)new PacketSplitter(var2)).addLast("decoder", (ChannelHandler)new PacketDecoder(var4)).addLast("prepender", (ChannelHandler)new PacketPrepender()).addLast("encoder", (ChannelHandler)new PacketEncoder(var5)).addLast("unbundler", (ChannelHandler)new PacketBundleUnpacker(var5)).addLast("bundler", (ChannelHandler)new PacketBundlePacker(var4));
    }

    public void configurePacketHandler(ChannelPipeline var0) {
        var0.addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast("packet_handler", (ChannelHandler)this);
    }

    private static void configureInMemoryPacketValidation(ChannelPipeline var0, EnumProtocolDirection var1) {
        EnumProtocolDirection var2 = var1.getOpposite();
        AttributeKey<EnumProtocol.a<?>> var3 = NetworkManager.getProtocolKey(var1);
        AttributeKey<EnumProtocol.a<?>> var4 = NetworkManager.getProtocolKey(var2);
        var0.addLast("validator", (ChannelHandler)new PacketFlowValidator(var3, var4));
    }

    public static void configureInMemoryPipeline(ChannelPipeline var0, EnumProtocolDirection var1) {
        NetworkManager.configureInMemoryPacketValidation(var0, var1);
    }

    public static NetworkManager connectToLocalServer(SocketAddress var0) {
        final NetworkManager var1 = new NetworkManager(EnumProtocolDirection.CLIENTBOUND);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)LOCAL_WORKER_GROUP.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel var0) {
                NetworkManager.setInitialProtocolAttributes(var0);
                ChannelPipeline var12 = var0.pipeline();
                NetworkManager.configureInMemoryPipeline(var12, EnumProtocolDirection.CLIENTBOUND);
                var1.configurePacketHandler(var12);
            }
        })).channel(LocalChannel.class)).connect(var0).syncUninterruptibly();
        return var1;
    }

    public void setEncryptionKey(Cipher var0, Cipher var1) {
        this.encrypted = true;
        this.channel.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(var0));
        this.channel.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(var1));
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isOpen();
    }

    public boolean isConnecting() {
        return this.channel == null;
    }

    @Nullable
    public PacketListener getPacketListener() {
        return this.packetListener;
    }

    @Nullable
    public IChatBaseComponent getDisconnectedReason() {
        return this.disconnectedReason;
    }

    public void setReadOnly() {
        if (this.channel != null) {
            this.channel.config().setAutoRead(false);
        }
    }

    public void setupCompression(int var0, boolean var1) {
        if (var0 >= 0) {
            if (this.channel.pipeline().get("decompress") instanceof PacketDecompressor) {
                ((PacketDecompressor)this.channel.pipeline().get("decompress")).setThreshold(var0, var1);
            } else {
                this.channel.pipeline().addBefore("decoder", "decompress", (ChannelHandler)new PacketDecompressor(var0, var1));
            }
            if (this.channel.pipeline().get("compress") instanceof PacketCompressor) {
                ((PacketCompressor)this.channel.pipeline().get("compress")).setThreshold(var0);
            } else {
                this.channel.pipeline().addBefore("encoder", "compress", (ChannelHandler)new PacketCompressor(var0));
            }
        } else {
            if (this.channel.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.channel.pipeline().remove("decompress");
            }
            if (this.channel.pipeline().get("compress") instanceof PacketCompressor) {
                this.channel.pipeline().remove("compress");
            }
        }
    }

    public void handleDisconnection() {
        PacketListener var1;
        if (this.channel == null || this.channel.isOpen()) {
            return;
        }
        if (this.disconnectionHandled) {
            LOGGER.warn("handleDisconnection() called twice");
            return;
        }
        this.disconnectionHandled = true;
        PacketListener var0 = this.getPacketListener();
        PacketListener packetListener = var1 = var0 != null ? var0 : this.disconnectListener;
        if (var1 != null) {
            IChatBaseComponent var2 = Objects.requireNonNullElseGet(this.getDisconnectedReason(), () -> IChatBaseComponent.translatable("multiplayer.disconnect.generic"));
            var1.onDisconnect(var2);
        }
    }

    public float getAverageReceivedPackets() {
        return this.averageReceivedPackets;
    }

    public float getAverageSentPackets() {
        return this.averageSentPackets;
    }

    public void setBandwidthLogger(SampleLogger var0) {
        this.bandwidthDebugMonitor = new BandwidthDebugMonitor(var0);
    }

    protected /* synthetic */ void channelRead0(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        this.channelRead0(channelHandlerContext, (Packet)object);
    }
}

