/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ClientboundPingPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.configuration.ClientboundFinishConfigurationPacket;
import net.minecraft.network.protocol.configuration.ClientboundRegistryDataPacket;
import net.minecraft.network.protocol.configuration.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchFinishedPacket;
import net.minecraft.network.protocol.game.ClientboundChunkBatchStartPacket;
import net.minecraft.network.protocol.game.ClientboundChunksBiomesPacket;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundDamageEventPacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEndPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatEnterPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerCombatKillPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.ClientboundServerDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTickingStatePacket;
import net.minecraft.network.protocol.game.ClientboundTickingStepPacket;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInPickItem;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayOutBlockAction;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutBoss;
import net.minecraft.network.protocol.game.PacketPlayOutCamera;
import net.minecraft.network.protocol.game.PacketPlayOutCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayOutCollect;
import net.minecraft.network.protocol.game.PacketPlayOutCommands;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutExplosion;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLightUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutOpenSignEditor;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowHorse;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindowMerchant;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRecipes;
import net.minecraft.network.protocol.game.PacketPlayOutRemoveEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutSelectAdvancementTab;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSetCooldown;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutStatistic;
import net.minecraft.network.protocol.game.PacketPlayOutStopSound;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.network.protocol.game.PacketPlayOutUnloadChunk;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayOutViewCentre;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.game.PacketPlayOutWindowData;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.network.protocol.status.PacketStatusInPing;
import net.minecraft.network.protocol.status.PacketStatusInStart;
import net.minecraft.network.protocol.status.PacketStatusOutPong;
import net.minecraft.network.protocol.status.PacketStatusOutServerInfo;
import net.minecraft.util.VisibleForDebug;
import org.slf4j.Logger;

public final class EnumProtocol
extends Enum<EnumProtocol> {
    public static final /* enum */ EnumProtocol HANDSHAKING = new EnumProtocol("handshake", EnumProtocol.protocol().addFlow(EnumProtocolDirection.CLIENTBOUND, new b()).addFlow(EnumProtocolDirection.SERVERBOUND, new b().addPacket(PacketHandshakingInSetProtocol.class, PacketHandshakingInSetProtocol::new)));
    public static final /* enum */ EnumProtocol PLAY = new EnumProtocol("play", EnumProtocol.protocol().addFlow(EnumProtocolDirection.CLIENTBOUND, new b().withBundlePacket(ClientboundBundlePacket.class, ClientboundBundlePacket::new).addPacket(PacketPlayOutSpawnEntity.class, PacketPlayOutSpawnEntity::new).addPacket(PacketPlayOutSpawnEntityExperienceOrb.class, PacketPlayOutSpawnEntityExperienceOrb::new).addPacket(PacketPlayOutAnimation.class, PacketPlayOutAnimation::new).addPacket(PacketPlayOutStatistic.class, PacketPlayOutStatistic::new).addPacket(ClientboundBlockChangedAckPacket.class, ClientboundBlockChangedAckPacket::new).addPacket(PacketPlayOutBlockBreakAnimation.class, PacketPlayOutBlockBreakAnimation::new).addPacket(PacketPlayOutTileEntityData.class, PacketPlayOutTileEntityData::new).addPacket(PacketPlayOutBlockAction.class, PacketPlayOutBlockAction::new).addPacket(PacketPlayOutBlockChange.class, PacketPlayOutBlockChange::new).addPacket(PacketPlayOutBoss.class, PacketPlayOutBoss::new).addPacket(PacketPlayOutServerDifficulty.class, PacketPlayOutServerDifficulty::new).addPacket(ClientboundChunkBatchFinishedPacket.class, ClientboundChunkBatchFinishedPacket::new).addPacket(ClientboundChunkBatchStartPacket.class, ClientboundChunkBatchStartPacket::new).addPacket(ClientboundChunksBiomesPacket.class, ClientboundChunksBiomesPacket::new).addPacket(ClientboundClearTitlesPacket.class, ClientboundClearTitlesPacket::new).addPacket(PacketPlayOutTabComplete.class, PacketPlayOutTabComplete::new).addPacket(PacketPlayOutCommands.class, PacketPlayOutCommands::new).addPacket(PacketPlayOutCloseWindow.class, PacketPlayOutCloseWindow::new).addPacket(PacketPlayOutWindowItems.class, PacketPlayOutWindowItems::new).addPacket(PacketPlayOutWindowData.class, PacketPlayOutWindowData::new).addPacket(PacketPlayOutSetSlot.class, PacketPlayOutSetSlot::new).addPacket(PacketPlayOutSetCooldown.class, PacketPlayOutSetCooldown::new).addPacket(ClientboundCustomChatCompletionsPacket.class, ClientboundCustomChatCompletionsPacket::new).addPacket(ClientboundCustomPayloadPacket.class, ClientboundCustomPayloadPacket::new).addPacket(ClientboundDamageEventPacket.class, ClientboundDamageEventPacket::new).addPacket(ClientboundDeleteChatPacket.class, ClientboundDeleteChatPacket::new).addPacket(ClientboundDisconnectPacket.class, ClientboundDisconnectPacket::new).addPacket(ClientboundDisguisedChatPacket.class, ClientboundDisguisedChatPacket::new).addPacket(PacketPlayOutEntityStatus.class, PacketPlayOutEntityStatus::new).addPacket(PacketPlayOutExplosion.class, PacketPlayOutExplosion::new).addPacket(PacketPlayOutUnloadChunk.class, PacketPlayOutUnloadChunk::new).addPacket(PacketPlayOutGameStateChange.class, PacketPlayOutGameStateChange::new).addPacket(PacketPlayOutOpenWindowHorse.class, PacketPlayOutOpenWindowHorse::new).addPacket(ClientboundHurtAnimationPacket.class, ClientboundHurtAnimationPacket::new).addPacket(ClientboundInitializeBorderPacket.class, ClientboundInitializeBorderPacket::new).addPacket(ClientboundKeepAlivePacket.class, ClientboundKeepAlivePacket::new).addPacket(ClientboundLevelChunkWithLightPacket.class, ClientboundLevelChunkWithLightPacket::new).addPacket(PacketPlayOutWorldEvent.class, PacketPlayOutWorldEvent::new).addPacket(PacketPlayOutWorldParticles.class, PacketPlayOutWorldParticles::new).addPacket(PacketPlayOutLightUpdate.class, PacketPlayOutLightUpdate::new).addPacket(PacketPlayOutLogin.class, PacketPlayOutLogin::new).addPacket(PacketPlayOutMap.class, PacketPlayOutMap::new).addPacket(PacketPlayOutOpenWindowMerchant.class, PacketPlayOutOpenWindowMerchant::new).addPacket(PacketPlayOutEntity.PacketPlayOutRelEntityMove.class, PacketPlayOutEntity.PacketPlayOutRelEntityMove::read).addPacket(PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook.class, PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook::read).addPacket(PacketPlayOutEntity.PacketPlayOutEntityLook.class, PacketPlayOutEntity.PacketPlayOutEntityLook::read).addPacket(PacketPlayOutVehicleMove.class, PacketPlayOutVehicleMove::new).addPacket(PacketPlayOutOpenBook.class, PacketPlayOutOpenBook::new).addPacket(PacketPlayOutOpenWindow.class, PacketPlayOutOpenWindow::new).addPacket(PacketPlayOutOpenSignEditor.class, PacketPlayOutOpenSignEditor::new).addPacket(ClientboundPingPacket.class, ClientboundPingPacket::new).addPacket(PacketStatusOutPong.class, PacketStatusOutPong::new).addPacket(PacketPlayOutAutoRecipe.class, PacketPlayOutAutoRecipe::new).addPacket(PacketPlayOutAbilities.class, PacketPlayOutAbilities::new).addPacket(ClientboundPlayerChatPacket.class, ClientboundPlayerChatPacket::new).addPacket(ClientboundPlayerCombatEndPacket.class, ClientboundPlayerCombatEndPacket::new).addPacket(ClientboundPlayerCombatEnterPacket.class, ClientboundPlayerCombatEnterPacket::new).addPacket(ClientboundPlayerCombatKillPacket.class, ClientboundPlayerCombatKillPacket::new).addPacket(ClientboundPlayerInfoRemovePacket.class, ClientboundPlayerInfoRemovePacket::new).addPacket(ClientboundPlayerInfoUpdatePacket.class, ClientboundPlayerInfoUpdatePacket::new).addPacket(PacketPlayOutLookAt.class, PacketPlayOutLookAt::new).addPacket(PacketPlayOutPosition.class, PacketPlayOutPosition::new).addPacket(PacketPlayOutRecipes.class, PacketPlayOutRecipes::new).addPacket(PacketPlayOutEntityDestroy.class, PacketPlayOutEntityDestroy::new).addPacket(PacketPlayOutRemoveEntityEffect.class, PacketPlayOutRemoveEntityEffect::new).addPacket(ClientboundResetScorePacket.class, ClientboundResetScorePacket::new).addPacket(ClientboundResourcePackPopPacket.class, ClientboundResourcePackPopPacket::new).addPacket(ClientboundResourcePackPushPacket.class, ClientboundResourcePackPushPacket::new).addPacket(PacketPlayOutRespawn.class, PacketPlayOutRespawn::new).addPacket(PacketPlayOutEntityHeadRotation.class, PacketPlayOutEntityHeadRotation::new).addPacket(PacketPlayOutMultiBlockChange.class, PacketPlayOutMultiBlockChange::new).addPacket(PacketPlayOutSelectAdvancementTab.class, PacketPlayOutSelectAdvancementTab::new).addPacket(ClientboundServerDataPacket.class, ClientboundServerDataPacket::new).addPacket(ClientboundSetActionBarTextPacket.class, ClientboundSetActionBarTextPacket::new).addPacket(ClientboundSetBorderCenterPacket.class, ClientboundSetBorderCenterPacket::new).addPacket(ClientboundSetBorderLerpSizePacket.class, ClientboundSetBorderLerpSizePacket::new).addPacket(ClientboundSetBorderSizePacket.class, ClientboundSetBorderSizePacket::new).addPacket(ClientboundSetBorderWarningDelayPacket.class, ClientboundSetBorderWarningDelayPacket::new).addPacket(ClientboundSetBorderWarningDistancePacket.class, ClientboundSetBorderWarningDistancePacket::new).addPacket(PacketPlayOutCamera.class, PacketPlayOutCamera::new).addPacket(PacketPlayOutHeldItemSlot.class, PacketPlayOutHeldItemSlot::new).addPacket(PacketPlayOutViewCentre.class, PacketPlayOutViewCentre::new).addPacket(PacketPlayOutViewDistance.class, PacketPlayOutViewDistance::new).addPacket(PacketPlayOutSpawnPosition.class, PacketPlayOutSpawnPosition::new).addPacket(PacketPlayOutScoreboardDisplayObjective.class, PacketPlayOutScoreboardDisplayObjective::new).addPacket(PacketPlayOutEntityMetadata.class, PacketPlayOutEntityMetadata::new).addPacket(PacketPlayOutAttachEntity.class, PacketPlayOutAttachEntity::new).addPacket(PacketPlayOutEntityVelocity.class, PacketPlayOutEntityVelocity::new).addPacket(PacketPlayOutEntityEquipment.class, PacketPlayOutEntityEquipment::new).addPacket(PacketPlayOutExperience.class, PacketPlayOutExperience::new).addPacket(PacketPlayOutUpdateHealth.class, PacketPlayOutUpdateHealth::new).addPacket(PacketPlayOutScoreboardObjective.class, PacketPlayOutScoreboardObjective::new).addPacket(PacketPlayOutMount.class, PacketPlayOutMount::new).addPacket(PacketPlayOutScoreboardTeam.class, PacketPlayOutScoreboardTeam::new).addPacket(PacketPlayOutScoreboardScore.class, PacketPlayOutScoreboardScore::new).addPacket(ClientboundSetSimulationDistancePacket.class, ClientboundSetSimulationDistancePacket::new).addPacket(ClientboundSetSubtitleTextPacket.class, ClientboundSetSubtitleTextPacket::new).addPacket(PacketPlayOutUpdateTime.class, PacketPlayOutUpdateTime::new).addPacket(ClientboundSetTitleTextPacket.class, ClientboundSetTitleTextPacket::new).addPacket(ClientboundSetTitlesAnimationPacket.class, ClientboundSetTitlesAnimationPacket::new).addPacket(PacketPlayOutEntitySound.class, PacketPlayOutEntitySound::new).addPacket(PacketPlayOutNamedSoundEffect.class, PacketPlayOutNamedSoundEffect::new).addPacket(ClientboundStartConfigurationPacket.class, ClientboundStartConfigurationPacket::new).addPacket(PacketPlayOutStopSound.class, PacketPlayOutStopSound::new).addPacket(ClientboundSystemChatPacket.class, ClientboundSystemChatPacket::new).addPacket(PacketPlayOutPlayerListHeaderFooter.class, PacketPlayOutPlayerListHeaderFooter::new).addPacket(PacketPlayOutNBTQuery.class, PacketPlayOutNBTQuery::new).addPacket(PacketPlayOutCollect.class, PacketPlayOutCollect::new).addPacket(PacketPlayOutEntityTeleport.class, PacketPlayOutEntityTeleport::new).addPacket(ClientboundTickingStatePacket.class, ClientboundTickingStatePacket::new).addPacket(ClientboundTickingStepPacket.class, ClientboundTickingStepPacket::new).addPacket(PacketPlayOutAdvancements.class, PacketPlayOutAdvancements::new).addPacket(PacketPlayOutUpdateAttributes.class, PacketPlayOutUpdateAttributes::new).addPacket(PacketPlayOutEntityEffect.class, PacketPlayOutEntityEffect::new).addPacket(PacketPlayOutRecipeUpdate.class, PacketPlayOutRecipeUpdate::new).addPacket(ClientboundUpdateTagsPacket.class, ClientboundUpdateTagsPacket::new)).addFlow(EnumProtocolDirection.SERVERBOUND, new b().addPacket(PacketPlayInTeleportAccept.class, PacketPlayInTeleportAccept::new).addPacket(PacketPlayInTileNBTQuery.class, PacketPlayInTileNBTQuery::new).addPacket(PacketPlayInDifficultyChange.class, PacketPlayInDifficultyChange::new).addPacket(ServerboundChatAckPacket.class, ServerboundChatAckPacket::new).addPacket(ServerboundChatCommandPacket.class, ServerboundChatCommandPacket::new).addPacket(PacketPlayInChat.class, PacketPlayInChat::new).addPacket(ServerboundChatSessionUpdatePacket.class, ServerboundChatSessionUpdatePacket::new).addPacket(ServerboundChunkBatchReceivedPacket.class, ServerboundChunkBatchReceivedPacket::new).addPacket(PacketPlayInClientCommand.class, PacketPlayInClientCommand::new).addPacket(ServerboundClientInformationPacket.class, ServerboundClientInformationPacket::new).addPacket(PacketPlayInTabComplete.class, PacketPlayInTabComplete::new).addPacket(ServerboundConfigurationAcknowledgedPacket.class, ServerboundConfigurationAcknowledgedPacket::new).addPacket(PacketPlayInEnchantItem.class, PacketPlayInEnchantItem::new).addPacket(PacketPlayInWindowClick.class, PacketPlayInWindowClick::new).addPacket(PacketPlayInCloseWindow.class, PacketPlayInCloseWindow::new).addPacket(ServerboundContainerSlotStateChangedPacket.class, ServerboundContainerSlotStateChangedPacket::new).addPacket(ServerboundCustomPayloadPacket.class, ServerboundCustomPayloadPacket::new).addPacket(PacketPlayInBEdit.class, PacketPlayInBEdit::new).addPacket(PacketPlayInEntityNBTQuery.class, PacketPlayInEntityNBTQuery::new).addPacket(PacketPlayInUseEntity.class, PacketPlayInUseEntity::new).addPacket(PacketPlayInJigsawGenerate.class, PacketPlayInJigsawGenerate::new).addPacket(ServerboundKeepAlivePacket.class, ServerboundKeepAlivePacket::new).addPacket(PacketPlayInDifficultyLock.class, PacketPlayInDifficultyLock::new).addPacket(PacketPlayInFlying.PacketPlayInPosition.class, PacketPlayInFlying.PacketPlayInPosition::read).addPacket(PacketPlayInFlying.PacketPlayInPositionLook.class, PacketPlayInFlying.PacketPlayInPositionLook::read).addPacket(PacketPlayInFlying.PacketPlayInLook.class, PacketPlayInFlying.PacketPlayInLook::read).addPacket(PacketPlayInFlying.d.class, PacketPlayInFlying.d::read).addPacket(PacketPlayInVehicleMove.class, PacketPlayInVehicleMove::new).addPacket(PacketPlayInBoatMove.class, PacketPlayInBoatMove::new).addPacket(PacketPlayInPickItem.class, PacketPlayInPickItem::new).addPacket(PacketStatusInPing.class, PacketStatusInPing::new).addPacket(PacketPlayInAutoRecipe.class, PacketPlayInAutoRecipe::new).addPacket(PacketPlayInAbilities.class, PacketPlayInAbilities::new).addPacket(PacketPlayInBlockDig.class, PacketPlayInBlockDig::new).addPacket(PacketPlayInEntityAction.class, PacketPlayInEntityAction::new).addPacket(PacketPlayInSteerVehicle.class, PacketPlayInSteerVehicle::new).addPacket(ServerboundPongPacket.class, ServerboundPongPacket::new).addPacket(PacketPlayInRecipeSettings.class, PacketPlayInRecipeSettings::new).addPacket(PacketPlayInRecipeDisplayed.class, PacketPlayInRecipeDisplayed::new).addPacket(PacketPlayInItemName.class, PacketPlayInItemName::new).addPacket(ServerboundResourcePackPacket.class, ServerboundResourcePackPacket::new).addPacket(PacketPlayInAdvancements.class, PacketPlayInAdvancements::new).addPacket(PacketPlayInTrSel.class, PacketPlayInTrSel::new).addPacket(PacketPlayInBeacon.class, PacketPlayInBeacon::new).addPacket(PacketPlayInHeldItemSlot.class, PacketPlayInHeldItemSlot::new).addPacket(PacketPlayInSetCommandBlock.class, PacketPlayInSetCommandBlock::new).addPacket(PacketPlayInSetCommandMinecart.class, PacketPlayInSetCommandMinecart::new).addPacket(PacketPlayInSetCreativeSlot.class, PacketPlayInSetCreativeSlot::new).addPacket(PacketPlayInSetJigsaw.class, PacketPlayInSetJigsaw::new).addPacket(PacketPlayInStruct.class, PacketPlayInStruct::new).addPacket(PacketPlayInUpdateSign.class, PacketPlayInUpdateSign::new).addPacket(PacketPlayInArmAnimation.class, PacketPlayInArmAnimation::new).addPacket(PacketPlayInSpectate.class, PacketPlayInSpectate::new).addPacket(PacketPlayInUseItem.class, PacketPlayInUseItem::new).addPacket(PacketPlayInBlockPlace.class, PacketPlayInBlockPlace::new)));
    public static final /* enum */ EnumProtocol STATUS = new EnumProtocol("status", EnumProtocol.protocol().addFlow(EnumProtocolDirection.SERVERBOUND, new b().addPacket(PacketStatusInStart.class, PacketStatusInStart::new).addPacket(PacketStatusInPing.class, PacketStatusInPing::new)).addFlow(EnumProtocolDirection.CLIENTBOUND, new b().addPacket(PacketStatusOutServerInfo.class, PacketStatusOutServerInfo::new).addPacket(PacketStatusOutPong.class, PacketStatusOutPong::new)));
    public static final /* enum */ EnumProtocol LOGIN = new EnumProtocol("login", EnumProtocol.protocol().addFlow(EnumProtocolDirection.CLIENTBOUND, new b().addPacket(PacketLoginOutDisconnect.class, PacketLoginOutDisconnect::new).addPacket(PacketLoginOutEncryptionBegin.class, PacketLoginOutEncryptionBegin::new).addPacket(PacketLoginOutSuccess.class, PacketLoginOutSuccess::new).addPacket(PacketLoginOutSetCompression.class, PacketLoginOutSetCompression::new).addPacket(PacketLoginOutCustomPayload.class, PacketLoginOutCustomPayload::new)).addFlow(EnumProtocolDirection.SERVERBOUND, new b().addPacket(PacketLoginInStart.class, PacketLoginInStart::new).addPacket(PacketLoginInEncryptionBegin.class, PacketLoginInEncryptionBegin::new).addPacket(ServerboundCustomQueryAnswerPacket.class, ServerboundCustomQueryAnswerPacket::read).addPacket(ServerboundLoginAcknowledgedPacket.class, ServerboundLoginAcknowledgedPacket::new)));
    public static final /* enum */ EnumProtocol CONFIGURATION = new EnumProtocol("configuration", EnumProtocol.protocol().addFlow(EnumProtocolDirection.CLIENTBOUND, new b().addPacket(ClientboundCustomPayloadPacket.class, ClientboundCustomPayloadPacket::new).addPacket(ClientboundDisconnectPacket.class, ClientboundDisconnectPacket::new).addPacket(ClientboundFinishConfigurationPacket.class, ClientboundFinishConfigurationPacket::new).addPacket(ClientboundKeepAlivePacket.class, ClientboundKeepAlivePacket::new).addPacket(ClientboundPingPacket.class, ClientboundPingPacket::new).addPacket(ClientboundRegistryDataPacket.class, ClientboundRegistryDataPacket::new).addPacket(ClientboundResourcePackPopPacket.class, ClientboundResourcePackPopPacket::new).addPacket(ClientboundResourcePackPushPacket.class, ClientboundResourcePackPushPacket::new).addPacket(ClientboundUpdateEnabledFeaturesPacket.class, ClientboundUpdateEnabledFeaturesPacket::new).addPacket(ClientboundUpdateTagsPacket.class, ClientboundUpdateTagsPacket::new)).addFlow(EnumProtocolDirection.SERVERBOUND, new b().addPacket(ServerboundClientInformationPacket.class, ServerboundClientInformationPacket::new).addPacket(ServerboundCustomPayloadPacket.class, ServerboundCustomPayloadPacket::new).addPacket(ServerboundFinishConfigurationPacket.class, ServerboundFinishConfigurationPacket::new).addPacket(ServerboundKeepAlivePacket.class, ServerboundKeepAlivePacket::new).addPacket(ServerboundPongPacket.class, ServerboundPongPacket::new).addPacket(ServerboundResourcePackPacket.class, ServerboundResourcePackPacket::new)));
    public static final int NOT_REGISTERED = -1;
    private final String id;
    private final Map<EnumProtocolDirection, a<?>> flows;
    private static final /* synthetic */ EnumProtocol[] i;

    public static EnumProtocol[] values() {
        return (EnumProtocol[])i.clone();
    }

    public static EnumProtocol valueOf(String var0) {
        return Enum.valueOf(EnumProtocol.class, var0);
    }

    private static c protocol() {
        return new c();
    }

    private EnumProtocol(String var2, c var3) {
        this.id = var2;
        this.flows = var3.buildCodecs(this);
    }

    @VisibleForDebug
    public Int2ObjectMap<Class<? extends Packet<?>>> getPacketsByIds(EnumProtocolDirection var0) {
        return this.flows.get((Object)var0).packetsByIds();
    }

    @VisibleForDebug
    public String id() {
        return this.id;
    }

    public a<?> codec(EnumProtocolDirection var0) {
        return this.flows.get((Object)var0);
    }

    private static /* synthetic */ EnumProtocol[] c() {
        return new EnumProtocol[]{HANDSHAKING, PLAY, STATUS, LOGIN, CONFIGURATION};
    }

    static {
        i = EnumProtocol.c();
    }

    static class c {
        private final Map<EnumProtocolDirection, b<?>> flows = Maps.newEnumMap(EnumProtocolDirection.class);

        c() {
        }

        public <T extends PacketListener> c addFlow(EnumProtocolDirection var0, b<T> var1) {
            this.flows.put(var0, var1);
            return this;
        }

        public Map<EnumProtocolDirection, a<?>> buildCodecs(EnumProtocol var0) {
            EnumMap var1 = new EnumMap(EnumProtocolDirection.class);
            for (EnumProtocolDirection var5 : EnumProtocolDirection.values()) {
                b<?> var6 = this.flows.get((Object)var5);
                if (var6 == null) {
                    throw new IllegalStateException("Missing packets for flow " + var5 + " in protocol " + var0);
                }
                var1.put(var5, new a(var0, var5, var6));
            }
            return var1;
        }
    }

    public static class a<T extends PacketListener>
    implements BundlerInfo.b {
        private final EnumProtocol protocol;
        private final EnumProtocolDirection flow;
        private final b<T> packetSet;

        public a(EnumProtocol var0, EnumProtocolDirection var1, b<T> var2) {
            this.protocol = var0;
            this.flow = var1;
            this.packetSet = var2;
        }

        public EnumProtocol protocol() {
            return this.protocol;
        }

        public EnumProtocolDirection flow() {
            return this.flow;
        }

        public int packetId(Packet<?> var0) {
            return this.packetSet.getId(var0.getClass());
        }

        @Override
        public BundlerInfo bundlerInfo() {
            return this.packetSet.bundlerInfo();
        }

        Int2ObjectMap<Class<? extends Packet<?>>> packetsByIds() {
            Int2ObjectOpenHashMap var0 = new Int2ObjectOpenHashMap();
            this.packetSet.classToId.forEach((arg_0, arg_1) -> a.a((Int2ObjectMap)var0, arg_0, arg_1));
            return var0;
        }

        @Nullable
        public Packet<?> createPacket(int var0, PacketDataSerializer var1) {
            return this.packetSet.createPacket(var0, var1);
        }

        public boolean isValidPacketType(Packet<?> var0) {
            return this.packetSet.isKnownPacket(var0.getClass());
        }

        private static /* synthetic */ void a(Int2ObjectMap var0, Class var1, Integer var2) {
            var0.put(var2.intValue(), (Object)var1);
        }
    }

    static class b<T extends PacketListener> {
        private static final Logger LOGGER = LogUtils.getLogger();
        final Object2IntMap<Class<? extends Packet<? super T>>> classToId = (Object2IntMap)SystemUtils.make(new Object2IntOpenHashMap(), var0 -> var0.defaultReturnValue(-1));
        private final List<Function<PacketDataSerializer, ? extends Packet<? super T>>> idToDeserializer = Lists.newArrayList();
        private BundlerInfo bundlerInfo = BundlerInfo.EMPTY;
        private final Set<Class<? extends Packet<T>>> extraClasses = new HashSet<Class<? extends Packet<T>>>();

        b() {
        }

        public <P extends Packet<? super T>> b<T> addPacket(Class<P> var0, Function<PacketDataSerializer, P> var1) {
            int var2 = this.idToDeserializer.size();
            int var3 = this.classToId.put(var0, var2);
            if (var3 != -1) {
                String var4 = "Packet " + var0 + " is already registered to ID " + var3;
                LOGGER.error(LogUtils.FATAL_MARKER, var4);
                throw new IllegalArgumentException(var4);
            }
            this.idToDeserializer.add(var1);
            return this;
        }

        public <P extends BundlePacket<T>> b<T> withBundlePacket(Class<P> var0, Function<Iterable<Packet<T>>, P> var12) {
            if (this.bundlerInfo != BundlerInfo.EMPTY) {
                throw new IllegalStateException("Bundle packet already configured");
            }
            BundleDelimiterPacket var2 = new BundleDelimiterPacket();
            this.addPacket(BundleDelimiterPacket.class, var1 -> var2);
            this.bundlerInfo = BundlerInfo.createForPacket(var0, var12, var2);
            this.extraClasses.add(var0);
            return this;
        }

        public int getId(Class<?> var0) {
            return this.classToId.getInt(var0);
        }

        public boolean isKnownPacket(Class<?> var0) {
            return this.classToId.containsKey(var0) || this.extraClasses.contains(var0);
        }

        @Nullable
        public Packet<?> createPacket(int var0, PacketDataSerializer var1) {
            Function<PacketDataSerializer, Packet<PacketDataSerializer>> var2 = this.idToDeserializer.get(var0);
            return var2 != null ? var2.apply(var1) : null;
        }

        public BundlerInfo bundlerInfo() {
            return this.bundlerInfo;
        }
    }
}

