/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.TagVisitor;

public class SnbtPrinterTagVisitor
implements TagVisitor {
    private static final Map<String, List<String>> KEY_ORDER = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put("{}", Lists.newArrayList((Object[])new String[]{"DataVersion", "author", "size", "data", "entities", "palette", "palettes"}));
        var0.put("{}.data.[].{}", Lists.newArrayList((Object[])new String[]{"pos", "state", "nbt"}));
        var0.put("{}.entities.[].{}", Lists.newArrayList((Object[])new String[]{"blockPos", "pos"}));
    });
    private static final Set<String> NO_INDENTATION = Sets.newHashSet((Object[])new String[]{"{}.size.[]", "{}.data.[].{}", "{}.palette.[].{}", "{}.entities.[].{}"});
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");
    private static final String NAME_VALUE_SEPARATOR = String.valueOf(':');
    private static final String ELEMENT_SEPARATOR = String.valueOf(',');
    private static final String LIST_OPEN = "[";
    private static final String LIST_CLOSE = "]";
    private static final String LIST_TYPE_SEPARATOR = ";";
    private static final String ELEMENT_SPACING = " ";
    private static final String STRUCT_OPEN = "{";
    private static final String STRUCT_CLOSE = "}";
    private static final String NEWLINE = "\n";
    private final String indentation;
    private final int depth;
    private final List<String> path;
    private String result = "";

    public SnbtPrinterTagVisitor() {
        this("    ", 0, Lists.newArrayList());
    }

    public SnbtPrinterTagVisitor(String var0, int var1, List<String> var2) {
        this.indentation = var0;
        this.depth = var1;
        this.path = var2;
    }

    public String visit(NBTBase var0) {
        var0.accept(this);
        return this.result;
    }

    @Override
    public void visitString(NBTTagString var0) {
        this.result = NBTTagString.quoteAndEscape(var0.getAsString());
    }

    @Override
    public void visitByte(NBTTagByte var0) {
        this.result = var0.getAsNumber() + "b";
    }

    @Override
    public void visitShort(NBTTagShort var0) {
        this.result = var0.getAsNumber() + "s";
    }

    @Override
    public void visitInt(NBTTagInt var0) {
        this.result = String.valueOf(var0.getAsNumber());
    }

    @Override
    public void visitLong(NBTTagLong var0) {
        this.result = var0.getAsNumber() + "L";
    }

    @Override
    public void visitFloat(NBTTagFloat var0) {
        this.result = var0.getAsFloat() + "f";
    }

    @Override
    public void visitDouble(NBTTagDouble var0) {
        this.result = var0.getAsDouble() + "d";
    }

    @Override
    public void visitByteArray(NBTTagByteArray var0) {
        StringBuilder var1 = new StringBuilder(LIST_OPEN).append("B").append(LIST_TYPE_SEPARATOR);
        byte[] var2 = var0.getAsByteArray();
        for (int var3 = 0; var3 < var2.length; ++var3) {
            var1.append(ELEMENT_SPACING).append(var2[var3]).append("B");
            if (var3 == var2.length - 1) continue;
            var1.append(ELEMENT_SEPARATOR);
        }
        var1.append(LIST_CLOSE);
        this.result = var1.toString();
    }

    @Override
    public void visitIntArray(NBTTagIntArray var0) {
        StringBuilder var1 = new StringBuilder(LIST_OPEN).append("I").append(LIST_TYPE_SEPARATOR);
        int[] var2 = var0.getAsIntArray();
        for (int var3 = 0; var3 < var2.length; ++var3) {
            var1.append(ELEMENT_SPACING).append(var2[var3]);
            if (var3 == var2.length - 1) continue;
            var1.append(ELEMENT_SEPARATOR);
        }
        var1.append(LIST_CLOSE);
        this.result = var1.toString();
    }

    @Override
    public void visitLongArray(NBTTagLongArray var0) {
        String var1 = "L";
        StringBuilder var2 = new StringBuilder(LIST_OPEN).append("L").append(LIST_TYPE_SEPARATOR);
        long[] var3 = var0.getAsLongArray();
        for (int var4 = 0; var4 < var3.length; ++var4) {
            var2.append(ELEMENT_SPACING).append(var3[var4]).append("L");
            if (var4 == var3.length - 1) continue;
            var2.append(ELEMENT_SEPARATOR);
        }
        var2.append(LIST_CLOSE);
        this.result = var2.toString();
    }

    @Override
    public void visitList(NBTTagList var0) {
        String var2;
        if (var0.isEmpty()) {
            this.result = "[]";
            return;
        }
        StringBuilder var1 = new StringBuilder(LIST_OPEN);
        this.pushPath("[]");
        String string = var2 = NO_INDENTATION.contains(this.pathString()) ? "" : this.indentation;
        if (!var2.isEmpty()) {
            var1.append(NEWLINE);
        }
        for (int var3 = 0; var3 < var0.size(); ++var3) {
            var1.append(Strings.repeat((String)var2, (int)(this.depth + 1)));
            var1.append(new SnbtPrinterTagVisitor(var2, this.depth + 1, this.path).visit(var0.get(var3)));
            if (var3 == var0.size() - 1) continue;
            var1.append(ELEMENT_SEPARATOR).append(var2.isEmpty() ? ELEMENT_SPACING : NEWLINE);
        }
        if (!var2.isEmpty()) {
            var1.append(NEWLINE).append(Strings.repeat((String)var2, (int)this.depth));
        }
        var1.append(LIST_CLOSE);
        this.result = var1.toString();
        this.popPath();
    }

    @Override
    public void visitCompound(NBTTagCompound var0) {
        String var2;
        if (var0.isEmpty()) {
            this.result = "{}";
            return;
        }
        StringBuilder var1 = new StringBuilder(STRUCT_OPEN);
        this.pushPath("{}");
        String string = var2 = NO_INDENTATION.contains(this.pathString()) ? "" : this.indentation;
        if (!var2.isEmpty()) {
            var1.append(NEWLINE);
        }
        List<String> var3 = this.getKeys(var0);
        Iterator var4 = var3.iterator();
        while (var4.hasNext()) {
            String var5 = (String)var4.next();
            NBTBase var6 = var0.get(var5);
            this.pushPath(var5);
            var1.append(Strings.repeat((String)var2, (int)(this.depth + 1))).append(SnbtPrinterTagVisitor.handleEscapePretty(var5)).append(NAME_VALUE_SEPARATOR).append(ELEMENT_SPACING).append(new SnbtPrinterTagVisitor(var2, this.depth + 1, this.path).visit(var6));
            this.popPath();
            if (!var4.hasNext()) continue;
            var1.append(ELEMENT_SEPARATOR).append(var2.isEmpty() ? ELEMENT_SPACING : NEWLINE);
        }
        if (!var2.isEmpty()) {
            var1.append(NEWLINE).append(Strings.repeat((String)var2, (int)this.depth));
        }
        var1.append(STRUCT_CLOSE);
        this.result = var1.toString();
        this.popPath();
    }

    private void popPath() {
        this.path.remove(this.path.size() - 1);
    }

    private void pushPath(String var0) {
        this.path.add(var0);
    }

    protected List<String> getKeys(NBTTagCompound var0) {
        HashSet var1 = Sets.newHashSet(var0.getAllKeys());
        ArrayList var2 = Lists.newArrayList();
        List<String> var3 = KEY_ORDER.get(this.pathString());
        if (var3 != null) {
            for (String var5 : var3) {
                if (!var1.remove(var5)) continue;
                var2.add(var5);
            }
            if (!var1.isEmpty()) {
                var1.stream().sorted().forEach(var2::add);
            }
        } else {
            var2.addAll(var1);
            Collections.sort(var2);
        }
        return var2;
    }

    public String pathString() {
        return String.join((CharSequence)".", this.path);
    }

    protected static String handleEscapePretty(String var0) {
        if (SIMPLE_VALUE.matcher(var0).matches()) {
            return var0;
        }
        return NBTTagString.quoteAndEscape(var0);
    }

    @Override
    public void visitEnd(NBTTagEnd var0) {
    }
}

