/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.DelegateDataOutput;
import net.minecraft.util.FastBufferedInputStream;

public class NBTCompressedStreamTools {
    private static final OpenOption[] SYNC_OUTPUT_OPTIONS = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};

    public static NBTTagCompound readCompressed(Path var0, NBTReadLimiter var1) throws IOException {
        try (InputStream var2 = Files.newInputStream(var0, new OpenOption[0]);){
            NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.readCompressed(var2, var1);
            return nBTTagCompound;
        }
    }

    private static DataInputStream createDecompressorStream(InputStream var0) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(var0)));
    }

    private static DataOutputStream createCompressorStream(OutputStream var0) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(var0)));
    }

    public static NBTTagCompound readCompressed(InputStream var0, NBTReadLimiter var1) throws IOException {
        try (DataInputStream var2 = NBTCompressedStreamTools.createDecompressorStream(var0);){
            NBTTagCompound nBTTagCompound = NBTCompressedStreamTools.read(var2, var1);
            return nBTTagCompound;
        }
    }

    public static void parseCompressed(Path var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
        try (InputStream var3 = Files.newInputStream(var0, new OpenOption[0]);){
            NBTCompressedStreamTools.parseCompressed(var3, var1, var2);
        }
    }

    public static void parseCompressed(InputStream var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
        try (DataInputStream var3 = NBTCompressedStreamTools.createDecompressorStream(var0);){
            NBTCompressedStreamTools.parse(var3, var1, var2);
        }
    }

    public static void writeCompressed(NBTTagCompound var0, Path var1) throws IOException {
        try (OutputStream var2 = Files.newOutputStream(var1, SYNC_OUTPUT_OPTIONS);
             BufferedOutputStream var3 = new BufferedOutputStream(var2);){
            NBTCompressedStreamTools.writeCompressed(var0, var3);
        }
    }

    public static void writeCompressed(NBTTagCompound var0, OutputStream var1) throws IOException {
        try (DataOutputStream var2 = NBTCompressedStreamTools.createCompressorStream(var1);){
            NBTCompressedStreamTools.write(var0, var2);
        }
    }

    public static void write(NBTTagCompound var0, Path var1) throws IOException {
        try (OutputStream var2 = Files.newOutputStream(var1, SYNC_OUTPUT_OPTIONS);
             BufferedOutputStream var3 = new BufferedOutputStream(var2);
             DataOutputStream var4 = new DataOutputStream(var3);){
            NBTCompressedStreamTools.write(var0, var4);
        }
    }

    @Nullable
    public static NBTTagCompound read(Path var0) throws IOException {
        if (!Files.exists(var0, new LinkOption[0])) {
            return null;
        }
        try (InputStream var1 = Files.newInputStream(var0, new OpenOption[0]);){
            NBTTagCompound nBTTagCompound;
            try (DataInputStream var2 = new DataInputStream(var1);){
                nBTTagCompound = NBTCompressedStreamTools.read(var2, NBTReadLimiter.unlimitedHeap());
            }
            return nBTTagCompound;
        }
    }

    public static NBTTagCompound read(DataInput var0) throws IOException {
        return NBTCompressedStreamTools.read(var0, NBTReadLimiter.unlimitedHeap());
    }

    public static NBTTagCompound read(DataInput var0, NBTReadLimiter var1) throws IOException {
        NBTBase var2 = NBTCompressedStreamTools.readUnnamedTag(var0, var1);
        if (var2 instanceof NBTTagCompound) {
            return (NBTTagCompound)var2;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(NBTTagCompound var0, DataOutput var1) throws IOException {
        NBTCompressedStreamTools.writeUnnamedTagWithFallback(var0, var1);
    }

    public static void parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
        NBTTagType<?> var3 = NBTTagTypes.getType(var0.readByte());
        if (var3 == NBTTagEnd.TYPE) {
            if (var1.visitRootEntry(NBTTagEnd.TYPE) == StreamTagVisitor.b.CONTINUE) {
                var1.visitEnd();
            }
            return;
        }
        switch (var1.visitRootEntry(var3)) {
            case HALT: {
                break;
            }
            case BREAK: {
                NBTTagString.skipString(var0);
                var3.skip(var0, var2);
                break;
            }
            case CONTINUE: {
                NBTTagString.skipString(var0);
                var3.parse(var0, var1, var2);
            }
        }
    }

    public static NBTBase readAnyTag(DataInput var0, NBTReadLimiter var1) throws IOException {
        byte var2 = var0.readByte();
        if (var2 == 0) {
            return NBTTagEnd.INSTANCE;
        }
        return NBTCompressedStreamTools.readTagSafe(var0, var1, var2);
    }

    public static void writeAnyTag(NBTBase var0, DataOutput var1) throws IOException {
        var1.writeByte(var0.getId());
        if (var0.getId() == 0) {
            return;
        }
        var0.write(var1);
    }

    public static void writeUnnamedTag(NBTBase var0, DataOutput var1) throws IOException {
        var1.writeByte(var0.getId());
        if (var0.getId() == 0) {
            return;
        }
        var1.writeUTF("");
        var0.write(var1);
    }

    public static void writeUnnamedTagWithFallback(NBTBase var0, DataOutput var1) throws IOException {
        NBTCompressedStreamTools.writeUnnamedTag(var0, new a(var1));
    }

    private static NBTBase readUnnamedTag(DataInput var0, NBTReadLimiter var1) throws IOException {
        byte var2 = var0.readByte();
        if (var2 == 0) {
            return NBTTagEnd.INSTANCE;
        }
        NBTTagString.skipString(var0);
        return NBTCompressedStreamTools.readTagSafe(var0, var1, var2);
    }

    private static NBTBase readTagSafe(DataInput var0, NBTReadLimiter var1, byte var2) {
        try {
            return NBTTagTypes.getType(var2).load(var0, var1);
        }
        catch (IOException var3) {
            CrashReport var4 = CrashReport.forThrowable(var3, "Loading NBT data");
            CrashReportSystemDetails var5 = var4.addCategory("NBT Tag");
            var5.setDetail("Tag type", var2);
            throw new ReportedNbtException(var4);
        }
    }

    public static class a
    extends DelegateDataOutput {
        public a(DataOutput var0) {
            super(var0);
        }

        @Override
        public void writeUTF(String var0) throws IOException {
            try {
                super.writeUTF(var0);
            }
            catch (UTFDataFormatException var1) {
                SystemUtils.logAndPauseIfInIde("Failed to write NBT String", var1);
                super.writeUTF("");
            }
        }
    }
}

