/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.ticks.TickListServer;
import org.slf4j.Logger;

public class GameTestHarnessStructures {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String DEFAULT_TEST_STRUCTURES_DIR = "gameteststructures";
    public static String testStructuresDir = "gameteststructures";

    public static EnumBlockRotation getRotationForRotationSteps(int var0) {
        switch (var0) {
            case 0: {
                return EnumBlockRotation.NONE;
            }
            case 1: {
                return EnumBlockRotation.CLOCKWISE_90;
            }
            case 2: {
                return EnumBlockRotation.CLOCKWISE_180;
            }
            case 3: {
                return EnumBlockRotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("rotationSteps must be a value from 0-3. Got value " + var0);
    }

    public static int getRotationStepsForRotation(EnumBlockRotation var0) {
        switch (var0) {
            case NONE: {
                return 0;
            }
            case CLOCKWISE_90: {
                return 1;
            }
            case CLOCKWISE_180: {
                return 2;
            }
            case COUNTERCLOCKWISE_90: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown rotation value, don't know how many steps it represents: " + var0);
    }

    public static AxisAlignedBB getStructureBounds(TileEntityStructure var0) {
        return AxisAlignedBB.of(GameTestHarnessStructures.getStructureBoundingBox(var0));
    }

    public static StructureBoundingBox getStructureBoundingBox(TileEntityStructure var0) {
        BlockPosition var1 = GameTestHarnessStructures.getStructureOrigin(var0);
        BlockPosition var2 = GameTestHarnessStructures.getTransformedFarCorner(var1, var0.getStructureSize(), var0.getRotation());
        return StructureBoundingBox.fromCorners(var1, var2);
    }

    public static BlockPosition getStructureOrigin(TileEntityStructure var0) {
        return var0.getBlockPos().offset(var0.getStructurePos());
    }

    public static void addCommandBlockAndButtonToStartTest(BlockPosition var0, BlockPosition var1, EnumBlockRotation var2, WorldServer var3) {
        BlockPosition var4 = DefinedStructure.transform(var0.offset(var1), EnumBlockMirror.NONE, var2, var0);
        var3.setBlockAndUpdate(var4, Blocks.COMMAND_BLOCK.defaultBlockState());
        TileEntityCommand var5 = (TileEntityCommand)var3.getBlockEntity(var4);
        var5.getCommandBlock().setCommand("test runthis");
        BlockPosition var6 = DefinedStructure.transform(var4.offset(0, 0, -1), EnumBlockMirror.NONE, var2, var4);
        var3.setBlockAndUpdate(var6, Blocks.STONE_BUTTON.defaultBlockState().rotate(var2));
    }

    public static void createNewEmptyStructureBlock(String var0, BlockPosition var1, BaseBlockPosition var2, EnumBlockRotation var3, WorldServer var4) {
        StructureBoundingBox var5 = GameTestHarnessStructures.getStructureBoundingBox(var1.above(), var2, var3);
        GameTestHarnessStructures.clearSpaceForStructure(var5, var4);
        var4.setBlockAndUpdate(var1, Blocks.STRUCTURE_BLOCK.defaultBlockState());
        TileEntityStructure var6 = (TileEntityStructure)var4.getBlockEntity(var1);
        var6.setIgnoreEntities(false);
        var6.setStructureName(new MinecraftKey(var0));
        var6.setStructureSize(var2);
        var6.setMode(BlockPropertyStructureMode.SAVE);
        var6.setShowBoundingBox(true);
    }

    public static TileEntityStructure prepareTestStructure(GameTestHarnessInfo var0, BlockPosition var1, EnumBlockRotation var2, WorldServer var3) {
        BlockPosition var6;
        BaseBlockPosition var4 = var3.getStructureManager().get(new MinecraftKey(var0.getStructureName())).orElseThrow(() -> new IllegalStateException("Missing test structure: " + var0.getStructureName())).getSize();
        StructureBoundingBox var5 = GameTestHarnessStructures.getStructureBoundingBox(var1, var4, var2);
        if (var2 == EnumBlockRotation.NONE) {
            var6 = var1;
        } else if (var2 == EnumBlockRotation.CLOCKWISE_90) {
            var6 = var1.offset(var4.getZ() - 1, 0, 0);
        } else if (var2 == EnumBlockRotation.CLOCKWISE_180) {
            var6 = var1.offset(var4.getX() - 1, 0, var4.getZ() - 1);
        } else if (var2 == EnumBlockRotation.COUNTERCLOCKWISE_90) {
            var6 = var1.offset(0, 0, var4.getX() - 1);
        } else {
            throw new IllegalArgumentException("Invalid rotation: " + var2);
        }
        GameTestHarnessStructures.forceLoadChunks(var5, var3);
        GameTestHarnessStructures.clearSpaceForStructure(var5, var3);
        return GameTestHarnessStructures.createStructureBlock(var0, var6.below(), var2, var3);
    }

    private static void forceLoadChunks(StructureBoundingBox var0, WorldServer var12) {
        var0.intersectingChunks().forEach(var1 -> var12.setChunkForced(var1.x, var1.z, true));
    }

    public static void clearSpaceForStructure(StructureBoundingBox var02, WorldServer var1) {
        int var22 = var02.minY() - 1;
        StructureBoundingBox var3 = new StructureBoundingBox(var02.minX() - 2, var02.minY() - 3, var02.minZ() - 3, var02.maxX() + 3, var02.maxY() + 20, var02.maxZ() + 3);
        BlockPosition.betweenClosedStream(var3).forEach(var2 -> GameTestHarnessStructures.clearBlock(var22, var2, var1));
        ((TickListServer)var1.getBlockTicks()).clearArea(var3);
        var1.clearBlockEvents(var3);
        AxisAlignedBB var4 = new AxisAlignedBB(var3.minX(), var3.minY(), var3.minZ(), var3.maxX(), var3.maxY(), var3.maxZ());
        List<Entity> var5 = var1.getEntitiesOfClass(Entity.class, var4, var0 -> !(var0 instanceof EntityHuman));
        var5.forEach(Entity::discard);
    }

    public static BlockPosition getTransformedFarCorner(BlockPosition var0, BaseBlockPosition var1, EnumBlockRotation var2) {
        BlockPosition var3 = var0.offset(var1).offset(-1, -1, -1);
        return DefinedStructure.transform(var3, EnumBlockMirror.NONE, var2, var0);
    }

    public static StructureBoundingBox getStructureBoundingBox(BlockPosition var0, BaseBlockPosition var1, EnumBlockRotation var2) {
        BlockPosition var3 = GameTestHarnessStructures.getTransformedFarCorner(var0, var1, var2);
        StructureBoundingBox var4 = StructureBoundingBox.fromCorners(var0, var3);
        int var5 = Math.min(var4.minX(), var4.maxX());
        int var6 = Math.min(var4.minZ(), var4.maxZ());
        return var4.move(var0.getX() - var5, 0, var0.getZ() - var6);
    }

    public static Optional<BlockPosition> findStructureBlockContainingPos(BlockPosition var0, int var1, WorldServer var22) {
        return GameTestHarnessStructures.findStructureBlocks(var0, var1, var22).stream().filter(var2 -> GameTestHarnessStructures.doesStructureContain(var2, var0, var22)).findFirst();
    }

    @Nullable
    public static BlockPosition findNearestStructureBlock(BlockPosition var0, int var12, WorldServer var2) {
        Comparator<BlockPosition> var3 = Comparator.comparingInt(var1 -> var1.distManhattan(var0));
        Collection<BlockPosition> var4 = GameTestHarnessStructures.findStructureBlocks(var0, var12, var2);
        Optional<BlockPosition> var5 = var4.stream().min(var3);
        return var5.orElse(null);
    }

    public static Collection<BlockPosition> findStructureBlocks(BlockPosition var0, int var1, WorldServer var22) {
        ArrayList var3 = Lists.newArrayList();
        StructureBoundingBox var4 = new StructureBoundingBox(var0).inflatedBy(var1);
        BlockPosition.betweenClosedStream(var4).forEach(var2 -> {
            if (var22.getBlockState((BlockPosition)var2).is(Blocks.STRUCTURE_BLOCK)) {
                var3.add(var2.immutable());
            }
        });
        return var3;
    }

    private static TileEntityStructure createStructureBlock(GameTestHarnessInfo var0, BlockPosition var1, EnumBlockRotation var2, WorldServer var3) {
        var3.setBlockAndUpdate(var1, Blocks.STRUCTURE_BLOCK.defaultBlockState());
        TileEntityStructure var4 = (TileEntityStructure)var3.getBlockEntity(var1);
        var4.setMode(BlockPropertyStructureMode.LOAD);
        var4.setRotation(var2);
        var4.setIgnoreEntities(false);
        var4.setStructureName(new MinecraftKey(var0.getStructureName()));
        var4.setMetaData(var0.getTestName());
        if (!var4.loadStructureInfo(var3)) {
            throw new RuntimeException("Failed to load structure info for test: " + var0.getTestName() + ". Structure name: " + var0.getStructureName());
        }
        return var4;
    }

    private static void clearBlock(int var0, BlockPosition var1, WorldServer var2) {
        IBlockData var3 = var1.getY() < var0 ? Blocks.STONE.defaultBlockState() : Blocks.AIR.defaultBlockState();
        ArgumentTileLocation var4 = new ArgumentTileLocation(var3, Collections.emptySet(), null);
        var4.place(var2, var1, 2);
        var2.blockUpdated(var1, var3.getBlock());
    }

    private static boolean doesStructureContain(BlockPosition var0, BlockPosition var1, WorldServer var2) {
        TileEntityStructure var3 = (TileEntityStructure)var2.getBlockEntity(var0);
        return GameTestHarnessStructures.getStructureBoundingBox(var3).isInside(var1);
    }
}

