/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.gametest.framework.AfterBatch;
import net.minecraft.gametest.framework.BeforeBatch;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.EnumBlockRotation;

public class GameTestHarnessRegistry {
    private static final Collection<GameTestHarnessTestFunction> TEST_FUNCTIONS = Lists.newArrayList();
    private static final Set<String> TEST_CLASS_NAMES = Sets.newHashSet();
    private static final Map<String, Consumer<WorldServer>> BEFORE_BATCH_FUNCTIONS = Maps.newHashMap();
    private static final Map<String, Consumer<WorldServer>> AFTER_BATCH_FUNCTIONS = Maps.newHashMap();
    private static final Collection<GameTestHarnessTestFunction> LAST_FAILED_TESTS = Sets.newHashSet();

    public static void register(Class<?> var0) {
        Arrays.stream(var0.getDeclaredMethods()).sorted(Comparator.comparing(Method::getName)).forEach(GameTestHarnessRegistry::register);
    }

    public static void register(Method var0) {
        GameTestGenerator var3;
        String var1 = var0.getDeclaringClass().getSimpleName();
        GameTest var2 = var0.getAnnotation(GameTest.class);
        if (var2 != null) {
            TEST_FUNCTIONS.add(GameTestHarnessRegistry.turnMethodIntoTestFunction(var0));
            TEST_CLASS_NAMES.add(var1);
        }
        if ((var3 = var0.getAnnotation(GameTestGenerator.class)) != null) {
            TEST_FUNCTIONS.addAll(GameTestHarnessRegistry.useTestGeneratorMethod(var0));
            TEST_CLASS_NAMES.add(var1);
        }
        GameTestHarnessRegistry.registerBatchFunction(var0, BeforeBatch.class, BeforeBatch::batch, BEFORE_BATCH_FUNCTIONS);
        GameTestHarnessRegistry.registerBatchFunction(var0, AfterBatch.class, AfterBatch::batch, AFTER_BATCH_FUNCTIONS);
    }

    private static <T extends Annotation> void registerBatchFunction(Method var0, Class<T> var1, Function<T, String> var2, Map<String, Consumer<WorldServer>> var3) {
        String var5;
        Consumer<?> var6;
        T var4 = var0.getAnnotation(var1);
        if (var4 != null && (var6 = var3.putIfAbsent(var5 = var2.apply(var4), GameTestHarnessRegistry.turnMethodIntoConsumer(var0))) != null) {
            throw new RuntimeException("Hey, there should only be one " + var1 + " method per batch. Batch '" + var5 + "' has more than one!");
        }
    }

    public static Collection<GameTestHarnessTestFunction> getTestFunctionsForClassName(String var0) {
        return TEST_FUNCTIONS.stream().filter(var1 -> GameTestHarnessRegistry.isTestFunctionPartOfClass(var1, var0)).collect(Collectors.toList());
    }

    public static Collection<GameTestHarnessTestFunction> getAllTestFunctions() {
        return TEST_FUNCTIONS;
    }

    public static Collection<String> getAllTestClassNames() {
        return TEST_CLASS_NAMES;
    }

    public static boolean isTestClass(String var0) {
        return TEST_CLASS_NAMES.contains(var0);
    }

    @Nullable
    public static Consumer<WorldServer> getBeforeBatchFunction(String var0) {
        return BEFORE_BATCH_FUNCTIONS.get(var0);
    }

    @Nullable
    public static Consumer<WorldServer> getAfterBatchFunction(String var0) {
        return AFTER_BATCH_FUNCTIONS.get(var0);
    }

    public static Optional<GameTestHarnessTestFunction> findTestFunction(String var0) {
        return GameTestHarnessRegistry.getAllTestFunctions().stream().filter(var1 -> var1.getTestName().equalsIgnoreCase(var0)).findFirst();
    }

    public static GameTestHarnessTestFunction getTestFunction(String var0) {
        Optional<GameTestHarnessTestFunction> var1 = GameTestHarnessRegistry.findTestFunction(var0);
        if (var1.isEmpty()) {
            throw new IllegalArgumentException("Can't find the test function for " + var0);
        }
        return var1.get();
    }

    private static Collection<GameTestHarnessTestFunction> useTestGeneratorMethod(Method var0) {
        try {
            Object var1 = var0.getDeclaringClass().newInstance();
            return (Collection)var0.invoke(var1, new Object[0]);
        }
        catch (ReflectiveOperationException var1) {
            throw new RuntimeException(var1);
        }
    }

    private static GameTestHarnessTestFunction turnMethodIntoTestFunction(Method var0) {
        GameTest var1 = var0.getAnnotation(GameTest.class);
        String var2 = var0.getDeclaringClass().getSimpleName();
        String var3 = var2.toLowerCase();
        String var4 = var3 + "." + var0.getName().toLowerCase();
        String var5 = var1.template().isEmpty() ? var4 : var3 + "." + var1.template();
        String var6 = var1.batch();
        EnumBlockRotation var7 = GameTestHarnessStructures.getRotationForRotationSteps(var1.rotationSteps());
        return new GameTestHarnessTestFunction(var6, var4, var5, var7, var1.timeoutTicks(), var1.setupTicks(), var1.required(), var1.requiredSuccesses(), var1.attempts(), GameTestHarnessRegistry.turnMethodIntoConsumer(var0));
    }

    private static Consumer<?> turnMethodIntoConsumer(Method var0) {
        return var1 -> {
            try {
                Object var2 = var0.getDeclaringClass().newInstance();
                var0.invoke(var2, var1);
            }
            catch (InvocationTargetException var2) {
                if (var2.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)var2.getCause();
                }
                throw new RuntimeException(var2.getCause());
            }
            catch (ReflectiveOperationException var2) {
                throw new RuntimeException(var2);
            }
        };
    }

    private static boolean isTestFunctionPartOfClass(GameTestHarnessTestFunction var0, String var1) {
        return var0.getTestName().toLowerCase().startsWith(var1.toLowerCase() + ".");
    }

    public static Collection<GameTestHarnessTestFunction> getLastFailedTests() {
        return LAST_FAILED_TESTS;
    }

    public static void rememberFailedTest(GameTestHarnessTestFunction var0) {
        LAST_FAILED_TESTS.add(var0);
    }

    public static void forgetFailedTests() {
        LAST_FAILED_TESTS.clear();
    }
}

