/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.placement;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.heightproviders.VeryBiasedToBottomHeight;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceRelativeThresholdFilter;
import net.minecraft.world.level.material.FluidTypes;

public class MiscOverworldPlacements {
    public static final ResourceKey<PlacedFeature> ICE_SPIKE = PlacementUtils.createKey("ice_spike");
    public static final ResourceKey<PlacedFeature> ICE_PATCH = PlacementUtils.createKey("ice_patch");
    public static final ResourceKey<PlacedFeature> FOREST_ROCK = PlacementUtils.createKey("forest_rock");
    public static final ResourceKey<PlacedFeature> ICEBERG_PACKED = PlacementUtils.createKey("iceberg_packed");
    public static final ResourceKey<PlacedFeature> ICEBERG_BLUE = PlacementUtils.createKey("iceberg_blue");
    public static final ResourceKey<PlacedFeature> BLUE_ICE = PlacementUtils.createKey("blue_ice");
    public static final ResourceKey<PlacedFeature> LAKE_LAVA_UNDERGROUND = PlacementUtils.createKey("lake_lava_underground");
    public static final ResourceKey<PlacedFeature> LAKE_LAVA_SURFACE = PlacementUtils.createKey("lake_lava_surface");
    public static final ResourceKey<PlacedFeature> DISK_CLAY = PlacementUtils.createKey("disk_clay");
    public static final ResourceKey<PlacedFeature> DISK_GRAVEL = PlacementUtils.createKey("disk_gravel");
    public static final ResourceKey<PlacedFeature> DISK_SAND = PlacementUtils.createKey("disk_sand");
    public static final ResourceKey<PlacedFeature> DISK_GRASS = PlacementUtils.createKey("disk_grass");
    public static final ResourceKey<PlacedFeature> FREEZE_TOP_LAYER = PlacementUtils.createKey("freeze_top_layer");
    public static final ResourceKey<PlacedFeature> VOID_START_PLATFORM = PlacementUtils.createKey("void_start_platform");
    public static final ResourceKey<PlacedFeature> DESERT_WELL = PlacementUtils.createKey("desert_well");
    public static final ResourceKey<PlacedFeature> SPRING_LAVA = PlacementUtils.createKey("spring_lava");
    public static final ResourceKey<PlacedFeature> SPRING_LAVA_FROZEN = PlacementUtils.createKey("spring_lava_frozen");
    public static final ResourceKey<PlacedFeature> SPRING_WATER = PlacementUtils.createKey("spring_water");

    public static void bootstrap(BootstapContext<PlacedFeature> var0) {
        HolderGetter<WorldGenFeatureConfigured<?, ?>> var1 = var0.lookup(Registries.CONFIGURED_FEATURE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var2 = var1.getOrThrow(MiscOverworldFeatures.ICE_SPIKE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var3 = var1.getOrThrow(MiscOverworldFeatures.ICE_PATCH);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var4 = var1.getOrThrow(MiscOverworldFeatures.FOREST_ROCK);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var5 = var1.getOrThrow(MiscOverworldFeatures.ICEBERG_PACKED);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var6 = var1.getOrThrow(MiscOverworldFeatures.ICEBERG_BLUE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var7 = var1.getOrThrow(MiscOverworldFeatures.BLUE_ICE);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var8 = var1.getOrThrow(MiscOverworldFeatures.LAKE_LAVA);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var9 = var1.getOrThrow(MiscOverworldFeatures.DISK_CLAY);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var10 = var1.getOrThrow(MiscOverworldFeatures.DISK_GRAVEL);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var11 = var1.getOrThrow(MiscOverworldFeatures.DISK_SAND);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var12 = var1.getOrThrow(MiscOverworldFeatures.DISK_GRASS);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var13 = var1.getOrThrow(MiscOverworldFeatures.FREEZE_TOP_LAYER);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var14 = var1.getOrThrow(MiscOverworldFeatures.VOID_START_PLATFORM);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var15 = var1.getOrThrow(MiscOverworldFeatures.DESERT_WELL);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var16 = var1.getOrThrow(MiscOverworldFeatures.SPRING_LAVA_OVERWORLD);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var17 = var1.getOrThrow(MiscOverworldFeatures.SPRING_LAVA_FROZEN);
        Holder.c<WorldGenFeatureConfigured<?, ?>> var18 = var1.getOrThrow(MiscOverworldFeatures.SPRING_WATER);
        PlacementUtils.register(var0, ICE_SPIKE, var2, CountPlacement.of(3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, ICE_PATCH, var3, CountPlacement.of(2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, RandomOffsetPlacement.vertical(ConstantInt.of(-1)), BlockPredicateFilter.forPredicate(BlockPredicate.matchesBlocks(Blocks.SNOW_BLOCK)), BiomeFilter.biome());
        PlacementUtils.register(var0, FOREST_ROCK, var4, CountPlacement.of(2), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, ICEBERG_BLUE, var6, RarityFilter.onAverageOnceEvery(200), InSquarePlacement.spread(), BiomeFilter.biome());
        PlacementUtils.register(var0, ICEBERG_PACKED, var5, RarityFilter.onAverageOnceEvery(16), InSquarePlacement.spread(), BiomeFilter.biome());
        PlacementUtils.register(var0, BLUE_ICE, var7, CountPlacement.of(UniformInt.of(0, 19)), InSquarePlacement.spread(), HeightRangePlacement.uniform(VerticalAnchor.absolute(30), VerticalAnchor.absolute(61)), BiomeFilter.biome());
        PlacementUtils.register(var0, LAKE_LAVA_UNDERGROUND, var8, RarityFilter.onAverageOnceEvery(9), InSquarePlacement.spread(), HeightRangePlacement.of(UniformHeight.of(VerticalAnchor.absolute(0), VerticalAnchor.top())), EnvironmentScanPlacement.scanningFor(EnumDirection.DOWN, BlockPredicate.allOf(BlockPredicate.not(BlockPredicate.ONLY_IN_AIR_PREDICATE), BlockPredicate.insideWorld(new BlockPosition(0, -5, 0))), 32), SurfaceRelativeThresholdFilter.of(HeightMap.Type.OCEAN_FLOOR_WG, Integer.MIN_VALUE, -5), BiomeFilter.biome());
        PlacementUtils.register(var0, LAKE_LAVA_SURFACE, var8, RarityFilter.onAverageOnceEvery(200), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome());
        PlacementUtils.register(var0, DISK_CLAY, var9, InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate(BlockPredicate.matchesFluids(FluidTypes.WATER)), BiomeFilter.biome());
        PlacementUtils.register(var0, DISK_GRAVEL, var10, InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate(BlockPredicate.matchesFluids(FluidTypes.WATER)), BiomeFilter.biome());
        PlacementUtils.register(var0, DISK_SAND, var11, CountPlacement.of(3), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, BlockPredicateFilter.forPredicate(BlockPredicate.matchesFluids(FluidTypes.WATER)), BiomeFilter.biome());
        PlacementUtils.register(var0, DISK_GRASS, var12, CountPlacement.of(1), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_TOP_SOLID, RandomOffsetPlacement.vertical(ConstantInt.of(-1)), BlockPredicateFilter.forPredicate(BlockPredicate.matchesBlocks(Blocks.MUD)), BiomeFilter.biome());
        PlacementUtils.register(var0, FREEZE_TOP_LAYER, var13, BiomeFilter.biome());
        PlacementUtils.register(var0, VOID_START_PLATFORM, var14, BiomeFilter.biome());
        PlacementUtils.register(var0, DESERT_WELL, var15, RarityFilter.onAverageOnceEvery(1000), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome());
        PlacementUtils.register(var0, SPRING_LAVA, var16, CountPlacement.of(20), InSquarePlacement.spread(), HeightRangePlacement.of(VeryBiasedToBottomHeight.of(VerticalAnchor.bottom(), VerticalAnchor.belowTop(8), 8)), BiomeFilter.biome());
        PlacementUtils.register(var0, SPRING_LAVA_FROZEN, var17, CountPlacement.of(20), InSquarePlacement.spread(), HeightRangePlacement.of(VeryBiasedToBottomHeight.of(VerticalAnchor.bottom(), VerticalAnchor.belowTop(8), 8)), BiomeFilter.biome());
        PlacementUtils.register(var0, SPRING_WATER, var18, CountPlacement.of(25), InSquarePlacement.spread(), HeightRangePlacement.uniform(VerticalAnchor.bottom(), VerticalAnchor.absolute(192)), BiomeFilter.biome());
    }
}

