/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.AncientCityStructurePieces;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.TrailRuinsStructurePools;
import net.minecraft.data.worldgen.WorldGenFeatureBastionPieces;
import net.minecraft.data.worldgen.WorldGenFeatureDesertVillage;
import net.minecraft.data.worldgen.WorldGenFeaturePillagerOutpostPieces;
import net.minecraft.data.worldgen.WorldGenFeatureVillagePlain;
import net.minecraft.data.worldgen.WorldGenFeatureVillageSavanna;
import net.minecraft.data.worldgen.WorldGenFeatureVillageSnowy;
import net.minecraft.data.worldgen.WorldGenFeatureVillageTaiga;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.structures.BuriedTreasureStructure;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidStructure;
import net.minecraft.world.level.levelgen.structure.structures.EndCityStructure;
import net.minecraft.world.level.levelgen.structure.structures.IglooStructure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.structures.JungleTempleStructure;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import net.minecraft.world.level.levelgen.structure.structures.NetherFossilStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanMonumentStructure;
import net.minecraft.world.level.levelgen.structure.structures.OceanRuinStructure;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalPiece;
import net.minecraft.world.level.levelgen.structure.structures.RuinedPortalStructure;
import net.minecraft.world.level.levelgen.structure.structures.ShipwreckStructure;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdStructure;
import net.minecraft.world.level.levelgen.structure.structures.SwampHutStructure;
import net.minecraft.world.level.levelgen.structure.structures.WoodlandMansionStructure;

public class Structures {
    public static Structure.c structure(HolderSet<BiomeBase> var0, Map<EnumCreatureType, StructureSpawnOverride> var1, WorldGenStage.Decoration var2, TerrainAdjustment var3) {
        return new Structure.c(var0, var1, var2, var3);
    }

    private static Structure.c structure(HolderSet<BiomeBase> var0, WorldGenStage.Decoration var1, TerrainAdjustment var2) {
        return Structures.structure(var0, Map.of(), var1, var2);
    }

    private static Structure.c structure(HolderSet<BiomeBase> var0, TerrainAdjustment var1) {
        return Structures.structure(var0, Map.of(), WorldGenStage.Decoration.SURFACE_STRUCTURES, var1);
    }

    public static void bootstrap(BootstapContext<Structure> var02) {
        HolderGetter<BiomeBase> var1 = var02.lookup(Registries.BIOME);
        HolderGetter<WorldGenFeatureDefinedStructurePoolTemplate> var2 = var02.lookup(Registries.TEMPLATE_POOL);
        var02.register(BuiltinStructures.PILLAGER_OUTPOST, new JigsawStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_PILLAGER_OUTPOST), Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.PILLAGER, 1, 1, 1)}))), WorldGenStage.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN), var2.getOrThrow(WorldGenFeaturePillagerOutpostPieces.START), 7, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        var02.register(BuiltinStructures.MINESHAFT, new MineshaftStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_MINESHAFT), WorldGenStage.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE), MineshaftStructure.a.NORMAL));
        var02.register(BuiltinStructures.MINESHAFT_MESA, new MineshaftStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_MINESHAFT_MESA), WorldGenStage.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE), MineshaftStructure.a.MESA));
        var02.register(BuiltinStructures.WOODLAND_MANSION, new WoodlandMansionStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_WOODLAND_MANSION), TerrainAdjustment.NONE)));
        var02.register(BuiltinStructures.JUNGLE_TEMPLE, new JungleTempleStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_JUNGLE_TEMPLE), TerrainAdjustment.NONE)));
        var02.register(BuiltinStructures.DESERT_PYRAMID, new DesertPyramidStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_DESERT_PYRAMID), TerrainAdjustment.NONE)));
        var02.register(BuiltinStructures.IGLOO, new IglooStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_IGLOO), TerrainAdjustment.NONE)));
        var02.register(BuiltinStructures.SHIPWRECK, new ShipwreckStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_SHIPWRECK), TerrainAdjustment.NONE), false));
        var02.register(BuiltinStructures.SHIPWRECK_BEACHED, new ShipwreckStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_SHIPWRECK_BEACHED), TerrainAdjustment.NONE), true));
        var02.register(BuiltinStructures.SWAMP_HUT, new SwampHutStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_SWAMP_HUT), Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.PIECE, WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.WITCH, 1, 1, 1)})), EnumCreatureType.CREATURE, new StructureSpawnOverride(StructureSpawnOverride.a.PIECE, WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.CAT, 1, 1, 1)}))), WorldGenStage.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        var02.register(BuiltinStructures.STRONGHOLD, new StrongholdStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_STRONGHOLD), TerrainAdjustment.BURY)));
        var02.register(BuiltinStructures.OCEAN_MONUMENT, new OceanMonumentStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_OCEAN_MONUMENT), Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, WeightedRandomList.create((WeightedEntry[])new BiomeSettingsMobs.c[]{new BiomeSettingsMobs.c(EntityTypes.GUARDIAN, 1, 2, 4)})), EnumCreatureType.UNDERGROUND_WATER_CREATURE, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, BiomeSettingsMobs.EMPTY_MOB_LIST), EnumCreatureType.AXOLOTLS, new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, BiomeSettingsMobs.EMPTY_MOB_LIST)), WorldGenStage.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        var02.register(BuiltinStructures.OCEAN_RUIN_COLD, new OceanRuinStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_OCEAN_RUIN_COLD), TerrainAdjustment.NONE), OceanRuinStructure.a.COLD, 0.3f, 0.9f));
        var02.register(BuiltinStructures.OCEAN_RUIN_WARM, new OceanRuinStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_OCEAN_RUIN_WARM), TerrainAdjustment.NONE), OceanRuinStructure.a.WARM, 0.3f, 0.9f));
        var02.register(BuiltinStructures.FORTRESS, new NetherFortressStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_NETHER_FORTRESS), Map.of(EnumCreatureType.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.a.PIECE, NetherFortressStructure.FORTRESS_ENEMIES)), WorldGenStage.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.NONE)));
        var02.register(BuiltinStructures.NETHER_FOSSIL, new NetherFossilStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_NETHER_FOSSIL), WorldGenStage.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.BEARD_THIN), UniformHeight.of(VerticalAnchor.absolute(32), VerticalAnchor.belowTop(2))));
        var02.register(BuiltinStructures.END_CITY, new EndCityStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_END_CITY), TerrainAdjustment.NONE)));
        var02.register(BuiltinStructures.BURIED_TREASURE, new BuriedTreasureStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_BURIED_TREASURE), WorldGenStage.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.NONE)));
        var02.register(BuiltinStructures.BASTION_REMNANT, new JigsawStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_BASTION_REMNANT), TerrainAdjustment.NONE), var2.getOrThrow(WorldGenFeatureBastionPieces.START), 6, ConstantHeight.of(VerticalAnchor.absolute(33)), false));
        var02.register(BuiltinStructures.VILLAGE_PLAINS, new JigsawStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_VILLAGE_PLAINS), TerrainAdjustment.BEARD_THIN), var2.getOrThrow(WorldGenFeatureVillagePlain.START), 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        var02.register(BuiltinStructures.VILLAGE_DESERT, new JigsawStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_VILLAGE_DESERT), TerrainAdjustment.BEARD_THIN), var2.getOrThrow(WorldGenFeatureDesertVillage.START), 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        var02.register(BuiltinStructures.VILLAGE_SAVANNA, new JigsawStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_VILLAGE_SAVANNA), TerrainAdjustment.BEARD_THIN), var2.getOrThrow(WorldGenFeatureVillageSavanna.START), 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        var02.register(BuiltinStructures.VILLAGE_SNOWY, new JigsawStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_VILLAGE_SNOWY), TerrainAdjustment.BEARD_THIN), var2.getOrThrow(WorldGenFeatureVillageSnowy.START), 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        var02.register(BuiltinStructures.VILLAGE_TAIGA, new JigsawStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_VILLAGE_TAIGA), TerrainAdjustment.BEARD_THIN), var2.getOrThrow(WorldGenFeatureVillageTaiga.START), 6, ConstantHeight.of(VerticalAnchor.absolute(0)), true, HeightMap.Type.WORLD_SURFACE_WG));
        var02.register(BuiltinStructures.RUINED_PORTAL_STANDARD, new RuinedPortalStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_STANDARD), TerrainAdjustment.NONE), List.of(new RuinedPortalStructure.a(RuinedPortalPiece.b.UNDERGROUND, 1.0f, 0.2f, false, false, true, false, 0.5f), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_LAND_SURFACE, 0.5f, 0.2f, false, false, true, false, 0.5f))));
        var02.register(BuiltinStructures.RUINED_PORTAL_DESERT, new RuinedPortalStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_DESERT), TerrainAdjustment.NONE), new RuinedPortalStructure.a(RuinedPortalPiece.b.PARTLY_BURIED, 0.0f, 0.0f, false, false, false, false, 1.0f)));
        var02.register(BuiltinStructures.RUINED_PORTAL_JUNGLE, new RuinedPortalStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_JUNGLE), TerrainAdjustment.NONE), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_LAND_SURFACE, 0.5f, 0.8f, true, true, false, false, 1.0f)));
        var02.register(BuiltinStructures.RUINED_PORTAL_SWAMP, new RuinedPortalStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_SWAMP), TerrainAdjustment.NONE), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_OCEAN_FLOOR, 0.0f, 0.5f, false, true, false, false, 1.0f)));
        var02.register(BuiltinStructures.RUINED_PORTAL_MOUNTAIN, new RuinedPortalStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_MOUNTAIN), TerrainAdjustment.NONE), List.of(new RuinedPortalStructure.a(RuinedPortalPiece.b.IN_MOUNTAIN, 1.0f, 0.2f, false, false, true, false, 0.5f), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_LAND_SURFACE, 0.5f, 0.2f, false, false, true, false, 0.5f))));
        var02.register(BuiltinStructures.RUINED_PORTAL_OCEAN, new RuinedPortalStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_OCEAN), TerrainAdjustment.NONE), new RuinedPortalStructure.a(RuinedPortalPiece.b.ON_OCEAN_FLOOR, 0.0f, 0.8f, false, false, true, false, 1.0f)));
        var02.register(BuiltinStructures.RUINED_PORTAL_NETHER, new RuinedPortalStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_RUINED_PORTAL_NETHER), TerrainAdjustment.NONE), new RuinedPortalStructure.a(RuinedPortalPiece.b.IN_NETHER, 0.5f, 0.0f, false, false, false, true, 1.0f)));
        var02.register(BuiltinStructures.ANCIENT_CITY, new JigsawStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_ANCIENT_CITY), Arrays.stream(EnumCreatureType.values()).collect(Collectors.toMap(var0 -> var0, var0 -> new StructureSpawnOverride(StructureSpawnOverride.a.STRUCTURE, WeightedRandomList.create()))), WorldGenStage.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.BEARD_BOX), var2.getOrThrow(AncientCityStructurePieces.START), Optional.of(new MinecraftKey("city_anchor")), 7, ConstantHeight.of(VerticalAnchor.absolute(-27)), false, Optional.empty(), 116, List.of()));
        var02.register(BuiltinStructures.TRAIL_RUINS, new JigsawStructure(Structures.structure(var1.getOrThrow(BiomeTags.HAS_TRAIL_RUINS), Map.of(), WorldGenStage.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BURY), var2.getOrThrow(TrailRuinsStructurePools.START), 7, ConstantHeight.of(VerticalAnchor.absolute(-15)), false, HeightMap.Type.WORLD_SURFACE_WG));
    }
}

