/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.Lifecycle;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.Registry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public interface IRegistry<T>
extends Keyable,
Registry<T> {
    public ResourceKey<? extends IRegistry<T>> key();

    default public Codec<T> byNameCodec() {
        Codec var02 = MinecraftKey.CODEC.flatXmap(var0 -> Optional.ofNullable(this.get((MinecraftKey)var0)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + this.key() + ": " + var0)), var0 -> this.getResourceKey(var0).map(ResourceKey::location).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + this.key() + ":" + var0)));
        Codec<Object> var1 = ExtraCodecs.idResolverCodec(var0 -> this.getResourceKey(var0).isPresent() ? this.getId(var0) : -1, this::byId, -1);
        return ExtraCodecs.overrideLifecycle(ExtraCodecs.orCompressed(var02, var1), this::lifecycle, this::lifecycle);
    }

    default public Codec<Holder<T>> holderByNameCodec() {
        Codec var02 = MinecraftKey.CODEC.flatXmap(var0 -> this.getHolder(ResourceKey.create(this.key(), var0)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + this.key() + ": " + var0)), var0 -> var0.unwrapKey().map(ResourceKey::location).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + this.key() + ":" + var0)));
        return ExtraCodecs.overrideLifecycle(var02, var0 -> this.lifecycle(var0.value()), var0 -> this.lifecycle(var0.value()));
    }

    default public <U> Stream<U> keys(DynamicOps<U> var0) {
        return this.keySet().stream().map(var1 -> var0.createString(var1.toString()));
    }

    @Nullable
    public MinecraftKey getKey(T var1);

    public Optional<ResourceKey<T>> getResourceKey(T var1);

    @Override
    public int getId(@Nullable T var1);

    @Nullable
    public T get(@Nullable ResourceKey<T> var1);

    @Nullable
    public T get(@Nullable MinecraftKey var1);

    public Lifecycle lifecycle(T var1);

    public Lifecycle registryLifecycle();

    default public Optional<T> getOptional(@Nullable MinecraftKey var0) {
        return Optional.ofNullable(this.get(var0));
    }

    default public Optional<T> getOptional(@Nullable ResourceKey<T> var0) {
        return Optional.ofNullable(this.get(var0));
    }

    default public T getOrThrow(ResourceKey<T> var0) {
        T var1 = this.get(var0);
        if (var1 == null) {
            throw new IllegalStateException("Missing key in " + this.key() + ": " + var0);
        }
        return var1;
    }

    public Set<MinecraftKey> keySet();

    public Set<Map.Entry<ResourceKey<T>, T>> entrySet();

    public Set<ResourceKey<T>> registryKeySet();

    public Optional<Holder.c<T>> getRandom(RandomSource var1);

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public boolean containsKey(MinecraftKey var1);

    public boolean containsKey(ResourceKey<T> var1);

    public static <T> T register(IRegistry<? super T> var0, String var1, T var2) {
        return IRegistry.register(var0, new MinecraftKey(var1), var2);
    }

    public static <V, T extends V> T register(IRegistry<V> var0, MinecraftKey var1, T var2) {
        return IRegistry.register(var0, ResourceKey.create(var0.key(), var1), var2);
    }

    public static <V, T extends V> T register(IRegistry<V> var0, ResourceKey<V> var1, T var2) {
        ((IRegistryWritable)var0).register(var1, var2, Lifecycle.stable());
        return var2;
    }

    public static <T> Holder.c<T> registerForHolder(IRegistry<T> var0, ResourceKey<T> var1, T var2) {
        return ((IRegistryWritable)var0).register(var1, var2, Lifecycle.stable());
    }

    public static <T> Holder.c<T> registerForHolder(IRegistry<T> var0, MinecraftKey var1, T var2) {
        return IRegistry.registerForHolder(var0, ResourceKey.create(var0.key(), var1), var2);
    }

    public IRegistry<T> freeze();

    public Holder.c<T> createIntrusiveHolder(T var1);

    public Optional<Holder.c<T>> getHolder(int var1);

    public Optional<Holder.c<T>> getHolder(ResourceKey<T> var1);

    public Holder<T> wrapAsHolder(T var1);

    default public Holder.c<T> getHolderOrThrow(ResourceKey<T> var0) {
        return this.getHolder(var0).orElseThrow(() -> new IllegalStateException("Missing key in " + this.key() + ": " + var0));
    }

    public Stream<Holder.c<T>> holders();

    public Optional<HolderSet.Named<T>> getTag(TagKey<T> var1);

    default public Iterable<Holder<T>> getTagOrEmpty(TagKey<T> var0) {
        return (Iterable)DataFixUtils.orElse(this.getTag(var0), List.of());
    }

    public HolderSet.Named<T> getOrCreateTag(TagKey<T> var1);

    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags();

    public Stream<TagKey<T>> getTagNames();

    public void resetTags();

    public void bindTags(Map<TagKey<T>, List<Holder<T>>> var1);

    default public Registry<Holder<T>> asHolderIdMap() {
        return new Registry<Holder<T>>(){

            @Override
            public int getId(Holder<T> var0) {
                return IRegistry.this.getId(var0.value());
            }

            @Override
            @Nullable
            public Holder<T> byId(int var0) {
                return IRegistry.this.getHolder(var0).orElse(null);
            }

            @Override
            public int size() {
                return IRegistry.this.size();
            }

            @Override
            public Iterator<Holder<T>> iterator() {
                return IRegistry.this.holders().map(var0 -> var0).iterator();
            }

            @Override
            @Nullable
            public /* synthetic */ Object byId(int n2) {
                return this.byId(n2);
            }
        };
    }

    public HolderOwner<T> holderOwner();

    public HolderLookup.c<T> asLookup();

    default public HolderLookup.c<T> asTagAddingLookup() {
        return new HolderLookup.c.a<T>(){

            @Override
            protected HolderLookup.c<T> parent() {
                return IRegistry.this.asLookup();
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                return Optional.of(this.getOrThrow(var0));
            }

            @Override
            public HolderSet.Named<T> getOrThrow(TagKey<T> var0) {
                return IRegistry.this.getOrCreateTag(var0);
            }
        };
    }
}

