/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.datafixers.util.Either;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.VisibleForTesting;

public interface HolderSet<T>
extends Iterable<Holder<T>> {
    public Stream<Holder<T>> stream();

    public int size();

    public Either<TagKey<T>, List<Holder<T>>> unwrap();

    public Optional<Holder<T>> getRandomElement(RandomSource var1);

    public Holder<T> get(int var1);

    public boolean contains(Holder<T> var1);

    public boolean canSerializeIn(HolderOwner<T> var1);

    public Optional<TagKey<T>> unwrapKey();

    @Deprecated
    @VisibleForTesting
    public static <T> Named<T> emptyNamed(HolderOwner<T> var0, TagKey<T> var1) {
        return new Named<T>(var0, var1);
    }

    @SafeVarargs
    public static <T> a<T> direct(Holder<T> ... var0) {
        return new a<T>(List.of(var0));
    }

    public static <T> a<T> direct(List<? extends Holder<T>> var0) {
        return new a(List.copyOf(var0));
    }

    @SafeVarargs
    public static <E, T> a<T> direct(Function<E, Holder<T>> var0, E ... var1) {
        return HolderSet.direct(Stream.of(var1).map(var0).toList());
    }

    public static <E, T> a<T> direct(Function<E, Holder<T>> var0, Collection<E> var1) {
        return HolderSet.direct(var1.stream().map(var0).toList());
    }

    public static class Named<T>
    extends b<T> {
        private final HolderOwner<T> owner;
        private final TagKey<T> key;
        private List<Holder<T>> contents = List.of();

        Named(HolderOwner<T> var0, TagKey<T> var1) {
            this.owner = var0;
            this.key = var1;
        }

        void bind(List<Holder<T>> var0) {
            this.contents = List.copyOf(var0);
        }

        public TagKey<T> key() {
            return this.key;
        }

        @Override
        protected List<Holder<T>> contents() {
            return this.contents;
        }

        @Override
        public Either<TagKey<T>, List<Holder<T>>> unwrap() {
            return Either.left(this.key);
        }

        @Override
        public Optional<TagKey<T>> unwrapKey() {
            return Optional.of(this.key);
        }

        @Override
        public boolean contains(Holder<T> var0) {
            return var0.is(this.key);
        }

        public String toString() {
            return "NamedSet(" + this.key + ")[" + this.contents + "]";
        }

        @Override
        public boolean canSerializeIn(HolderOwner<T> var0) {
            return this.owner.canSerializeIn(var0);
        }
    }

    public static class a<T>
    extends b<T> {
        private final List<Holder<T>> contents;
        @Nullable
        private Set<Holder<T>> contentsSet;

        a(List<Holder<T>> var0) {
            this.contents = var0;
        }

        @Override
        protected List<Holder<T>> contents() {
            return this.contents;
        }

        @Override
        public Either<TagKey<T>, List<Holder<T>>> unwrap() {
            return Either.right(this.contents);
        }

        @Override
        public Optional<TagKey<T>> unwrapKey() {
            return Optional.empty();
        }

        @Override
        public boolean contains(Holder<T> var0) {
            if (this.contentsSet == null) {
                this.contentsSet = Set.copyOf(this.contents);
            }
            return this.contentsSet.contains(var0);
        }

        public String toString() {
            return "DirectSet[" + this.contents + "]";
        }
    }

    public static abstract class b<T>
    implements HolderSet<T> {
        protected abstract List<Holder<T>> contents();

        @Override
        public int size() {
            return this.contents().size();
        }

        @Override
        public Spliterator<Holder<T>> spliterator() {
            return this.contents().spliterator();
        }

        @Override
        public Iterator<Holder<T>> iterator() {
            return this.contents().iterator();
        }

        @Override
        public Stream<Holder<T>> stream() {
            return this.contents().stream();
        }

        @Override
        public Optional<Holder<T>> getRandomElement(RandomSource var0) {
            return SystemUtils.getRandomSafe(this.contents(), var0);
        }

        @Override
        public Holder<T> get(int var0) {
            return this.contents().get(var0);
        }

        @Override
        public boolean canSerializeIn(HolderOwner<T> var0) {
            return true;
        }
    }
}

