/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;

public interface HolderLookup<T>
extends HolderGetter<T> {
    public Stream<Holder.c<T>> listElements();

    default public Stream<ResourceKey<T>> listElementIds() {
        return this.listElements().map(Holder.c::key);
    }

    public Stream<HolderSet.Named<T>> listTags();

    default public Stream<TagKey<T>> listTagIds() {
        return this.listTags().map(HolderSet.Named::key);
    }

    default public HolderLookup<T> filterElements(final Predicate<T> var0) {
        return new a<T>(this){

            @Override
            public Optional<Holder.c<T>> get(ResourceKey<T> var02) {
                return this.parent.get(var02).filter(var1 -> var0.test(var1.value()));
            }

            @Override
            public Stream<Holder.c<T>> listElements() {
                return this.parent.listElements().filter(var1 -> var0.test(var1.value()));
            }
        };
    }

    public static interface b {
        public Stream<ResourceKey<? extends IRegistry<?>>> listRegistries();

        public <T> Optional<c<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var1);

        default public <T> c<T> lookupOrThrow(ResourceKey<? extends IRegistry<? extends T>> var0) {
            return this.lookup(var0).orElseThrow(() -> new IllegalStateException("Registry " + var0.location() + " not found"));
        }

        default public HolderGetter.a asGetterLookup() {
            return new HolderGetter.a(){

                @Override
                public <T> Optional<HolderGetter<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var02) {
                    return this.lookup(var02).map(var0 -> var0);
                }
            };
        }

        public static b create(Stream<c<?>> var02) {
            final Map<ResourceKey, c> var1 = var02.collect(Collectors.toUnmodifiableMap(c::key, var0 -> var0));
            return new b(){

                @Override
                public Stream<ResourceKey<? extends IRegistry<?>>> listRegistries() {
                    return var1.keySet().stream();
                }

                @Override
                public <T> Optional<c<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var0) {
                    return Optional.ofNullable((c)var1.get(var0));
                }
            };
        }
    }

    public static class a<T>
    implements HolderLookup<T> {
        protected final HolderLookup<T> parent;

        public a(HolderLookup<T> var0) {
            this.parent = var0;
        }

        @Override
        public Optional<Holder.c<T>> get(ResourceKey<T> var0) {
            return this.parent.get(var0);
        }

        @Override
        public Stream<Holder.c<T>> listElements() {
            return this.parent.listElements();
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
            return this.parent.get(var0);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            return this.parent.listTags();
        }
    }

    public static interface c<T>
    extends HolderLookup<T>,
    HolderOwner<T> {
        public ResourceKey<? extends IRegistry<? extends T>> key();

        public Lifecycle registryLifecycle();

        default public HolderLookup<T> filterFeatures(FeatureFlagSet var0) {
            if (FeatureElement.FILTERED_REGISTRIES.contains(this.key())) {
                return this.filterElements(var1 -> ((FeatureElement)var1).isEnabled(var0));
            }
            return this;
        }

        public static abstract class a<T>
        implements c<T> {
            protected abstract c<T> parent();

            @Override
            public ResourceKey<? extends IRegistry<? extends T>> key() {
                return this.parent().key();
            }

            @Override
            public Lifecycle registryLifecycle() {
                return this.parent().registryLifecycle();
            }

            @Override
            public Optional<Holder.c<T>> get(ResourceKey<T> var0) {
                return this.parent().get(var0);
            }

            @Override
            public Stream<Holder.c<T>> listElements() {
                return this.parent().listElements();
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                return this.parent().get(var0);
            }

            @Override
            public Stream<HolderSet.Named<T>> listTags() {
                return this.parent().listTags();
            }
        }
    }
}

