/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.ScoreHolder;

public class ArgumentScoreholder
implements ArgumentType<b> {
    public static final SuggestionProvider<CommandListenerWrapper> SUGGEST_SCORE_HOLDERS = (var0, var12) -> {
        StringReader var2 = new StringReader(var12.getInput());
        var2.setCursor(var12.getStart());
        ArgumentParserSelector var3 = new ArgumentParserSelector(var2);
        try {
            var3.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return var3.fillSuggestions(var12, var1 -> ICompletionProvider.suggest(((CommandListenerWrapper)var0.getSource()).getOnlinePlayerNames(), var1));
    };
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "*", "@e");
    private static final SimpleCommandExceptionType ERROR_NO_RESULTS = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.scoreHolder.empty"));
    final boolean multiple;

    public ArgumentScoreholder(boolean var0) {
        this.multiple = var0;
    }

    public static ScoreHolder getName(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ArgumentScoreholder.getNames(var0, var1).iterator().next();
    }

    public static Collection<ScoreHolder> getNames(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ArgumentScoreholder.getNames(var0, var1, Collections::emptyList);
    }

    public static Collection<ScoreHolder> getNamesWithDefaultWildcard(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ArgumentScoreholder.getNames(var0, var1, ((CommandListenerWrapper)var0.getSource()).getServer().getScoreboard()::getTrackedPlayers);
    }

    public static Collection<ScoreHolder> getNames(CommandContext<CommandListenerWrapper> var0, String var1, Supplier<Collection<ScoreHolder>> var2) throws CommandSyntaxException {
        Collection<ScoreHolder> var3 = ((b)var0.getArgument(var1, b.class)).getNames((CommandListenerWrapper)var0.getSource(), var2);
        if (var3.isEmpty()) {
            throw ArgumentEntity.NO_ENTITIES_FOUND.create();
        }
        return var3;
    }

    public static ArgumentScoreholder scoreHolder() {
        return new ArgumentScoreholder(false);
    }

    public static ArgumentScoreholder scoreHolders() {
        return new ArgumentScoreholder(true);
    }

    public b parse(StringReader var02) throws CommandSyntaxException {
        if (var02.canRead() && var02.peek() == '@') {
            ArgumentParserSelector var12 = new ArgumentParserSelector(var02);
            EntitySelector var22 = var12.parse();
            if (!this.multiple && var22.getMaxResults() > 1) {
                throw ArgumentEntity.ERROR_NOT_SINGLE_ENTITY.create();
            }
            return new c(var22);
        }
        int var13 = var02.getCursor();
        while (var02.canRead() && var02.peek() != ' ') {
            var02.skip();
        }
        String var23 = var02.getString().substring(var13, var02.getCursor());
        if (var23.equals("*")) {
            return (var0, var1) -> {
                Collection var2 = (Collection)var1.get();
                if (var2.isEmpty()) {
                    throw ERROR_NO_RESULTS.create();
                }
                return var2;
            };
        }
        List<ScoreHolder> var32 = List.of(ScoreHolder.forNameOnly(var23));
        if (var23.startsWith("#")) {
            return (var1, var2) -> var32;
        }
        try {
            UUID var4 = UUID.fromString(var23);
            return (var2, var3) -> {
                MinecraftServer var4 = var2.getServer();
                Entity var5 = null;
                ArrayList<Entity> var6 = null;
                for (WorldServer var8 : var4.getAllLevels()) {
                    Entity var9 = var8.getEntity(var4);
                    if (var9 == null) continue;
                    if (var5 == null) {
                        var5 = var9;
                        continue;
                    }
                    if (var6 == null) {
                        var6 = new ArrayList<Entity>();
                        var6.add(var5);
                    }
                    var6.add(var9);
                }
                if (var6 != null) {
                    return var6;
                }
                if (var5 != null) {
                    return List.of(var5);
                }
                return var32;
            };
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (var2, var3) -> {
                MinecraftServer var4 = var2.getServer();
                EntityPlayer var5 = var4.getPlayerList().getPlayerByName(var23);
                if (var5 != null) {
                    return List.of(var5);
                }
                return var32;
            };
        }
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    @FunctionalInterface
    public static interface b {
        public Collection<ScoreHolder> getNames(CommandListenerWrapper var1, Supplier<Collection<ScoreHolder>> var2) throws CommandSyntaxException;
    }

    public static class c
    implements b {
        private final EntitySelector selector;

        public c(EntitySelector var0) {
            this.selector = var0;
        }

        @Override
        public Collection<ScoreHolder> getNames(CommandListenerWrapper var0, Supplier<Collection<ScoreHolder>> var1) throws CommandSyntaxException {
            List<? extends Entity> var2 = this.selector.findEntities(var0);
            if (var2.isEmpty()) {
                throw ArgumentEntity.NO_ENTITIES_FOUND.create();
            }
            return List.copyOf(var2);
        }
    }

    public static class net.minecraft.commands.arguments.ArgumentScoreholder$a
    implements ArgumentTypeInfo<ArgumentScoreholder, a> {
        private static final byte FLAG_MULTIPLE = 1;

        @Override
        public void serializeToNetwork(a var0, PacketDataSerializer var1) {
            int var2 = 0;
            if (var0.multiple) {
                var2 |= 1;
            }
            var1.writeByte(var2);
        }

        @Override
        public a deserializeFromNetwork(PacketDataSerializer var0) {
            byte var1 = var0.readByte();
            boolean var2 = (var1 & 1) != 0;
            return new a(var2);
        }

        @Override
        public void serializeToJson(a var0, JsonObject var1) {
            var1.addProperty("amount", var0.multiple ? "multiple" : "single");
        }

        @Override
        public a unpack(ArgumentScoreholder var0) {
            return new a(var0.multiple);
        }

        @Override
        public /* synthetic */ ArgumentTypeInfo.a deserializeFromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.deserializeFromNetwork(packetDataSerializer);
        }

        public final class a
        implements ArgumentTypeInfo.a<ArgumentScoreholder> {
            final boolean multiple;

            a(boolean var1) {
                this.multiple = var1;
            }

            @Override
            public ArgumentScoreholder instantiate(CommandBuildContext var0) {
                return new ArgumentScoreholder(this.multiple);
            }

            @Override
            public ArgumentTypeInfo<ArgumentScoreholder, ?> type() {
                return a.this;
            }

            @Override
            public /* synthetic */ ArgumentType instantiate(CommandBuildContext commandBuildContext) {
                return this.instantiate(commandBuildContext);
            }
        }
    }
}

