/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.scores.DisplaySlot;

public class ArgumentScoreboardSlot
implements ArgumentType<DisplaySlot> {
    private static final Collection<String> EXAMPLES = Arrays.asList("sidebar", "foo.bar");
    public static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.scoreboardDisplaySlot.invalid", var0));

    private ArgumentScoreboardSlot() {
    }

    public static ArgumentScoreboardSlot displaySlot() {
        return new ArgumentScoreboardSlot();
    }

    public static DisplaySlot getDisplaySlot(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (DisplaySlot)var0.getArgument(var1, DisplaySlot.class);
    }

    public DisplaySlot parse(StringReader var0) throws CommandSyntaxException {
        String var1 = var0.readUnquotedString();
        DisplaySlot var2 = DisplaySlot.CODEC.byName(var1);
        if (var2 == null) {
            throw ERROR_INVALID_VALUE.create((Object)var1);
        }
        return var2;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.suggest(Arrays.stream(DisplaySlot.values()).map(DisplaySlot::getSerializedName), var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

