/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class ArgumentScoreboardCriteria
implements ArgumentType<IScoreboardCriteria> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo.bar.baz", "minecraft:foo");
    public static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.criteria.invalid", var0));

    private ArgumentScoreboardCriteria() {
    }

    public static ArgumentScoreboardCriteria criteria() {
        return new ArgumentScoreboardCriteria();
    }

    public static IScoreboardCriteria getCriteria(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (IScoreboardCriteria)var0.getArgument(var1, IScoreboardCriteria.class);
    }

    public IScoreboardCriteria parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        while (var0.canRead() && var0.peek() != ' ') {
            var0.skip();
        }
        String var2 = var0.getString().substring(var1, var0.getCursor());
        return IScoreboardCriteria.byName(var2).orElseThrow(() -> {
            var0.setCursor(var1);
            return ERROR_INVALID_VALUE.create((Object)var2);
        });
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        ArrayList var2 = Lists.newArrayList(IScoreboardCriteria.getCustomCriteriaNames());
        for (StatisticWrapper statisticWrapper : BuiltInRegistries.STAT_TYPE) {
            for (Object var6 : statisticWrapper.getRegistry()) {
                String var7 = this.getName(statisticWrapper, var6);
                var2.add(var7);
            }
        }
        return ICompletionProvider.suggest(var2, var1);
    }

    public <T> String getName(StatisticWrapper<T> var0, Object var1) {
        return Statistic.buildName(var0, var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

