/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.EnumItemSlot;

public class ArgumentInventorySlot
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("container.5", "12", "weapon");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_SLOT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("slot.unknown", var0));
    private static final Map<String, Integer> SLOTS = SystemUtils.make(Maps.newHashMap(), var0 -> {
        int var1;
        for (var1 = 0; var1 < 54; ++var1) {
            var0.put("container." + var1, var1);
        }
        for (var1 = 0; var1 < 9; ++var1) {
            var0.put("hotbar." + var1, var1);
        }
        for (var1 = 0; var1 < 27; ++var1) {
            var0.put("inventory." + var1, 9 + var1);
        }
        for (var1 = 0; var1 < 27; ++var1) {
            var0.put("enderchest." + var1, 200 + var1);
        }
        for (var1 = 0; var1 < 8; ++var1) {
            var0.put("villager." + var1, 300 + var1);
        }
        for (var1 = 0; var1 < 15; ++var1) {
            var0.put("horse." + var1, 500 + var1);
        }
        var0.put("weapon", EnumItemSlot.MAINHAND.getIndex(98));
        var0.put("weapon.mainhand", EnumItemSlot.MAINHAND.getIndex(98));
        var0.put("weapon.offhand", EnumItemSlot.OFFHAND.getIndex(98));
        var0.put("armor.head", EnumItemSlot.HEAD.getIndex(100));
        var0.put("armor.chest", EnumItemSlot.CHEST.getIndex(100));
        var0.put("armor.legs", EnumItemSlot.LEGS.getIndex(100));
        var0.put("armor.feet", EnumItemSlot.FEET.getIndex(100));
        var0.put("horse.saddle", 400);
        var0.put("horse.armor", 401);
        var0.put("horse.chest", 499);
    });

    public static ArgumentInventorySlot slot() {
        return new ArgumentInventorySlot();
    }

    public static int getSlot(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (Integer)var0.getArgument(var1, Integer.class);
    }

    public Integer parse(StringReader var0) throws CommandSyntaxException {
        String var1 = var0.readUnquotedString();
        if (!SLOTS.containsKey(var1)) {
            throw ERROR_UNKNOWN_SLOT.create((Object)var1);
        }
        return SLOTS.get(var1);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.suggest(SLOTS.keySet(), var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

