/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;

public class ArgumentChatFormat
implements ArgumentType<EnumChatFormat> {
    private static final Collection<String> EXAMPLES = Arrays.asList("red", "green");
    public static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.color.invalid", var0));

    private ArgumentChatFormat() {
    }

    public static ArgumentChatFormat color() {
        return new ArgumentChatFormat();
    }

    public static EnumChatFormat getColor(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (EnumChatFormat)var0.getArgument(var1, EnumChatFormat.class);
    }

    public EnumChatFormat parse(StringReader var0) throws CommandSyntaxException {
        String var1 = var0.readUnquotedString();
        EnumChatFormat var2 = EnumChatFormat.getByName(var1);
        if (var2 == null || var2.isFormat()) {
            throw ERROR_INVALID_VALUE.create((Object)var1);
        }
        return var2;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        return ICompletionProvider.suggest(EnumChatFormat.getNames(true, false), var1);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

