/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.SignedArgument;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.FilteredText;

public class ArgumentChat
implements SignedArgument<a> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");

    public static ArgumentChat message() {
        return new ArgumentChat();
    }

    public static IChatBaseComponent getMessage(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        a var2 = (a)var0.getArgument(var1, a.class);
        return var2.resolveComponent((CommandListenerWrapper)var0.getSource());
    }

    public static void resolveChatMessage(CommandContext<CommandListenerWrapper> var0, String var1, Consumer<PlayerChatMessage> var2) throws CommandSyntaxException {
        a var3 = (a)var0.getArgument(var1, a.class);
        CommandListenerWrapper var4 = (CommandListenerWrapper)var0.getSource();
        IChatBaseComponent var5 = var3.resolveComponent(var4);
        CommandSigningContext var6 = var4.getSigningContext();
        PlayerChatMessage var7 = var6.getArgument(var1);
        if (var7 != null) {
            ArgumentChat.resolveSignedMessage(var2, var4, var7.withUnsignedContent(var5));
        } else {
            ArgumentChat.resolveDisguisedMessage(var2, var4, PlayerChatMessage.system(var3.text).withUnsignedContent(var5));
        }
    }

    private static void resolveSignedMessage(Consumer<PlayerChatMessage> var0, CommandListenerWrapper var1, PlayerChatMessage var2) {
        MinecraftServer var32 = var1.getServer();
        CompletableFuture<FilteredText> var4 = ArgumentChat.filterPlainText(var1, var2);
        IChatBaseComponent var5 = var32.getChatDecorator().decorate(var1.getPlayer(), var2.decoratedContent());
        var1.getChatMessageChainer().append(var4, var3 -> {
            PlayerChatMessage var4 = var2.withUnsignedContent(var5).filter(var3.mask());
            var0.accept(var4);
        });
    }

    private static void resolveDisguisedMessage(Consumer<PlayerChatMessage> var0, CommandListenerWrapper var1, PlayerChatMessage var2) {
        ChatDecorator var3 = var1.getServer().getChatDecorator();
        IChatBaseComponent var4 = var3.decorate(var1.getPlayer(), var2.decoratedContent());
        var0.accept(var2.withUnsignedContent(var4));
    }

    private static CompletableFuture<FilteredText> filterPlainText(CommandListenerWrapper var0, PlayerChatMessage var1) {
        EntityPlayer var2 = var0.getPlayer();
        if (var2 != null && var1.hasSignatureFrom(var2.getUUID())) {
            return var2.getTextFilter().processStreamMessage(var1.signedContent());
        }
        return CompletableFuture.completedFuture(FilteredText.passThrough(var1.signedContent()));
    }

    public a parse(StringReader var0) throws CommandSyntaxException {
        return a.parseText(var0, true);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class a {
        final String text;
        private final b[] parts;

        public a(String var0, b[] var1) {
            this.text = var0;
            this.parts = var1;
        }

        public String getText() {
            return this.text;
        }

        public b[] getParts() {
            return this.parts;
        }

        IChatBaseComponent resolveComponent(CommandListenerWrapper var0) throws CommandSyntaxException {
            return this.toComponent(var0, var0.hasPermission(2));
        }

        public IChatBaseComponent toComponent(CommandListenerWrapper var0, boolean var1) throws CommandSyntaxException {
            if (this.parts.length == 0 || !var1) {
                return IChatBaseComponent.literal(this.text);
            }
            IChatMutableComponent var2 = IChatBaseComponent.literal(this.text.substring(0, this.parts[0].getStart()));
            int var3 = this.parts[0].getStart();
            for (b var7 : this.parts) {
                IChatBaseComponent var8 = var7.toComponent(var0);
                if (var3 < var7.getStart()) {
                    var2.append(this.text.substring(var3, var7.getStart()));
                }
                if (var8 != null) {
                    var2.append(var8);
                }
                var3 = var7.getEnd();
            }
            if (var3 < this.text.length()) {
                var2.append(this.text.substring(var3));
            }
            return var2;
        }

        public static a parseText(StringReader var0, boolean var1) throws CommandSyntaxException {
            String var2 = var0.getString().substring(var0.getCursor(), var0.getTotalLength());
            if (!var1) {
                var0.setCursor(var0.getTotalLength());
                return new a(var2, new b[0]);
            }
            ArrayList var3 = Lists.newArrayList();
            int var4 = var0.getCursor();
            while (var0.canRead()) {
                if (var0.peek() == '@') {
                    EntitySelector var6;
                    int var5 = var0.getCursor();
                    try {
                        ArgumentParserSelector var7 = new ArgumentParserSelector(var0);
                        var6 = var7.parse();
                    }
                    catch (CommandSyntaxException var7) {
                        if (var7.getType() == ArgumentParserSelector.ERROR_MISSING_SELECTOR_TYPE || var7.getType() == ArgumentParserSelector.ERROR_UNKNOWN_SELECTOR_TYPE) {
                            var0.setCursor(var5 + 1);
                            continue;
                        }
                        throw var7;
                    }
                    var3.add(new b(var5 - var4, var0.getCursor() - var4, var6));
                    continue;
                }
                var0.skip();
            }
            return new a(var2, var3.toArray(new b[0]));
        }
    }

    public static class b {
        private final int start;
        private final int end;
        private final EntitySelector selector;

        public b(int var0, int var1, EntitySelector var2) {
            this.start = var0;
            this.end = var1;
            this.selector = var2;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public EntitySelector getSelector() {
            return this.selector;
        }

        @Nullable
        public IChatBaseComponent toComponent(CommandListenerWrapper var0) throws CommandSyntaxException {
            return EntitySelector.joinNames(this.selector.findEntities(var0));
        }
    }
}

