/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class LightningStrikeTrigger
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    public void trigger(EntityPlayer var0, EntityLightning var12, List<Entity> var22) {
        List var3 = var22.stream().map(var1 -> CriterionConditionEntity.createContext(var0, var1)).collect(Collectors.toList());
        LootTableInfo var4 = CriterionConditionEntity.createContext(var0, var12);
        this.trigger(var0, var2 -> var2.matches(var4, var3));
    }

    public record a(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> lightning, Optional<ContextAwarePredicate> bystander) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.ADVANCEMENT_CODEC, "player").forGetter(a::player), (App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.ADVANCEMENT_CODEC, "lightning").forGetter(a::lightning), (App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.ADVANCEMENT_CODEC, "bystander").forGetter(a::bystander)).apply((Applicative)var0, a::new));

        public static Criterion<a> lightningStrike(Optional<CriterionConditionEntity> var0, Optional<CriterionConditionEntity> var1) {
            return CriterionTriggers.LIGHTNING_STRIKE.createCriterion(new a(Optional.empty(), CriterionConditionEntity.wrap(var0), CriterionConditionEntity.wrap(var1)));
        }

        public boolean matches(LootTableInfo var0, List<LootTableInfo> var1) {
            if (this.lightning.isPresent() && !this.lightning.get().matches(var0)) {
                return false;
            }
            if (this.bystander.isPresent()) {
                if (var1.stream().noneMatch(this.bystander.get()::matches)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            var0.validateEntity(this.lightning, ".lightning");
            var0.validateEntity(this.bystander, ".bystander");
        }
    }
}

