/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionInOpenWater;
import net.minecraft.advancements.critereon.CriterionConditionPlayer;
import net.minecraft.advancements.critereon.EntityVariantPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.HorseColor;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.phys.Vec3D;

public interface EntitySubPredicate {
    public static final Codec<EntitySubPredicate> CODEC = b.TYPE_CODEC.dispatch(EntitySubPredicate::type, var0 -> var0.codec().codec());

    public boolean matches(Entity var1, WorldServer var2, @Nullable Vec3D var3);

    public a type();

    public static EntitySubPredicate variant(CatVariant var0) {
        return b.CAT.createPredicate(var0);
    }

    public static EntitySubPredicate variant(FrogVariant var0) {
        return b.FROG.createPredicate(var0);
    }

    public static final class b {
        public static final a ANY = new a((MapCodec<? extends EntitySubPredicate>)MapCodec.unit((Object)new EntitySubPredicate(){

            @Override
            public boolean matches(Entity var0, WorldServer var1, @Nullable Vec3D var2) {
                return true;
            }

            @Override
            public a type() {
                return ANY;
            }
        }));
        public static final a LIGHTNING = new a(LightningBoltPredicate.CODEC);
        public static final a FISHING_HOOK = new a(CriterionConditionInOpenWater.CODEC);
        public static final a PLAYER = new a(CriterionConditionPlayer.CODEC);
        public static final a SLIME = new a(SlimePredicate.CODEC);
        public static final EntityVariantPredicate<CatVariant> CAT = EntityVariantPredicate.create(BuiltInRegistries.CAT_VARIANT, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityCat) {
                EntityCat var1 = (EntityCat)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<FrogVariant> FROG = EntityVariantPredicate.create(BuiltInRegistries.FROG_VARIANT, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof Frog) {
                Frog var1 = (Frog)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<Axolotl.Variant> AXOLOTL = EntityVariantPredicate.create(Axolotl.Variant.CODEC, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof Axolotl) {
                Axolotl var1 = (Axolotl)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<EntityBoat.EnumBoatType> BOAT = EntityVariantPredicate.create(EntityBoat.EnumBoatType.CODEC, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityBoat) {
                EntityBoat var1 = (EntityBoat)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<EntityFox.Type> FOX = EntityVariantPredicate.create(EntityFox.Type.CODEC, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityFox) {
                EntityFox var1 = (EntityFox)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<EntityMushroomCow.Type> MOOSHROOM = EntityVariantPredicate.create(EntityMushroomCow.Type.CODEC, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityMushroomCow) {
                EntityMushroomCow var1 = (EntityMushroomCow)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<Holder<PaintingVariant>> PAINTING = EntityVariantPredicate.create(BuiltInRegistries.PAINTING_VARIANT.holderByNameCodec(), var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityPainting) {
                EntityPainting var1 = (EntityPainting)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<EntityRabbit.Variant> RABBIT = EntityVariantPredicate.create(EntityRabbit.Variant.CODEC, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityRabbit) {
                EntityRabbit var1 = (EntityRabbit)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<HorseColor> HORSE = EntityVariantPredicate.create(HorseColor.CODEC, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityHorse) {
                EntityHorse var1 = (EntityHorse)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<EntityLlama.Variant> LLAMA = EntityVariantPredicate.create(EntityLlama.Variant.CODEC, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityLlama) {
                EntityLlama var1 = (EntityLlama)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<VillagerType> VILLAGER = EntityVariantPredicate.create(BuiltInRegistries.VILLAGER_TYPE.byNameCodec(), var0 -> {
            Optional<Object> optional;
            if (var0 instanceof VillagerDataHolder) {
                VillagerDataHolder var1 = (VillagerDataHolder)((Object)var0);
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<EntityParrot.Variant> PARROT = EntityVariantPredicate.create(EntityParrot.Variant.CODEC, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityParrot) {
                EntityParrot var1 = (EntityParrot)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final EntityVariantPredicate<EntityTropicalFish.Variant> TROPICAL_FISH = EntityVariantPredicate.create(EntityTropicalFish.Variant.CODEC, var0 -> {
            Optional<Object> optional;
            if (var0 instanceof EntityTropicalFish) {
                EntityTropicalFish var1 = (EntityTropicalFish)var0;
                optional = Optional.of(var1.getVariant());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        public static final BiMap<String, a> TYPES = ImmutableBiMap.builder().put((Object)"any", (Object)ANY).put((Object)"lightning", (Object)LIGHTNING).put((Object)"fishing_hook", (Object)FISHING_HOOK).put((Object)"player", (Object)PLAYER).put((Object)"slime", (Object)SLIME).put((Object)"cat", (Object)CAT.type()).put((Object)"frog", (Object)FROG.type()).put((Object)"axolotl", (Object)AXOLOTL.type()).put((Object)"boat", (Object)BOAT.type()).put((Object)"fox", (Object)FOX.type()).put((Object)"mooshroom", (Object)MOOSHROOM.type()).put((Object)"painting", (Object)PAINTING.type()).put((Object)"rabbit", (Object)RABBIT.type()).put((Object)"horse", (Object)HORSE.type()).put((Object)"llama", (Object)LLAMA.type()).put((Object)"villager", (Object)VILLAGER.type()).put((Object)"parrot", (Object)PARROT.type()).put((Object)"tropical_fish", (Object)TROPICAL_FISH.type()).buildOrThrow();
        public static final Codec<a> TYPE_CODEC = ExtraCodecs.stringResolverCodec(arg_0 -> TYPES.inverse().get(arg_0), arg_0 -> TYPES.get(arg_0));
    }

    public record a(MapCodec<? extends EntitySubPredicate> codec) {
    }
}

