/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionConditionEntity;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.CriterionTriggerAbstract;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootTableInfo;

public class CriterionTriggerKilledByCrossbow
extends CriterionTriggerAbstract<a> {
    @Override
    public Codec<a> codec() {
        return a.CODEC;
    }

    @Override
    public void trigger(EntityPlayer var0, Collection<Entity> var1) {
        ArrayList var22 = Lists.newArrayList();
        HashSet var3 = Sets.newHashSet();
        for (Entity var5 : var1) {
            var3.add(var5.getType());
            var22.add(CriterionConditionEntity.createContext(var0, var5));
        }
        this.trigger(var0, (T var2) -> var2.matches(var22, var3.size()));
    }

    public record a(Optional<ContextAwarePredicate> player, List<ContextAwarePredicate> victims, CriterionConditionValue.IntegerRange uniqueEntityTypes) implements CriterionTriggerAbstract.a
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.ADVANCEMENT_CODEC, "player").forGetter(a::player), (App)ExtraCodecs.strictOptionalField(CriterionConditionEntity.ADVANCEMENT_CODEC.listOf(), "victims", List.of()).forGetter(a::victims), (App)ExtraCodecs.strictOptionalField(CriterionConditionValue.IntegerRange.CODEC, "unique_entity_types", CriterionConditionValue.IntegerRange.ANY).forGetter(a::uniqueEntityTypes)).apply((Applicative)var0, a::new));

        public static Criterion<a> crossbowKilled(CriterionConditionEntity.a ... var0) {
            return CriterionTriggers.KILLED_BY_CROSSBOW.createCriterion(new a(Optional.empty(), CriterionConditionEntity.wrap(var0), CriterionConditionValue.IntegerRange.ANY));
        }

        public static Criterion<a> crossbowKilled(CriterionConditionValue.IntegerRange var0) {
            return CriterionTriggers.KILLED_BY_CROSSBOW.createCriterion(new a(Optional.empty(), List.of(), var0));
        }

        public boolean matches(Collection<LootTableInfo> var0, int var1) {
            if (!this.victims.isEmpty()) {
                ArrayList var2 = Lists.newArrayList(var0);
                for (ContextAwarePredicate var4 : this.victims) {
                    boolean var5 = false;
                    Iterator var6 = var2.iterator();
                    while (var6.hasNext()) {
                        LootTableInfo var7 = (LootTableInfo)var6.next();
                        if (!var4.matches(var7)) continue;
                        var6.remove();
                        var5 = true;
                        break;
                    }
                    if (var5) continue;
                    return false;
                }
            }
            return this.uniqueEntityTypes.matches(var1);
        }

        @Override
        public void validate(CriterionValidator var0) {
            CriterionTriggerAbstract.a.super.validate(var0);
            var0.validateEntities(this.victims, ".victims");
        }
    }
}

